/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.ResultSetNode;

public class ReferencedTablesVisitor
implements Visitor {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1999, 2004.";
    private JBitSet tableMap;

    public Visitable visit(Visitable visitable) throws StandardException {
        if (visitable instanceof ColumnReference) {
            ((ColumnReference)visitable).getTablesReferenced(this.tableMap);
        } else if (visitable instanceof Predicate) {
            Predicate predicate = (Predicate)visitable;
            this.tableMap.or(predicate.getReferencedSet());
        } else if (visitable instanceof ResultSetNode) {
            ResultSetNode resultSetNode = (ResultSetNode)visitable;
            this.tableMap.or(resultSetNode.getReferencedTableMap());
        }
        return visitable;
    }

    public boolean skipChildren(Visitable visitable) {
        return visitable instanceof Predicate || visitable instanceof ResultSetNode;
    }

    public boolean stopTraversal() {
        return false;
    }

    JBitSet getTableMap() {
        return this.tableMap;
    }

    public ReferencedTablesVisitor(JBitSet jBitSet) {
        this.tableMap = jBitSet;
    }
}

