/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.impl.sql.execute.ValueRow;

public class IndexRow
extends ValueRow
implements ExecIndexRow {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private boolean[] orderedNulls;

    public void orderedNulls(int n) {
        this.orderedNulls[n] = true;
    }

    public boolean areNullsOrdered(int n) {
        return this.orderedNulls[n];
    }

    public void execRowToExecIndexRow(ExecRow execRow) {
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        int n = this.nColumns();
        this.orderedNulls = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            this.orderedNulls[n2] = objectInput.readBoolean();
            ++n2;
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        int n = this.nColumns();
        int n2 = 0;
        while (n2 < n) {
            objectOutput.writeBoolean(this.orderedNulls[n2]);
            ++n2;
        }
    }

    public int getTypeFormatId() {
        return 238;
    }

    ExecRow cloneMe() {
        return new IndexRow(this.nColumns());
    }

    public IndexRow() {
    }

    public IndexRow(int n) {
        super(n);
        this.orderedNulls = new boolean[n];
    }
}

