/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.TriggerInfo;
import org.apache.derby.impl.sql.execute.WriteCursorConstantAction;

public class InsertConstantAction
extends WriteCursorConstantAction {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    boolean[] indexedCols;
    private String schemaName;
    private String tableName;
    private String[] columnNames;
    protected RowLocation[] autoincRowLocation;
    private long[] autoincIncrement;

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n;
        Object[] objectArray = null;
        super.readExternal(objectInput);
        this.indexedCols = ArrayUtil.readBooleanArray(objectInput);
        objectArray = ArrayUtil.readObjectArray(objectInput);
        if (objectArray != null) {
            this.autoincRowLocation = new RowLocation[objectArray.length];
            n = 0;
            while (n < objectArray.length) {
                this.autoincRowLocation[n] = (RowLocation)objectArray[n];
                ++n;
            }
        }
        this.schemaName = (String)objectInput.readObject();
        this.tableName = (String)objectInput.readObject();
        objectArray = ArrayUtil.readObjectArray(objectInput);
        if (objectArray != null) {
            this.columnNames = new String[objectArray.length];
            n = 0;
            while (n < objectArray.length) {
                this.columnNames[n] = (String)objectArray[n];
                ++n;
            }
        }
        this.autoincIncrement = ArrayUtil.readLongArray(objectInput);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        ArrayUtil.writeBooleanArray(objectOutput, this.indexedCols);
        ArrayUtil.writeArray(objectOutput, this.autoincRowLocation);
        objectOutput.writeObject(this.schemaName);
        objectOutput.writeObject(this.tableName);
        ArrayUtil.writeArray(objectOutput, this.columnNames);
        ArrayUtil.writeLongArray(objectOutput, this.autoincIncrement);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public long getAutoincIncrement(int n) {
        return this.autoincIncrement[n];
    }

    public boolean hasAutoincrement() {
        return this.autoincRowLocation != null;
    }

    public RowLocation[] getAutoincRowLocation() {
        return this.autoincRowLocation;
    }

    public int getTypeFormatId() {
        return 38;
    }

    public InsertConstantAction() {
    }

    public InsertConstantAction(TableDescriptor tableDescriptor, long l, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, IndexRowGenerator[] indexRowGeneratorArray, long[] lArray, StaticCompiledOpenConglomInfo[] staticCompiledOpenConglomInfoArray, String[] stringArray, boolean bl, Properties properties, UUID uUID, int n, FKInfo[] fKInfoArray, TriggerInfo triggerInfo, int[] nArray, boolean[] blArray, boolean bl2, RowLocation[] rowLocationArray) {
        super(l, staticCompiledOpenConglomInfo, indexRowGeneratorArray, lArray, staticCompiledOpenConglomInfoArray, stringArray, bl, properties, uUID, n, fKInfoArray, triggerInfo, null, null, null, nArray, bl2);
        this.indexedCols = blArray;
        this.autoincRowLocation = rowLocationArray;
        this.schemaName = tableDescriptor.getSchemaName();
        this.tableName = tableDescriptor.getName();
        this.columnNames = tableDescriptor.getColumnNamesArray();
        this.autoincIncrement = tableDescriptor.getAutoincIncrementArray();
        this.indexNames = stringArray;
    }
}

