/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.catalog.types.StatisticsImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.StatementUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.StatisticsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.RowChanger;
import org.apache.derby.iapi.sql.execute.TargetResultSet;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.GenericScanController;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.SortObserver;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.execute.AutoincrementCounter;
import org.apache.derby.impl.sql.execute.BasicSortObserver;
import org.apache.derby.impl.sql.execute.BulkTableScanResultSet;
import org.apache.derby.impl.sql.execute.CardinalityCounter;
import org.apache.derby.impl.sql.execute.DMLWriteResultSet;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.IndexColumnOrder;
import org.apache.derby.impl.sql.execute.InsertConstantAction;
import org.apache.derby.impl.sql.execute.InternalTriggerExecutionContext;
import org.apache.derby.impl.sql.execute.NormalizeResultSet;
import org.apache.derby.impl.sql.execute.RIBulkChecker;
import org.apache.derby.impl.sql.execute.RISetChecker;
import org.apache.derby.impl.sql.execute.RowResultSet;
import org.apache.derby.impl.sql.execute.RowUtil;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;
import org.apache.derby.impl.sql.execute.TriggerEventActivator;
import org.apache.derby.impl.sql.execute.TriggerEvents;
import org.apache.derby.impl.sql.execute.TriggerInfo;
import org.apache.derby.impl.sql.execute.UniqueIndexSortObserver;
import org.apache.derby.impl.sql.execute.UpdateResultSet;
import org.apache.derby.impl.sql.execute.ValueRow;

public class InsertResultSet
extends DMLWriteResultSet
implements TargetResultSet {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private NoPutResultSet sourceResultSet;
    public NoPutResultSet savedSource;
    public InsertConstantAction constants;
    private GeneratedMethod checkGM;
    private long heapConglom;
    public ResultSet autoGeneratedKeysResultSet;
    private TemporaryRowHolderImpl autoGeneratedKeysRowsHolder;
    public ResultDescription resultDescription;
    private RowChanger rowChanger;
    public TransactionController tc;
    public ExecRow row;
    public LanguageConnectionContext lcc;
    public boolean userSpecifiedBulkInsert;
    public boolean bulkInsertPerformed;
    protected boolean bulkInsert;
    private boolean bulkInsertReplace;
    private boolean firstRow = true;
    private boolean[] needToDropSort;
    private Hashtable indexConversionTable;
    private FormatableBitSet indexedCols;
    private ConglomerateController bulkHeapCC;
    protected DataDictionary dd;
    protected TableDescriptor td;
    private ExecIndexRow[] indexRows;
    private ExecRow fullTemplate;
    private long[] sortIds;
    private RowLocationRetRowSource[] rowSources;
    private ScanController bulkHeapSC;
    private ColumnOrdering[][] ordering;
    private SortController[] sorters;
    private TemporaryRowHolderImpl rowHolder;
    private RowLocation rl;
    private boolean hasBeforeStatementTrigger;
    private boolean hasBeforeRowTrigger;
    private BulkTableScanResultSet tableScan;
    private int numOpens;
    private boolean firstExecute;
    private FKInfo[] fkInfoArray;
    private TriggerInfo triggerInfo;
    private RISetChecker fkChecker;
    private TriggerEventActivator triggerActivator;
    private NumberDataValue[] aiCache;
    protected boolean autoincrementGenerated;
    private long identityVal;
    private boolean setIdentity;

    public ResultDescription getResultDescription() {
        return this.resultDescription;
    }

    public void changedRow(ExecRow execRow, RowLocation rowLocation) throws StandardException {
        if (this.constants.irgs.length > 0) {
            RowLocation rowLocation2 = (RowLocation)rowLocation.cloneObject();
            int n = 0;
            while (n < execRow.getRowArray().length) {
                if (this.constants.indexedCols[n] && execRow.getRowArray()[n] instanceof StreamStorable) {
                    execRow.getRowArray()[n].getObject();
                }
                ++n;
            }
            if (this.firstRow) {
                this.firstRow = false;
                this.indexRows = new ExecIndexRow[this.constants.irgs.length];
                this.setUpAllSorts(execRow.getNewNullRow(), rowLocation2);
            }
            n = 0;
            while (n < this.constants.irgs.length) {
                this.indexRows[n].getNewObjectArray();
                this.constants.irgs[n].getIndexRow(execRow, rowLocation2, this.indexRows[n], null);
                this.sorters[n].insert(this.indexRows[n].getRowArray());
                ++n;
            }
        }
    }

    public ExecRow preprocessSourceRow(ExecRow execRow) throws StandardException {
        if (this.hasBeforeRowTrigger) {
            this.rowHolder.truncate();
            this.rowHolder.insert(execRow);
            this.triggerActivator.notifyEvent(TriggerEvents.BEFORE_INSERT, null, this.rowHolder.getResultSet());
        }
        if (this.checkGM != null && !this.hasBeforeStatementTrigger) {
            this.evaluateCheckConstraints();
        }
        if (this.constants.irgs.length > 0) {
            return execRow.getClone(this.indexedCols);
        }
        return execRow;
    }

    private void evaluateCheckConstraints() throws StandardException {
        if (this.checkGM != null) {
            this.checkGM.invoke(this.activation);
        }
    }

    public void open() throws StandardException {
        this.firstExecute = this.rowChanger == null;
        this.autoincrementGenerated = false;
        this.dd = this.lcc.getDataDictionary();
        if (this.activation.getAutoGeneratedKeysResultsetMode()) {
            if (this.activation.getAutoGeneratedKeysColumnIndexes() != null) {
                this.verifyAutoGeneratedColumnsIndexes(this.activation.getAutoGeneratedKeysColumnIndexes());
            } else if (this.activation.getAutoGeneratedKeysColumnNames() != null) {
                this.verifyAutoGeneratedColumnsNames(this.activation.getAutoGeneratedKeysColumnNames());
            }
        }
        this.rowCount = 0;
        if (this.numOpens++ == 0) {
            this.sourceResultSet.openCore();
        } else {
            this.sourceResultSet.reopenCore();
        }
        if (this.userSpecifiedBulkInsert) {
            if (!this.bulkInsertReplace) {
                this.bulkInsert = this.verifyBulkInsert();
            } else {
                this.getExclusiveTableLock();
            }
        }
        if (this.bulkInsert) {
            this.sourceResultSet.setTargetResultSet(this);
            long l = this.bulkInsertCore(this.lcc, this.heapConglom);
            if (this.hasBeforeStatementTrigger) {
                this.tableScan = this.getTableScanResultSet(l);
                this.triggerActivator.notifyEvent(TriggerEvents.BEFORE_INSERT, null, this.tableScan);
                if (this.checkGM != null) {
                    this.tableScan = this.getTableScanResultSet(l);
                    try {
                        ExecRow execRow = null;
                        while ((execRow = this.tableScan.getNextRowCore()) != null) {
                            this.sourceResultSet.setCurrentRow(execRow);
                            this.evaluateCheckConstraints();
                        }
                    }
                    finally {
                        Object var4_4 = null;
                        this.sourceResultSet.clearCurrentRow();
                    }
                }
            }
            this.bulkValidateForeignKeys(this.tc, this.lcc.getContextManager());
            if (this.triggerInfo != null && (this.triggerInfo.hasTrigger(false, true) || this.triggerInfo.hasTrigger(false, false))) {
                this.triggerActivator.notifyEvent(TriggerEvents.AFTER_INSERT, null, this.getTableScanResultSet(l));
            }
            this.bulkInsertPerformed = true;
        } else {
            this.row = this.getNextRowCore(this.sourceResultSet);
            this.normalInsertCore(this.lcc, this.firstExecute);
        }
        if (this.lcc.getRunTimeStatisticsMode()) {
            this.savedSource = this.sourceResultSet;
        }
        this.autoGeneratedKeysResultSet = this.activation.getAutoGeneratedKeysResultsetMode() ? this.autoGeneratedKeysRowsHolder.getResultSet() : null;
        this.cleanUp();
        if (this.aiCache != null) {
            Hashtable<String, Long> hashtable = new Hashtable<String, Long>();
            int n = this.aiCache.length;
            int n2 = 0;
            while (n2 < n) {
                if (this.aiCache[n2] != null) {
                    hashtable.put(AutoincrementCounter.makeIdentity(this.constants.getSchemaName(), this.constants.getTableName(), this.constants.getColumnName(n2)), new Long(this.aiCache[n2].getLong()));
                }
                ++n2;
            }
            InternalTriggerExecutionContext internalTriggerExecutionContext = (InternalTriggerExecutionContext)this.lcc.getTriggerExecutionContext();
            if (internalTriggerExecutionContext == null) {
                this.lcc.copyHashtableToAIHT(hashtable);
            } else {
                internalTriggerExecutionContext.copyHashtableToAIHT(hashtable);
            }
        }
        this.endTime = this.getCurrentTimeMillis();
    }

    private void verifyAutoGeneratedColumnsIndexes(int[] nArray) throws StandardException {
        int n = nArray.length;
        TableDescriptor tableDescriptor = this.dd.getTableDescriptor(this.constants.targetUUID);
        int n2 = 0;
        while (n2 < n) {
            if (tableDescriptor.getColumnDescriptor(nArray[n2]) == null) {
                throw StandardException.newException("X0X0E.S", new Integer(nArray[n2]));
            }
            ++n2;
        }
    }

    private int[] generatedColumnPositionsArray() throws StandardException {
        TableDescriptor tableDescriptor = this.dd.getTableDescriptor(this.constants.targetUUID);
        int n = tableDescriptor.getMaxColumnID();
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            nArray[n3] = -1;
            ++n3;
        }
        n3 = 0;
        while (n3 < n) {
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(n3 + 1);
            if (columnDescriptor.isAutoincrement()) {
                ++n2;
                nArray[n3] = n3 + 1;
            } else if (columnDescriptor.getDefaultValue() != null || columnDescriptor.getDefaultInfo() != null) {
                ++n2;
                nArray[n3] = n3 + 1;
            }
            ++n3;
        }
        int[] nArray2 = new int[n2];
        int n4 = 0;
        int n5 = 0;
        while (n4 < n) {
            if (nArray[n4] != -1) {
                nArray2[n5++] = nArray[n4];
            }
            ++n4;
        }
        return nArray2;
    }

    private int[] uniqueColumnPositionArray(int[] nArray) throws StandardException {
        int n = nArray.length;
        TableDescriptor tableDescriptor = this.dd.getTableDescriptor(this.constants.targetUUID);
        int[] nArray2 = new int[tableDescriptor.getMaxColumnID()];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (nArray2[nArray[n3] - 1] == 0) {
                ++n2;
                nArray2[nArray[n3] - 1] = nArray[n3];
            }
            ++n3;
        }
        int[] nArray3 = new int[n2];
        int n4 = 0;
        int n5 = 0;
        while (n4 < nArray2.length) {
            if (nArray2[n4] != 0) {
                nArray3[n5++] = nArray2[n4];
            }
            ++n4;
        }
        return nArray3;
    }

    private void verifyAutoGeneratedColumnsNames(String[] stringArray) throws StandardException {
        int n = stringArray.length;
        int[] nArray = new int[n];
        TableDescriptor tableDescriptor = this.dd.getTableDescriptor(this.constants.targetUUID);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == null) {
                throw StandardException.newException("X0X0F.S", stringArray[n2]);
            }
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(stringArray[n2]);
            if (columnDescriptor == null) {
                throw StandardException.newException("X0X0F.S", stringArray[n2]);
            }
            nArray[n2] = columnDescriptor.getPosition();
            ++n2;
        }
        this.activation.setAutoGeneratedKeysResultsetInfo(nArray, null);
    }

    public ResultSet getAutoGeneratedKeysResultset() {
        return this.autoGeneratedKeysResultSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NumberDataValue getSetAutoincrementValue(int n, long l) throws StandardException {
        NumberDataValue numberDataValue;
        int n2;
        block13: {
            long l2 = 0L;
            n2 = n - 1;
            this.setIdentity = !this.autoincrementGenerated && this.isSourceRowResultSet();
            this.autoincrementGenerated = true;
            if (this.bulkInsert) {
                ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(n);
                if (this.aiCache[n2].isNull()) {
                    if (this.bulkInsertReplace) {
                        l2 = columnDescriptor.getAutoincStart();
                    } else {
                        NumberDataValue numberDataValue2 = this.dd.getSetAutoincrementValue(this.constants.autoincRowLocation[n2], this.tc, false, this.aiCache[n2], true);
                        l2 = numberDataValue2.getLong();
                    }
                    this.lcc.autoincrementCreateCounter(this.td.getSchemaName(), this.td.getName(), columnDescriptor.getColumnName(), new Long(l2), l, n);
                }
                long l3 = this.lcc.nextAutoincrementValue(this.td.getSchemaName(), this.td.getName(), columnDescriptor.getColumnName());
                this.aiCache[n - 1].setValue(l3);
                return this.aiCache[n2];
            }
            TransactionController transactionController = null;
            TransactionController transactionController2 = this.tc;
            try {
                transactionController2 = transactionController = this.tc.startNestedUserTransaction(false);
            }
            catch (StandardException standardException) {
                transactionController2 = this.tc;
            }
            try {
                try {
                    numberDataValue = this.dd.getSetAutoincrementValue(this.constants.autoincRowLocation[n2], transactionController2, true, this.aiCache[n2], transactionController2 == this.tc);
                }
                catch (StandardException standardException) {
                    if (transactionController2 == this.tc) {
                        throw standardException;
                    }
                    if (!standardException.getMessageId().equals("40XL1")) {
                        if (!standardException.getMessageId().equals("22003")) throw standardException;
                        throw StandardException.newException("42Z24", standardException, (Object)this.constants.getTableName(), (Object)this.constants.getColumnName(n2));
                    }
                    numberDataValue = this.dd.getSetAutoincrementValue(this.constants.autoincRowLocation[n2], this.tc, true, this.aiCache[n2], true);
                    Object var12_14 = null;
                    if (transactionController != null) {
                        transactionController.commit();
                        transactionController.destroy();
                    }
                    break block13;
                }
                Object var12_13 = null;
                if (transactionController == null) break block13;
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                if (transactionController == null) throw throwable;
                transactionController.commit();
                transactionController.destroy();
                throw throwable;
            }
            transactionController.commit();
            transactionController.destroy();
        }
        this.aiCache[n2] = numberDataValue;
        if (!this.setIdentity) return this.aiCache[n2];
        this.identityVal = numberDataValue.getLong();
        return this.aiCache[n2];
    }

    private boolean isSourceRowResultSet() {
        boolean bl = false;
        if (this.sourceResultSet instanceof NormalizeResultSet) {
            bl = ((NormalizeResultSet)this.sourceResultSet).source instanceof RowResultSet;
        }
        return bl;
    }

    private void normalInsertCore(LanguageConnectionContext languageConnectionContext, boolean bl) throws StandardException {
        Object object;
        Object object2;
        boolean bl2 = true;
        ExecRow execRow = null;
        if (bl) {
            this.rowChanger = languageConnectionContext.getLanguageConnectionFactory().getExecutionFactory().getRowChanger(this.heapConglom, this.constants.heapSCOCI, this.heapDCOCI, this.constants.irgs, this.constants.indexCIDS, this.constants.indexSCOCIs, this.indexDCOCIs, 0, this.tc, null, this.constants.getStreamStorableHeapColIds(), this.activation);
            this.rowChanger.setIndexNames(this.constants.indexNames);
        } else {
            languageConnectionContext.getStatementContext().setTopResultSet(this, this.subqueryTrackingArray);
        }
        int n = UpdateResultSet.decodeLockMode(languageConnectionContext, this.constants.lockMode);
        this.rowChanger.open(n);
        if (this.constants.deferred) {
            this.activation.clearIndexScanInfo();
        }
        if (this.fkInfoArray != null) {
            if (this.fkChecker == null) {
                this.fkChecker = new RISetChecker(this.tc, this.fkInfoArray);
            } else {
                this.fkChecker.reopen();
            }
        }
        if (bl && this.constants.deferred) {
            object2 = new Properties();
            this.rowChanger.getHeapConglomerateController().getInternalTablePropertySet((Properties)object2);
            this.rowHolder = new TemporaryRowHolderImpl(this.tc, (Properties)object2, this.resultDescription);
            this.rowChanger.setRowHolder(this.rowHolder);
        }
        object2 = null;
        if (bl && this.activation.getAutoGeneratedKeysResultsetMode()) {
            Properties properties = new Properties();
            object2 = this.activation.getAutoGeneratedKeysColumnIndexes();
            this.rowChanger.getHeapConglomerateController().getInternalTablePropertySet(properties);
            object2 = object2 != null ? (Object)this.uniqueColumnPositionArray((int[])object2) : (Object)this.generatedColumnPositionsArray();
            object = languageConnectionContext.getLanguageFactory().getResultDescription(this.resultDescription, (int[])object2);
            this.autoGeneratedKeysRowsHolder = new TemporaryRowHolderImpl(this.tc, properties, (ResultDescription)object);
        }
        while (this.row != null) {
            if (this.activation.getAutoGeneratedKeysResultsetMode()) {
                this.autoGeneratedKeysRowsHolder.insert(this.getCompactRow(this.row, (int[])object2));
            }
            if (this.constants.deferred) {
                this.rowHolder.insert(this.row);
            } else {
                this.evaluateCheckConstraints();
                if (this.fkChecker != null) {
                    this.fkChecker.doFKCheck(this.row);
                }
                if (this.constants.irgs.length > 0) {
                    object = this.row.getRowArray();
                    int n2 = 0;
                    while (n2 < ((Object)object).length) {
                        if (this.constants.indexedCols[n2] && object[n2] instanceof StreamStorable) {
                            object[n2].getObject();
                        }
                        ++n2;
                    }
                }
                this.rowChanger.insertRow(this.row);
            }
            ++this.rowCount;
            this.row = this.constants.singleRowSource ? null : this.getNextRowCore(this.sourceResultSet);
        }
        if (this.constants.deferred) {
            String string;
            String string2;
            if (this.triggerInfo != null) {
                object = null;
                if (this.aiCache != null) {
                    object = new Vector();
                    int n3 = 0;
                    while (n3 < this.aiCache.length) {
                        if (this.aiCache[n3] != null) {
                            string2 = this.constants.getSchemaName();
                            String string3 = this.constants.getTableName();
                            string = this.constants.getColumnName(n3);
                            Long l = languageConnectionContext.lastAutoincrementValue(string2, string3, string);
                            AutoincrementCounter autoincrementCounter = new AutoincrementCounter(l, this.constants.getAutoincIncrement(n3), this.aiCache[n3].getLong(), string2, string3, string, n3 + 1);
                            ((Vector)object).addElement(autoincrementCounter);
                        }
                        ++n3;
                    }
                }
                if (this.triggerActivator == null) {
                    this.triggerActivator = new TriggerEventActivator(languageConnectionContext, this.tc, this.constants.targetUUID, this.triggerInfo, 3, this.activation, (Vector)object);
                } else {
                    this.triggerActivator.reopen();
                }
                this.triggerActivator.notifyEvent(TriggerEvents.BEFORE_INSERT, null, this.rowHolder.getResultSet());
            }
            object = this.rowHolder.getResultSet();
            try {
                object.open();
                while ((execRow = object.getNextRow()) != null) {
                    this.sourceResultSet.setCurrentRow(execRow);
                    this.evaluateCheckConstraints();
                    this.rowChanger.insertRow(execRow);
                }
            }
            finally {
                string2 = null;
                this.sourceResultSet.clearCurrentRow();
                object.close();
            }
            if (this.fkChecker != null) {
                object = this.rowHolder.getResultSet();
                try {
                    object.open();
                    while ((execRow = object.getNextRow()) != null) {
                        this.fkChecker.doFKCheck(execRow);
                    }
                }
                finally {
                    string = null;
                    object.close();
                }
            }
            if (this.triggerActivator != null) {
                this.triggerActivator.notifyEvent(TriggerEvents.AFTER_INSERT, null, this.rowHolder.getResultSet());
            }
        }
        if (this.rowHolder != null) {
            this.rowHolder.close();
        }
        if (this.fkChecker != null) {
            this.fkChecker.close();
            this.fkChecker = null;
        }
        if (this.setIdentity) {
            languageConnectionContext.setIdentityValue(this.identityVal);
        }
    }

    private ExecRow getCompactRow(ExecRow execRow, int[] nArray) throws StandardException {
        int n = execRow.nColumns();
        if (nArray == null) {
            ValueRow valueRow = new ValueRow(n);
            DataValueDescriptor[] dataValueDescriptorArray = execRow.getRowArray();
            DataValueDescriptor[] dataValueDescriptorArray2 = valueRow.getRowArray();
            System.arraycopy(dataValueDescriptorArray, 0, dataValueDescriptorArray2, 0, dataValueDescriptorArray.length);
            return valueRow;
        }
        int n2 = nArray.length;
        ValueRow valueRow = new ValueRow(n2);
        int n3 = 0;
        while (n3 < n2) {
            valueRow.setColumn(n3 + 1, execRow.getColumn(nArray[n3]));
            ++n3;
        }
        return valueRow;
    }

    private long bulkInsertCore(LanguageConnectionContext languageConnectionContext, long l) throws StandardException {
        Object object;
        this.fullTemplate = this.constants.getEmptyHeapRow(languageConnectionContext);
        this.bulkHeapCC = this.tc.openCompiledConglomerate(false, 4, 7, 5, this.constants.heapSCOCI, this.heapDCOCI);
        Properties properties = new Properties();
        this.bulkHeapCC.getInternalTablePropertySet(properties);
        if (this.triggerInfo != null) {
            this.triggerActivator = new TriggerEventActivator(languageConnectionContext, this.tc, this.constants.targetUUID, this.triggerInfo, 3, this.activation, null);
        }
        if (this.hasBeforeRowTrigger && this.rowHolder != null) {
            this.rowHolder = new TemporaryRowHolderImpl(this.tc, properties, this.resultDescription);
        }
        Properties properties2 = this.constants.getTargetProperties();
        Enumeration enumeration = ((Hashtable)properties2).keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            ((Hashtable)properties).put(object, properties2.getProperty((String)object));
        }
        if (this.constants.irgs.length > 0) {
            this.sourceResultSet.setNeedsRowLocation(true);
        }
        this.dd = languageConnectionContext.getDataDictionary();
        this.td = this.dd.getTableDescriptor(this.constants.targetUUID);
        object = new long[1];
        long l2 = this.bulkInsertReplace ? this.tc.createAndLoadConglomerate("heap", this.fullTemplate.getRowArray(), null, properties, 0, this.sourceResultSet, (long[])object) : this.tc.recreateAndLoadConglomerate("heap", false, this.fullTemplate.getRowArray(), null, properties, 0, l, this.sourceResultSet, (long[])object);
        if (l2 == l) {
            return l;
        }
        this.rowCount = (int)object[0];
        this.setEstimatedRowCount(l2);
        this.dd.startWriting(languageConnectionContext);
        languageConnectionContext.autoincrementFlushCache(this.constants.targetUUID);
        DependencyManager dependencyManager = this.dd.getDependencyManager();
        dependencyManager.invalidateFor(this.td, 15, languageConnectionContext);
        if (this.constants.irgs.length > 0) {
            this.updateAllIndexes(l2, this.constants, this.td, this.dd, this.fullTemplate);
        }
        this.bulkHeapCC.close();
        this.bulkHeapCC = null;
        ConglomerateDescriptor conglomerateDescriptor = this.td.getConglomerateDescriptor(l);
        this.dd.updateConglomerateDescriptor(conglomerateDescriptor, l2, this.tc);
        this.tc.dropConglomerate(l);
        return l2;
    }

    private void bulkValidateForeignKeys(TransactionController transactionController, ContextManager contextManager) throws StandardException {
        if (this.indexRows == null && !this.bulkInsertReplace || this.fkInfoArray == null) {
            return;
        }
        int n = 0;
        while (n < this.fkInfoArray.length) {
            FKInfo fKInfo = this.fkInfoArray[n];
            if (this.bulkInsertReplace) {
                int n2 = 0;
                while (n2 < fKInfo.fkConglomNumbers.length) {
                    if (!fKInfo.fkIsSelfReferencing[n2] || this.indexRows != null) {
                        long l;
                        long l2;
                        if (fKInfo.fkIsSelfReferencing[n2]) {
                            l2 = (Long)this.indexConversionTable.get(new Long(fKInfo.refConglomNumber));
                            l = (Long)this.indexConversionTable.get(new Long(fKInfo.fkConglomNumbers[n2]));
                        } else {
                            Long l3 = (Long)this.indexConversionTable.get(new Long(fKInfo.refConglomNumber));
                            Long l4 = (Long)this.indexConversionTable.get(new Long(fKInfo.fkConglomNumbers[n2]));
                            l2 = l3 == null ? fKInfo.refConglomNumber : l3;
                            l = l4 == null ? fKInfo.fkConglomNumbers[n2] : l4;
                        }
                        this.bulkValidateForeignKeysCore(transactionController, contextManager, this.fkInfoArray[n], l, l2, fKInfo.fkConstraintNames[n2]);
                    }
                    ++n2;
                }
            } else {
                Long l = (Long)this.indexConversionTable.get(new Long(fKInfo.fkConglomNumbers[0]));
                this.bulkValidateForeignKeysCore(transactionController, contextManager, this.fkInfoArray[n], l, fKInfo.refConglomNumber, fKInfo.fkConstraintNames[0]);
            }
            ++n;
        }
    }

    private void bulkValidateForeignKeysCore(TransactionController transactionController, ContextManager contextManager, FKInfo fKInfo, long l, long l2, String string) throws StandardException {
        GenericScanController genericScanController;
        block6: {
            genericScanController = null;
            GenericScanController genericScanController2 = null;
            try {
                ExecRow execRow = this.makeIndexTemplate(fKInfo, this.fullTemplate, contextManager);
                genericScanController2 = transactionController.openGroupFetchScan(l, false, 0, TransactionController.MODE_TABLE, TransactionController.ISOLATION_READ_COMMITTED, null, null, 1, null, null, -1);
                genericScanController = transactionController.openGroupFetchScan(l2, false, 0, l == l2 ? TransactionController.MODE_TABLE : TransactionController.MODE_RECORD, TransactionController.ISOLATION_READ_COMMITTED, null, null, 1, null, null, -1);
                ExecRow execRow2 = execRow.getClone();
                RIBulkChecker rIBulkChecker = new RIBulkChecker((GroupFetchScanController)genericScanController, (GroupFetchScanController)genericScanController2, execRow, true, null, execRow2);
                int n = rIBulkChecker.doCheck();
                if (n > 0) {
                    StandardException standardException = StandardException.newException("23503", string, (Object)fKInfo.tableName, (Object)StatementUtil.typeName(fKInfo.stmtType), (Object)RowUtil.toString(execRow2, 0, fKInfo.colArray.length - 1));
                    throw standardException;
                }
                Object var13_14 = null;
                if (genericScanController2 == null) break block6;
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                if (genericScanController2 != null) {
                    genericScanController2.close();
                    genericScanController2 = null;
                }
                if (genericScanController != null) {
                    genericScanController.close();
                    genericScanController = null;
                }
                throw throwable;
            }
            genericScanController2.close();
            genericScanController2 = null;
        }
        if (genericScanController != null) {
            genericScanController.close();
            genericScanController = null;
        }
    }

    private ExecRow makeIndexTemplate(FKInfo fKInfo, ExecRow execRow, ContextManager contextManager) throws StandardException {
        ExecIndexRow execIndexRow = RowUtil.getEmptyIndexRow(fKInfo.colArray.length + 1, contextManager);
        DataValueDescriptor[] dataValueDescriptorArray = execRow.getRowArray();
        DataValueDescriptor[] dataValueDescriptorArray2 = execIndexRow.getRowArray();
        int n = 0;
        while (n < fKInfo.colArray.length) {
            dataValueDescriptorArray2[n] = dataValueDescriptorArray[fKInfo.colArray[n] - 1].getClone();
            ++n;
        }
        dataValueDescriptorArray2[n] = (DataValueDescriptor)fKInfo.rowLocation.cloneObject();
        return execIndexRow;
    }

    private void setUpAllSorts(ExecRow execRow, RowLocation rowLocation) throws StandardException {
        int n = this.constants.irgs.length;
        int n2 = this.td.getNumberOfColumns();
        this.ordering = new ColumnOrdering[n][];
        this.needToDropSort = new boolean[n];
        this.sortIds = new long[n];
        this.rowSources = new RowLocationRetRowSource[n];
        this.indexedCols = new FormatableBitSet(n2 + 1);
        int n3 = 0;
        while (n3 < n) {
            int n4;
            boolean bl;
            int[] nArray = this.constants.irgs[n3].baseColumnPositions();
            int n5 = 0;
            while (n5 < nArray.length) {
                this.indexedCols.set(nArray[n5]);
                ++n5;
            }
            this.indexRows[n3] = this.constants.irgs[n3].getIndexRowTemplate();
            this.constants.irgs[n3].getIndexRow(execRow, rowLocation, this.indexRows[n3], null);
            ConglomerateDescriptor conglomerateDescriptor = this.td.getConglomerateDescriptor(this.constants.indexCIDS[n3]);
            int[] nArray2 = this.constants.irgs[n3].baseColumnPositions();
            boolean[] blArray = this.constants.irgs[n3].isAscending();
            BasicSortObserver basicSortObserver = null;
            boolean bl2 = bl = n == 1;
            if (conglomerateDescriptor.getIndexDescriptor().isUnique()) {
                n4 = nArray2.length;
                String[] stringArray = this.getColumnNames(nArray2);
                String string = conglomerateDescriptor.getConglomerateName();
                if (conglomerateDescriptor.isConstraint()) {
                    ConstraintDescriptor constraintDescriptor = this.dd.getConstraintDescriptor(this.td, conglomerateDescriptor.getUUID());
                    string = constraintDescriptor.getConstraintName();
                }
                basicSortObserver = new UniqueIndexSortObserver(false, conglomerateDescriptor.isConstraint(), string, this.indexRows[n3], bl, this.td.getName());
            } else {
                n4 = nArray2.length + 1;
                basicSortObserver = new BasicSortObserver(false, false, this.indexRows[n3], bl);
            }
            this.ordering[n3] = new ColumnOrdering[n4];
            int n6 = 0;
            while (n6 < blArray.length) {
                this.ordering[n3][n6] = new IndexColumnOrder(n6, blArray[n6]);
                ++n6;
            }
            if (n4 > blArray.length) {
                this.ordering[n3][blArray.length] = new IndexColumnOrder(blArray.length);
            }
            this.sortIds[n3] = this.tc.createSort(null, this.indexRows[n3].getRowArrayClone(), this.ordering[n3], basicSortObserver, false, (int)this.sourceResultSet.getEstimatedRowCount(), -1);
            this.needToDropSort[n3] = true;
            ++n3;
        }
        this.sorters = new SortController[n];
        n3 = 0;
        while (n3 < n) {
            this.sorters[n3] = this.tc.openSort(this.sortIds[n3]);
            this.needToDropSort[n3] = true;
            ++n3;
        }
    }

    private void updateAllIndexes(long l, InsertConstantAction insertConstantAction, TableDescriptor tableDescriptor, DataDictionary dataDictionary, ExecRow execRow) throws StandardException {
        int n = insertConstantAction.irgs.length;
        if (this.indexRows == null) {
            if (this.bulkInsertReplace) {
                this.emptyIndexes(l, insertConstantAction, tableDescriptor, dataDictionary, execRow);
            }
            return;
        }
        dataDictionary.dropStatisticsDescriptors(tableDescriptor.getUUID(), null, this.tc);
        long[] lArray = new long[n];
        this.indexConversionTable = new Hashtable(n);
        int n2 = 0;
        while (n2 < n) {
            Properties properties = new Properties();
            ConglomerateDescriptor conglomerateDescriptor = tableDescriptor.getConglomerateDescriptor(insertConstantAction.indexCIDS[n2]);
            ConglomerateController conglomerateController = this.tc.openCompiledConglomerate(false, 4, 7, 5, insertConstantAction.indexSCOCIs[n2], this.indexDCOCIs[n2]);
            conglomerateController.getInternalTablePropertySet(properties);
            int n3 = this.indexRows[n2].nColumns();
            ((Hashtable)properties).put("baseConglomerateId", Long.toString(l));
            if (conglomerateDescriptor.getIndexDescriptor().isUnique()) {
                ((Hashtable)properties).put("nUniqueColumns", Integer.toString(n3 - 1));
            } else {
                ((Hashtable)properties).put("nUniqueColumns", Integer.toString(n3));
            }
            ((Hashtable)properties).put("rowLocationColumn", Integer.toString(n3 - 1));
            ((Hashtable)properties).put("nKeyFields", Integer.toString(n3));
            conglomerateController.close();
            this.sorters[n2].close();
            this.sorters[n2] = null;
            this.rowSources[n2] = new CardinalityCounter(this.tc.openSortRowSource(this.sortIds[n2]));
            lArray[n2] = this.tc.createAndLoadConglomerate("BTREE", this.indexRows[n2].getRowArray(), this.ordering[n2], properties, 0, this.rowSources[n2], null);
            CardinalityCounter cardinalityCounter = (CardinalityCounter)this.rowSources[n2];
            long l2 = cardinalityCounter.getRowCount();
            if (l2 > 0L) {
                long[] lArray2 = cardinalityCounter.getCardinality();
                DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
                int n4 = 0;
                while (n4 < lArray2.length) {
                    StatisticsDescriptor statisticsDescriptor = new StatisticsDescriptor(dataDictionary, dataDictionary.getUUIDFactory().createUUID(), conglomerateDescriptor.getUUID(), tableDescriptor.getUUID(), "I", new StatisticsImpl(l2, lArray2[n4]), n4 + 1);
                    dataDictionary.addDescriptor(statisticsDescriptor, null, 14, true, this.tc);
                    ++n4;
                }
            }
            dataDictionary.updateConglomerateDescriptor(tableDescriptor.getConglomerateDescriptors(insertConstantAction.indexCIDS[n2]), lArray[n2], this.tc);
            this.tc.dropConglomerate(insertConstantAction.indexCIDS[n2]);
            this.indexConversionTable.put(new Long(insertConstantAction.indexCIDS[n2]), new Long(lArray[n2]));
            ++n2;
        }
    }

    public void cleanUp() throws StandardException {
        int n;
        if (this.tableScan != null) {
            this.tableScan.close();
            this.tableScan = null;
        }
        if (this.triggerActivator != null) {
            this.triggerActivator.cleanup();
        }
        if (this.sourceResultSet != null) {
            this.sourceResultSet.close();
        }
        this.numOpens = 0;
        if (this.rowChanger != null) {
            this.rowChanger.close();
        }
        if (this.rowHolder != null) {
            this.rowHolder.close();
        }
        if (this.fkChecker != null) {
            this.fkChecker.close();
        }
        if (this.bulkHeapCC != null) {
            this.bulkHeapCC.close();
            this.bulkHeapCC = null;
        }
        if (this.bulkHeapSC != null) {
            this.bulkHeapSC.close();
            this.bulkHeapSC = null;
        }
        if (this.sorters != null) {
            n = 0;
            while (n < this.constants.irgs.length) {
                if (this.sorters[n] != null) {
                    this.sorters[n].close();
                }
                this.sorters[n] = null;
                ++n;
            }
        }
        if (this.needToDropSort != null) {
            n = 0;
            while (n < this.needToDropSort.length) {
                if (this.needToDropSort[n]) {
                    this.tc.dropSort(this.sortIds[n]);
                    this.needToDropSort[n] = false;
                }
                ++n;
            }
        }
        if (this.rowSources != null) {
            n = 0;
            while (n < this.rowSources.length) {
                if (this.rowSources[n] != null) {
                    this.rowSources[n].closeRowSource();
                    this.rowSources[n] = null;
                }
                ++n;
            }
        }
        super.close();
    }

    protected boolean verifyBulkInsert() throws StandardException {
        if (this.constants.deferred) {
            return false;
        }
        return this.getExclusiveTableLock();
    }

    private boolean getExclusiveTableLock() throws StandardException {
        boolean bl = false;
        this.bulkHeapSC = this.tc.openCompiledScan(false, 4, 7, 5, null, null, 0, null, null, 0, this.constants.heapSCOCI, this.heapDCOCI);
        if (!this.bulkInsertReplace) {
            bl = this.bulkHeapSC.next();
        } else {
            this.rl = this.bulkHeapSC.newRowLocationTemplate();
        }
        this.bulkHeapSC.close();
        this.bulkHeapSC = null;
        return !bl;
    }

    private void setEstimatedRowCount(long l) throws StandardException {
        this.bulkHeapSC = this.tc.openCompiledScan(false, 4, 7, 5, null, null, 0, null, null, 0, this.constants.heapSCOCI, this.heapDCOCI);
        this.bulkHeapSC.setEstimatedRowCount(this.rowCount);
        this.bulkHeapSC.close();
        this.bulkHeapSC = null;
    }

    private void emptyIndexes(long l, InsertConstantAction insertConstantAction, TableDescriptor tableDescriptor, DataDictionary dataDictionary, ExecRow execRow) throws StandardException {
        int n;
        Object object;
        Object object2;
        int n2 = insertConstantAction.irgs.length;
        ExecIndexRow[] execIndexRowArray = new ExecIndexRow[n2];
        ExecRow execRow2 = null;
        ColumnOrdering[][] columnOrderingArray = new ColumnOrdering[n2][];
        int n3 = tableDescriptor.getNumberOfColumns();
        FormatableBitSet formatableBitSet = new FormatableBitSet(n3 + 1);
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            int[] nArray = insertConstantAction.irgs[n5].baseColumnPositions();
            int n6 = 0;
            while (n6 < nArray.length) {
                if (!formatableBitSet.get(nArray[n6])) {
                    formatableBitSet.set(nArray[n6]);
                    ++n4;
                }
                ++n6;
            }
            ++n5;
        }
        execRow2 = this.activation.getExecutionFactory().getValueRow(n4);
        n5 = 0;
        int n7 = 0;
        while (n7 < n3) {
            if (formatableBitSet.get(n7 + 1)) {
                execRow2.setColumn(++n5, execRow.getColumn(n7 + 1).getClone());
            }
            ++n7;
        }
        this.needToDropSort = new boolean[n2];
        this.sortIds = new long[n2];
        n7 = 0;
        while (n7 < n2) {
            int n8;
            execIndexRowArray[n7] = insertConstantAction.irgs[n7].getIndexRowTemplate();
            insertConstantAction.irgs[n7].getIndexRow(execRow2, this.rl, execIndexRowArray[n7], formatableBitSet);
            ConglomerateDescriptor conglomerateDescriptor = tableDescriptor.getConglomerateDescriptor(insertConstantAction.indexCIDS[n7]);
            int[] nArray = insertConstantAction.irgs[n7].baseColumnPositions();
            object2 = insertConstantAction.irgs[n7].isAscending();
            object = null;
            if (conglomerateDescriptor.getIndexDescriptor().isUnique()) {
                n8 = nArray.length;
                String[] stringArray = this.getColumnNames(nArray);
                String string = conglomerateDescriptor.getConglomerateName();
                if (conglomerateDescriptor.isConstraint()) {
                    ConstraintDescriptor constraintDescriptor = dataDictionary.getConstraintDescriptor(tableDescriptor, conglomerateDescriptor.getUUID());
                    string = constraintDescriptor.getConstraintName();
                }
                object = new UniqueIndexSortObserver(false, conglomerateDescriptor.isConstraint(), string, execIndexRowArray[n7], true, tableDescriptor.getName());
            } else {
                n8 = nArray.length + 1;
                object = new BasicSortObserver(false, false, execIndexRowArray[n7], true);
            }
            columnOrderingArray[n7] = new ColumnOrdering[n8];
            n = 0;
            while (n < ((Object)object2).length) {
                columnOrderingArray[n7][n] = new IndexColumnOrder(n, (boolean)object2[n]);
                ++n;
            }
            if (n8 > ((Object)object2).length) {
                columnOrderingArray[n7][((Object)object2).length] = new IndexColumnOrder(((Object)object2).length);
            }
            this.sortIds[n7] = this.tc.createSort(null, execIndexRowArray[n7].getRowArrayClone(), columnOrderingArray[n7], (SortObserver)object, false, this.rowCount, -1);
            this.needToDropSort[n7] = true;
            ++n7;
        }
        this.rowSources = new RowLocationRetRowSource[n2];
        SortController[] sortControllerArray = new SortController[n2];
        int n9 = 0;
        while (n9 < n2) {
            sortControllerArray[n9] = this.tc.openSort(this.sortIds[n9]);
            sortControllerArray[n9].close();
            this.rowSources[n9] = this.tc.openSortRowSource(this.sortIds[n9]);
            ++n9;
        }
        long[] lArray = new long[n2];
        int n10 = 0;
        while (n10 < n2) {
            Properties properties = new Properties();
            object = tableDescriptor.getConglomerateDescriptor(insertConstantAction.indexCIDS[n10]);
            object2 = this.tc.openCompiledConglomerate(false, 4, 7, 5, insertConstantAction.indexSCOCIs[n10], this.indexDCOCIs[n10]);
            object2.getInternalTablePropertySet(properties);
            n = execIndexRowArray[n10].nColumns();
            ((Hashtable)properties).put("baseConglomerateId", Long.toString(l));
            if (((ConglomerateDescriptor)object).getIndexDescriptor().isUnique()) {
                ((Hashtable)properties).put("nUniqueColumns", Integer.toString(n - 1));
            } else {
                ((Hashtable)properties).put("nUniqueColumns", Integer.toString(n));
            }
            ((Hashtable)properties).put("rowLocationColumn", Integer.toString(n - 1));
            ((Hashtable)properties).put("nKeyFields", Integer.toString(n));
            object2.close();
            lArray[n10] = this.tc.createAndLoadConglomerate("BTREE", execIndexRowArray[n10].getRowArray(), null, properties, 0, this.rowSources[n10], null);
            dataDictionary.updateConglomerateDescriptor(tableDescriptor.getConglomerateDescriptors(insertConstantAction.indexCIDS[n10]), lArray[n10], this.tc);
            this.tc.dropConglomerate(insertConstantAction.indexCIDS[n10]);
            ++n10;
        }
    }

    private BulkTableScanResultSet getTableScanResultSet(long l) throws StandardException {
        if (this.tableScan == null) {
            this.tableScan = new BulkTableScanResultSet(l, this.tc.getStaticCompiledConglomInfo(l), this.activation, new MyRowAllocator(this.fullTemplate), 0, null, 0, null, 0, false, null, "tableName", null, false, false, -1, -1, TransactionController.MODE_TABLE, true, TransactionController.ISOLATION_READ_COMMITTED, 16, false, 0.0, 0.0, null);
            this.tableScan.openCore();
        } else {
            this.tableScan.reopenCore();
        }
        return this.tableScan;
    }

    private String[] getColumnNames(int[] nArray) {
        int n = nArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.constants.getColumnName(n2);
            ++n2;
        }
        return stringArray;
    }

    public void finish() throws StandardException {
        this.sourceResultSet.finish();
        super.finish();
    }

    public InsertResultSet(NoPutResultSet noPutResultSet, GeneratedMethod generatedMethod, Activation activation) throws StandardException {
        super(activation);
        this.sourceResultSet = noPutResultSet;
        this.constants = (InsertConstantAction)this.constantAction;
        this.checkGM = generatedMethod;
        this.heapConglom = this.constants.conglomId;
        this.lcc = activation.getLanguageConnectionContext();
        this.tc = activation.getTransactionController();
        this.fkInfoArray = this.constants.getFKInfo(this.lcc.getExecutionContext());
        this.triggerInfo = this.constants.getTriggerInfo(this.lcc.getExecutionContext());
        this.hasBeforeStatementTrigger = this.triggerInfo != null ? this.triggerInfo.hasTrigger(true, false) : false;
        this.hasBeforeRowTrigger = this.triggerInfo != null ? this.triggerInfo.hasTrigger(true, true) : false;
        this.resultDescription = this.sourceResultSet.getResultDescription();
        String string = this.constants.getProperty("insertMode");
        RowLocation[] rowLocationArray = this.constants.getAutoincRowLocation();
        if (rowLocationArray != null) {
            this.aiCache = new NumberDataValue[rowLocationArray.length];
            int n = 0;
            while (n < this.resultDescription.getColumnCount()) {
                if (rowLocationArray[n] != null) {
                    ResultColumnDescriptor resultColumnDescriptor = this.resultDescription.getColumnDescriptor(n + 1);
                    this.aiCache[n] = (NumberDataValue)resultColumnDescriptor.getType().getNull();
                }
                ++n;
            }
        }
        if (string != null) {
            if (StringUtil.SQLEqualsIgnoreCase(string, "BULKINSERT")) {
                this.userSpecifiedBulkInsert = true;
            } else if (StringUtil.SQLEqualsIgnoreCase(string, "REPLACE")) {
                this.userSpecifiedBulkInsert = true;
                this.bulkInsertReplace = true;
                this.bulkInsert = true;
                if (this.triggerInfo != null) {
                    TriggerDescriptor triggerDescriptor = this.triggerInfo.getTriggerArray()[0];
                    throw StandardException.newException("X0Y72.S", this.constants.getTableName(), (Object)triggerDescriptor.getName());
                }
            }
        }
    }

    class MyRowAllocator
    implements GeneratedMethod {
        private ExecRow row;

        public Object invoke(Object object) {
            return this.row.getClone();
        }

        MyRowAllocator(ExecRow execRow) {
            this.row = execRow;
        }
    }
}

