/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.sort;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.SortInfo;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.sort.MergeSort;
import org.apache.derby.impl.store.access.sort.MergeSortInfo;
import org.apache.derby.impl.store.access.sort.SortBuffer;

public final class MergeInserter
implements SortController {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    protected MergeSort sort = null;
    protected TransactionManager tran;
    Vector mergeRuns = null;
    SortBuffer sortBuffer = null;
    long beginFreeMemory;
    long beginTotalMemory;
    long estimatedMemoryUsed;
    boolean avoidMergeRun;
    int runSize;
    int totalRunSize;
    protected String stat_sortType;
    protected int stat_numRowsInput;
    protected int stat_numRowsOutput;
    protected int stat_numMergeRuns;
    protected Vector stat_mergeRunsSize;

    public void insert(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        this.sort.checkColumnTypes(dataValueDescriptorArray);
        int n = this.sortBuffer.insert(dataValueDescriptorArray);
        ++this.stat_numRowsInput;
        if (n != 1) {
            ++this.stat_numRowsOutput;
        }
        if (n == 2) {
            if (this.avoidMergeRun) {
                Runtime runtime = Runtime.getRuntime();
                long l = runtime.freeMemory();
                long l2 = runtime.totalMemory();
                this.estimatedMemoryUsed = l2 - l - (this.beginTotalMemory - this.beginFreeMemory);
                if (this.estimatedMemoryUsed < 0L || 2L * this.estimatedMemoryUsed < (this.estimatedMemoryUsed + l) / 2L || 2L * this.estimatedMemoryUsed < 0x100000L && l2 < 0x500000L) {
                    this.sortBuffer.grow(100);
                    if (this.sortBuffer.insert(dataValueDescriptorArray) != 2) {
                        return;
                    }
                }
                this.avoidMergeRun = false;
            }
            this.stat_sortType = "external";
            long l = this.sort.createMergeRun(this.tran, this.sortBuffer);
            if (this.mergeRuns == null) {
                this.mergeRuns = new Vector();
            }
            this.mergeRuns.addElement(new Long(l));
            ++this.stat_numMergeRuns;
            this.runSize = this.stat_numRowsInput - this.totalRunSize - 1;
            this.totalRunSize += this.runSize;
            this.stat_mergeRunsSize.addElement(new Integer(this.runSize));
            this.sortBuffer.insert(dataValueDescriptorArray);
        }
    }

    public void close() {
        if (this.sort != null) {
            this.sort.doneInserting(this, this.sortBuffer, this.mergeRuns);
        }
        if (this.stat_sortType == "external") {
            ++this.stat_numMergeRuns;
            this.stat_mergeRunsSize.addElement(new Integer(this.stat_numRowsInput - this.totalRunSize));
        }
        this.tran.closeMe(this);
        this.sort = null;
        this.tran = null;
        this.mergeRuns = null;
        this.sortBuffer = null;
    }

    public SortInfo getSortInfo() throws StandardException {
        return new MergeSortInfo(this);
    }

    boolean initialize(MergeSort mergeSort, TransactionManager transactionManager) {
        Runtime runtime = Runtime.getRuntime();
        this.beginFreeMemory = runtime.freeMemory();
        this.beginTotalMemory = runtime.totalMemory();
        this.estimatedMemoryUsed = 0L;
        this.avoidMergeRun = true;
        this.stat_sortType = "internal";
        this.stat_numMergeRuns = 0;
        this.stat_numRowsInput = 0;
        this.stat_numRowsOutput = 0;
        this.stat_mergeRunsSize = new Vector();
        this.runSize = 0;
        this.totalRunSize = 0;
        this.sort = mergeSort;
        this.tran = transactionManager;
        this.sortBuffer = new SortBuffer(mergeSort);
        return this.sortBuffer.init();
    }
}

