/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.data.RawContainerHandle;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;

public abstract class ContainerBasicOperation
implements Loggable {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1998, 2004.";
    private long containerVersion;
    protected ContainerKey containerId;
    protected transient RawContainerHandle containerHdl = null;
    private transient boolean foundHere = false;

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.containerId.writeExternal(objectOutput);
        CompressedNumber.writeLong(objectOutput, this.containerVersion);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.containerId = ContainerKey.read(objectInput);
        this.containerVersion = CompressedNumber.readLong(objectInput);
    }

    public ByteArray getPreparedLog() {
        return null;
    }

    public void releaseResource(Transaction transaction) {
        if (!this.foundHere) {
            return;
        }
        if (this.containerHdl != null) {
            this.containerHdl.close();
            this.containerHdl = null;
        }
        this.foundHere = false;
    }

    public int group() {
        return 256;
    }

    protected RawContainerHandle findContainer(Transaction transaction) throws StandardException {
        this.releaseResource(transaction);
        RawTransaction rawTransaction = (RawTransaction)transaction;
        this.containerHdl = rawTransaction.openDroppedContainer(this.containerId, null);
        if (rawTransaction.inRollForwardRecovery() && this.containerHdl == null) {
            this.containerHdl = this.findContainerForLoadTran(rawTransaction);
        }
        if (this.containerHdl == null) {
            throw StandardException.newException("40XD2", this.containerId);
        }
        this.foundHere = true;
        return this.containerHdl;
    }

    protected RawContainerHandle findContainerForLoadTran(RawTransaction rawTransaction) throws StandardException {
        return null;
    }

    public boolean needsRedo(Transaction transaction) throws StandardException {
        this.findContainer(transaction);
        long l = this.containerHdl.getContainerVersion();
        if (l == this.containerVersion) {
            return true;
        }
        this.releaseResource(transaction);
        if (l > this.containerVersion) {
            return false;
        }
        return false;
    }

    public String toString() {
        return null;
    }

    public abstract void doMe(Transaction var1, LogInstant var2, LimitObjectInput var3) throws StandardException, IOException;

    public abstract int getTypeFormatId();

    protected ContainerBasicOperation(RawContainerHandle rawContainerHandle) throws StandardException {
        this.containerHdl = rawContainerHandle;
        this.containerId = rawContainerHandle.getId();
        this.containerVersion = rawContainerHandle.getContainerVersion();
    }

    public ContainerBasicOperation() {
    }
}

