/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.Compensation;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.Undoable;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.LogicalPageOperation;
import org.apache.derby.impl.store.raw.data.PageBasicOperation;

public class LogicalUndoOperation
extends PageBasicOperation
implements Compensation {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    protected int recordId;
    private transient LogicalPageOperation undoOp = null;

    public int getTypeFormatId() {
        return 104;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        CompressedNumber.writeInt(objectOutput, this.recordId);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.recordId = CompressedNumber.readInt(objectInput);
    }

    public void restoreMe(Transaction transaction, BasePage basePage, LogInstant logInstant, LimitObjectInput limitObjectInput) {
    }

    public void setUndoOp(Undoable undoable) {
        this.undoOp = (LogicalPageOperation)undoable;
    }

    public final void doMe(Transaction transaction, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        long l = 0L;
        Object var6_5 = null;
        this.undoOp.undoMe(transaction, this.page, this.recordId, logInstant, limitObjectInput);
        this.releaseResource(transaction);
    }

    public void releaseResource(Transaction transaction) {
        if (this.undoOp != null) {
            this.undoOp.releaseResource(transaction);
        }
        super.releaseResource(transaction);
    }

    public int group() {
        return super.group() | 4 | 0x100;
    }

    public final ByteArray getPreparedLog() {
        return null;
    }

    public String toString() {
        return null;
    }

    protected LogicalUndoOperation(BasePage basePage) {
        super(basePage);
    }

    public LogicalUndoOperation(BasePage basePage, int n, LogicalPageOperation logicalPageOperation) {
        super(basePage);
        this.undoOp = logicalPageOperation;
        this.recordId = n;
    }

    public LogicalUndoOperation() {
    }
}

