/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.xact;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.GlobalTransactionId;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;

public class EndXact
implements Loggable {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private int transactionStatus;
    private GlobalTransactionId xactId;

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.xactId);
        CompressedNumber.writeInt(objectOutput, this.transactionStatus);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.xactId = (GlobalTransactionId)objectInput.readObject();
        this.transactionStatus = CompressedNumber.readInt(objectInput);
    }

    public int getTypeFormatId() {
        return 102;
    }

    public void doMe(Transaction transaction, LogInstant logInstant, LimitObjectInput limitObjectInput) {
        if ((this.transactionStatus & 2) == 0) {
            ((RawTransaction)transaction).removeUpdateTransaction();
        } else {
            ((RawTransaction)transaction).prepareTransaction();
        }
    }

    public ByteArray getPreparedLog() {
        return null;
    }

    public boolean needsRedo(Transaction transaction) {
        return true;
    }

    public void releaseResource(Transaction transaction) {
    }

    public int group() {
        int n = 256;
        if ((this.transactionStatus & 4) != 0) {
            n |= 0x12;
        } else if ((this.transactionStatus & 1) != 0) {
            n |= 0x22;
        } else if ((this.transactionStatus & 2) != 0) {
            n |= 0x40;
        }
        return n;
    }

    public String toString() {
        return null;
    }

    public EndXact(GlobalTransactionId globalTransactionId, int n) {
        this.xactId = globalTransactionId;
        this.transactionStatus = n;
    }

    public EndXact() {
    }
}

