/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.BrokeredConnection;
import org.apache.derby.iapi.jdbc.BrokeredConnectionControl;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FormatableProperties;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.impl.jdbc.EmbedCallableStatement20;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedConnection20;
import org.apache.derby.impl.jdbc.EmbedPreparedStatement20;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.EmbedResultSet20;
import org.apache.derby.impl.jdbc.EmbedStatement;
import org.apache.derby.jdbc.Driver169;

public class Driver20
extends Driver169
implements Driver {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1998, 2004.";
    private static final String[] BOOLEAN_CHOICES = new String[]{"false", "true"};
    private Class antiGCDriverManager;
    private static /* synthetic */ Class class$Ljava$sql$DriverManager;

    public void boot(boolean bl, Properties properties) throws StandardException {
        super.boot(bl, properties);
        try {
            DriverManager.registerDriver(this);
            this.antiGCDriverManager = class$Ljava$sql$DriverManager != null ? class$Ljava$sql$DriverManager : (class$Ljava$sql$DriverManager = Driver20.class$("java.sql.DriverManager"));
        }
        catch (SQLException sQLException) {
            throw StandardException.newException("XBM0N.D", sQLException);
        }
    }

    public void stop() {
        super.stop();
        try {
            DriverManager.deregisterDriver(this);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public Connection getNewNestedConnection(EmbedConnection embedConnection) {
        return new EmbedConnection20(embedConnection);
    }

    public EmbedConnection getNewEmbedConnection(String string, Properties properties) throws SQLException {
        return new EmbedConnection20(this, string, properties);
    }

    public PreparedStatement newEmbedPreparedStatement(EmbedConnection embedConnection, String string, boolean bl, int n, int n2, int n3, int n4, int[] nArray, String[] stringArray) throws SQLException {
        return new EmbedPreparedStatement20(embedConnection, string, bl, n, n2, n3, n4, nArray, stringArray);
    }

    public CallableStatement newEmbedCallableStatement(EmbedConnection embedConnection, String string, int n, int n2, int n3) throws SQLException {
        return new EmbedCallableStatement20(embedConnection, string, n, n2, n3);
    }

    public EmbedResultSet newEmbedResultSet(EmbedConnection embedConnection, ResultSet resultSet, boolean bl, EmbedStatement embedStatement, boolean bl2) {
        return new EmbedResultSet20(embedConnection, resultSet, bl, embedStatement, bl2);
    }

    public BrokeredConnection newBrokeredConnection(BrokeredConnectionControl brokeredConnectionControl) {
        return new BrokeredConnection(brokeredConnectionControl);
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        if (properties != null && Boolean.valueOf(properties.getProperty("shutdown")).booleanValue()) {
            return new DriverPropertyInfo[0];
        }
        String string2 = Driver169.getDatabaseName(string, properties);
        FormatableProperties formatableProperties = this.getAttributes(string, properties);
        properties = null;
        boolean bl = Boolean.valueOf(formatableProperties.getProperty("dataEncryption"));
        String string3 = formatableProperties.getProperty("bootPassword");
        if (string2.length() == 0 || (bl = string3 == null)) {
            String[][] stringArray = new String[][]{{"databaseName", "J004"}, {"encryptionProvider", "J016"}, {"encryptionAlgorithm", "J017"}, {"encryptionKeyLength", "J018"}, {"encryptionKey", "J019"}, {"territory", "J021"}, {"user", "J022"}, {"logDevice", "J025"}, {"rollForwardRecoveryFrom", "J028"}, {"createFrom", "J029"}, {"restoreFrom", "J030"}};
            String[][] stringArray2 = new String[][]{{"shutdown", "J005"}, {"create", "J007"}, {"dataEncryption", "J010"}, {"upgrade", "J013"}};
            String[][] stringArray3 = new String[][]{{"bootPassword", "J020"}, {"password", "J023"}};
            DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[stringArray.length + stringArray2.length + stringArray3.length];
            int n = 0;
            int n2 = 0;
            while (n2 < stringArray.length) {
                driverPropertyInfoArray[n] = new DriverPropertyInfo(stringArray[n2][0], formatableProperties.getProperty(stringArray[n2][0]));
                driverPropertyInfoArray[n].description = MessageService.getTextMessage(stringArray[n2][1]);
                ++n2;
                ++n;
            }
            driverPropertyInfoArray[0].choices = Monitor.getMonitor().getServiceList("org.apache.derby.database.Database");
            driverPropertyInfoArray[0].value = string2;
            n2 = 0;
            while (n2 < stringArray3.length) {
                driverPropertyInfoArray[n] = new DriverPropertyInfo(stringArray3[n2][0], formatableProperties.getProperty(stringArray3[n2][0]) == null ? "" : "****");
                driverPropertyInfoArray[n].description = MessageService.getTextMessage(stringArray3[n2][1]);
                ++n2;
                ++n;
            }
            n2 = 0;
            while (n2 < stringArray2.length) {
                driverPropertyInfoArray[n] = new DriverPropertyInfo(stringArray2[n2][0], Boolean.valueOf(formatableProperties == null ? "" : formatableProperties.getProperty(stringArray2[n2][0])).toString());
                driverPropertyInfoArray[n].description = MessageService.getTextMessage(stringArray2[n2][1]);
                driverPropertyInfoArray[n].choices = BOOLEAN_CHOICES;
                ++n2;
                ++n;
            }
            return driverPropertyInfoArray;
        }
        return new DriverPropertyInfo[0];
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

