/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;

public class ReferenceableDataSource
implements Referenceable,
Serializable,
ObjectFactory {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 2003, 2004.";
    private static final long serialVersionUID = 1872877359127597176L;
    private static final Class[] STRING_ARG = new Class[]{"(C) Copyright IBM Corp. 2003, 2004.".getClass()};
    private static final Class[] INT_ARG = new Class[]{Integer.TYPE};
    private static final Class[] BOOLEAN_ARG = new Class[]{Boolean.TYPE};
    private String description;
    private String dataSourceName;
    private String databaseName;
    private String password;
    private String user;
    private int loginTimeout;
    private transient PrintWriter printer;

    public final synchronized void setDatabaseName(String string) {
        this.databaseName = string;
        this.update();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public final void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    public final String getDataSourceName() {
        return this.dataSourceName;
    }

    public final void setDescription(String string) {
        this.description = string;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setUser(String string) {
        this.user = string;
    }

    public final String getUser() {
        return this.user;
    }

    public final void setPassword(String string) {
        this.password = string;
    }

    public final String getPassword() {
        return this.password;
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.loginTimeout = n;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.printer;
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.printer = printWriter;
    }

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        Reference reference = (Reference)object;
        String string = reference.getClassName();
        Object obj = Class.forName(string).newInstance();
        Enumeration<RefAddr> enumeration = reference.getAll();
        while (enumeration.hasMoreElements()) {
            Object object2;
            Method method;
            RefAddr refAddr = enumeration.nextElement();
            String string2 = refAddr.getType();
            String string3 = (String)refAddr.getContent();
            String string4 = "set" + string2.substring(0, 1).toUpperCase(Locale.ENGLISH) + string2.substring(1);
            try {
                method = obj.getClass().getMethod(string4, STRING_ARG);
                object2 = string3;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    method = obj.getClass().getMethod(string4, INT_ARG);
                    object2 = Integer.valueOf(string3);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    method = obj.getClass().getMethod(string4, BOOLEAN_ARG);
                    object2 = Boolean.valueOf(string3);
                }
            }
            method.invoke(obj, object2);
        }
        return obj;
    }

    public final Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), "org.apache.derby.jdbc.ReferenceableDataSource", null);
        Method[] methodArray = this.getClass().getMethods();
        int n = 0;
        while (n < methodArray.length) {
            Class<?> clazz;
            String string;
            Method method = methodArray[n];
            if (method.getParameterTypes().length == 0 && !Modifier.isStatic(method.getModifiers()) && (string = method.getName()).length() >= 5 && string.startsWith("get") && (Integer.TYPE.equals(clazz = method.getReturnType()) || STRING_ARG[0].equals(clazz) || Boolean.TYPE.equals(clazz))) {
                String string2 = string.substring(3, 4).toLowerCase(Locale.ENGLISH).concat(string.substring(4));
                try {
                    Object object = method.invoke((Object)this, null);
                    if (object != null) {
                        reference.add(new StringRefAddr(string2, object.toString()));
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            ++n;
        }
        return reference;
    }

    void update() {
    }

    Connection getConnection(String string, String string2, boolean bl) throws SQLException {
        return null;
    }

    public ReferenceableDataSource() {
        this.update();
    }
}

