/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.context;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ShutdownException;
import org.apache.derby.iapi.services.context.SystemContext;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;

public final class ContextService {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private static ContextService factory;
    private HeaderPrintWriter errorStream;
    final ThreadLocal threadContextList = new ThreadLocal();
    private final HashSet allContexts;

    public static void stop() {
        factory = null;
    }

    public static ContextService getFactory() {
        ContextService contextService = factory;
        if (contextService == null) {
            throw new ShutdownException();
        }
        return contextService;
    }

    public static Context getContext(String string) {
        ContextManager contextManager = ContextService.getFactory().getCurrentContextManager();
        if (contextManager == null) {
            return null;
        }
        return contextManager.getContext(string);
    }

    public static Context getContextOrNull(String string) {
        ContextService contextService = factory;
        if (contextService == null) {
            return null;
        }
        ContextManager contextManager = contextService.getCurrentContextManager();
        if (contextManager == null) {
            return null;
        }
        return contextManager.getContext(string);
    }

    public ContextManager getCurrentContextManager() {
        Thread thread = Thread.currentThread();
        Object t = this.threadContextList.get();
        if (t instanceof ContextManager) {
            ContextManager contextManager = (ContextManager)t;
            if (contextManager.activeThread == thread) {
                return contextManager;
            }
            return null;
        }
        if (t == null) {
            return null;
        }
        Stack stack = (Stack)t;
        return (ContextManager)stack.peek();
    }

    public void resetCurrentContextManager(ContextManager contextManager) {
        if (contextManager.activeCount != -1) {
            if (--contextManager.activeCount == 0) {
                contextManager.activeThread = null;
            }
            return;
        }
        Stack stack = (Stack)this.threadContextList.get();
        Object e = stack.pop();
        ContextManager contextManager2 = (ContextManager)stack.peek();
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < stack.size()) {
            Object e2 = stack.elementAt(n);
            if (e2 != contextManager2) {
                bl = true;
            }
            if (e2 == contextManager) {
                bl2 = true;
            }
            ++n;
        }
        if (!bl2) {
            contextManager.activeThread = null;
            contextManager.activeCount = 0;
        }
        if (!bl) {
            contextManager2.activeCount = stack.size();
            this.threadContextList.set(contextManager2);
        }
    }

    private boolean addToThreadList(Thread thread, ContextManager contextManager) {
        Stack<ContextManager> stack;
        Object t = this.threadContextList.get();
        if (contextManager == t) {
            return true;
        }
        if (t == null) {
            this.threadContextList.set(contextManager);
            return true;
        }
        if (t instanceof ContextManager) {
            ContextManager contextManager2 = (ContextManager)t;
            if (thread == null) {
                thread = Thread.currentThread();
            }
            if (contextManager2.activeThread != thread) {
                this.threadContextList.set(contextManager);
                return true;
            }
            stack = new Stack<ContextManager>();
            this.threadContextList.set(stack);
            int n = 0;
            while (n < contextManager2.activeCount) {
                stack.push(contextManager2);
                ++n;
            }
            contextManager2.activeCount = -1;
        } else {
            stack = (Stack<ContextManager>)t;
        }
        stack.push(contextManager);
        contextManager.activeCount = -1;
        return false;
    }

    public void setCurrentContextManager(ContextManager contextManager) {
        Thread thread = null;
        if (contextManager.activeThread == null) {
            contextManager.activeThread = thread = Thread.currentThread();
        }
        if (this.addToThreadList(thread, contextManager)) {
            ++contextManager.activeCount;
        }
    }

    public ContextManager newContextManager() {
        ContextManager contextManager = new ContextManager(this, this.errorStream);
        new SystemContext(contextManager);
        ContextService contextService = this;
        synchronized (contextService) {
            this.allContexts.add(contextManager);
        }
        return contextManager;
    }

    public void notifyAllActiveThreads(Context context) {
        Thread thread = Thread.currentThread();
        ContextService contextService = this;
        synchronized (contextService) {
            Iterator iterator = this.allContexts.iterator();
            while (iterator.hasNext()) {
                ContextManager contextManager = (ContextManager)iterator.next();
                Thread thread2 = contextManager.activeThread;
                if (thread2 == thread || thread2 == null || !contextManager.setInterrupted(context)) continue;
                thread2.interrupt();
            }
        }
    }

    synchronized void removeContext(ContextManager contextManager) {
        this.allContexts.remove(contextManager);
    }

    public ContextService() {
        this.errorStream = Monitor.getStream();
        factory = this;
        this.allContexts = new HashSet();
    }
}

