/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.store.access;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.Storable;
import org.apache.derby.iapi.store.access.KeyHasher;
import org.apache.derby.iapi.store.access.RowSource;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.PropertyUtil;

public class BackingStoreHashtable {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1999, 2004.";
    private Hashtable hash_table;
    private int[] key_column_numbers;
    private boolean remove_duplicates;
    private boolean skipNullKeyColumns;
    private Properties auxillary_runtimestats;
    private RowSource row_source;

    private Object[] getNextRowFromRowSource() throws StandardException {
        Object[] objectArray = this.row_source.getNextRowFromRowSource();
        if (this.skipNullKeyColumns) {
            while (objectArray != null) {
                int n = 0;
                while (n < this.key_column_numbers.length) {
                    Storable storable = (Storable)objectArray[this.key_column_numbers[n]];
                    if (storable.isNull()) break;
                    ++n;
                }
                if (n == this.key_column_numbers.length) {
                    return objectArray;
                }
                objectArray = this.row_source.getNextRowFromRowSource();
            }
        }
        return objectArray;
    }

    private Object[] cloneRow(Object[] objectArray) throws StandardException {
        Object[] objectArray2 = new DataValueDescriptor[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            objectArray2[n] = ((DataValueDescriptor)objectArray[n]).getClone();
            ++n;
        }
        return objectArray2;
    }

    private void add_row_to_hash_table(Hashtable hashtable, Object object, Object[] objectArray) throws StandardException {
        Object[] objectArray2 = null;
        objectArray2 = hashtable.put(object, objectArray);
        if (objectArray2 != null && !this.remove_duplicates) {
            Vector<Object[]> vector;
            if (objectArray2 instanceof Vector) {
                vector = (Vector<Object[]>)objectArray2;
            } else {
                vector = new Vector<Object[]>(2);
                vector.addElement(objectArray2);
            }
            vector.addElement(objectArray);
            hashtable.put(object, vector);
        }
        objectArray = null;
    }

    public void close() throws StandardException {
        this.hash_table = null;
    }

    public Enumeration elements() throws StandardException {
        return this.hash_table.elements();
    }

    public Object get(Object object) throws StandardException {
        return this.hash_table.get(object);
    }

    public void getAllRuntimeStats(Properties properties) throws StandardException {
        if (this.auxillary_runtimestats != null) {
            PropertyUtil.copyProperties(this.auxillary_runtimestats, properties);
        }
    }

    public Object remove(Object object) throws StandardException {
        return this.hash_table.remove(object);
    }

    public void setAuxillaryRuntimeStats(Properties properties) throws StandardException {
        this.auxillary_runtimestats = properties;
    }

    public boolean put(boolean bl, Object[] objectArray) throws StandardException {
        if (this.skipNullKeyColumns) {
            int n = 0;
            while (n < this.key_column_numbers.length) {
                Storable storable = (Storable)objectArray[this.key_column_numbers[n]];
                if (storable.isNull()) {
                    return false;
                }
                ++n;
            }
        }
        if (bl) {
            objectArray = this.cloneRow(objectArray);
        }
        Object object = KeyHasher.buildHashKey(objectArray, this.key_column_numbers);
        if (this.remove_duplicates && this.get(object) != null) {
            return false;
        }
        this.add_row_to_hash_table(this.hash_table, object, objectArray);
        return true;
    }

    public int size() throws StandardException {
        return this.hash_table.size();
    }

    private BackingStoreHashtable() {
    }

    public BackingStoreHashtable(TransactionController transactionController, RowSource rowSource, int[] nArray, boolean bl, long l, long l2, int n, float f, boolean bl2) throws StandardException {
        this.key_column_numbers = nArray;
        this.remove_duplicates = bl;
        this.row_source = rowSource;
        this.skipNullKeyColumns = bl2;
        if (n != -1) {
            this.hash_table = f == -1.0f ? new Hashtable(n) : new Hashtable(n, f);
        } else {
            Hashtable hashtable = this.hash_table = l <= 0L ? new Hashtable() : new Hashtable((int)l);
        }
        if (rowSource != null) {
            Object[] objectArray;
            boolean bl3 = rowSource.needsToClone();
            while ((objectArray = this.getNextRowFromRowSource()) != null) {
                if (bl3) {
                    objectArray = this.cloneRow(objectArray);
                }
                Object object = KeyHasher.buildHashKey(objectArray, nArray);
                this.add_row_to_hash_table(this.hash_table, object, objectArray);
            }
        }
    }
}

