/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.UTFDataFormatException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.CollationElementIterator;
import java.text.CollationKey;
import java.text.DateFormat;
import java.text.RuleBasedCollator;
import java.util.Calendar;
import java.util.Locale;
import org.apache.derby.iapi.db.DatabaseContext;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.i18n.LocaleFinder;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.FormatIdInputStream;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.ConcatableDataValue;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.Like;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLDate;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLTime;
import org.apache.derby.iapi.types.SQLTimestamp;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.util.StringUtil;

public class SQLChar
extends DataType
implements StringDataValue,
StreamStorable {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1999, 2004.";
    private static final char[] BLANKS = new char[40];
    private static final int BASE_MEMORY_USAGE;
    char[][] arg_passer = new char[1][];
    private String value;
    private char[] rawData;
    private int rawLength = -1;
    private CollationKey cKey;
    protected InputStream stream;
    private int[] intArray;
    private int intLength;
    private LocaleFinder localeFinder;
    private static /* synthetic */ Class class$Lorg$apache$derby$iapi$types$SQLChar;

    public static void appendBlanks(char[] cArray, int n, int n2) {
        while (n2 > 0) {
            int n3 = n2 > BLANKS.length ? BLANKS.length : n2;
            System.arraycopy(BLANKS, 0, cArray, n, n3);
            n2 -= n3;
            n += n3;
        }
    }

    public boolean getBoolean() throws StandardException {
        if (this.isNull()) {
            return false;
        }
        String string = this.getString().trim();
        return !(string.equals("0") || string.equals("false"));
    }

    public byte getByte() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            return Byte.parseByte(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("22018", "byte");
        }
    }

    public short getShort() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            return Short.parseShort(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("22018", "short");
        }
    }

    public int getInt() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            return Integer.parseInt(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("22018", "int");
        }
    }

    public long getLong() throws StandardException {
        if (this.isNull()) {
            return 0L;
        }
        try {
            return Long.parseLong(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("22018", "long");
        }
    }

    public float getFloat() throws StandardException {
        if (this.isNull()) {
            return 0.0f;
        }
        try {
            return new Float(this.getString().trim()).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("22018", "float");
        }
    }

    public double getDouble() throws StandardException {
        if (this.isNull()) {
            return 0.0;
        }
        try {
            return new Double(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("22018", "double");
        }
    }

    public BigDecimal getBigDecimal() throws StandardException {
        if (this.isNull()) {
            return null;
        }
        try {
            return new BigDecimal(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("22018", "java.math.BigDecimal");
        }
    }

    public Date getDate(Calendar calendar) throws StandardException {
        return SQLChar.getDate(calendar, this.getString(), this.getLocaleFinder());
    }

    public static Date getDate(Calendar calendar, String string, LocaleFinder localeFinder) throws StandardException {
        if (string == null) {
            return null;
        }
        SQLDate sQLDate = new SQLDate(string, false, localeFinder);
        return sQLDate.getDate(calendar);
    }

    public Time getTime(Calendar calendar) throws StandardException {
        return SQLChar.getTime(calendar, this.getString(), this.getLocaleFinder());
    }

    public static Time getTime(Calendar calendar, String string, LocaleFinder localeFinder) throws StandardException {
        if (string == null) {
            return null;
        }
        SQLTime sQLTime = new SQLTime(string, false, localeFinder, calendar);
        return sQLTime.getTime(calendar);
    }

    public Timestamp getTimestamp(Calendar calendar) throws StandardException {
        return SQLChar.getTimestamp(calendar, this.getString(), this.getLocaleFinder());
    }

    public static Timestamp getTimestamp(Calendar calendar, String string, LocaleFinder localeFinder) throws StandardException {
        if (string == null) {
            return null;
        }
        SQLTimestamp sQLTimestamp = new SQLTimestamp(string, false, localeFinder, calendar);
        return sQLTimestamp.getTimestamp(calendar);
    }

    public Object getObject() throws StandardException {
        return this.getString();
    }

    public InputStream getStream() throws StandardException {
        return this.stream;
    }

    public int getLength() throws StandardException {
        if (this.rawLength != -1) {
            return this.rawLength;
        }
        String string = this.getString();
        return string == null ? 0 : string.length();
    }

    public String getTypeName() {
        return "CHAR";
    }

    public String getString() throws StandardException {
        if (this.value == null) {
            int n = this.rawLength;
            if (n != -1) {
                this.value = new String(this.rawData, 0, n);
                if (n > 4096) {
                    this.rawData = null;
                    this.rawLength = -1;
                    this.intArray = null;
                    this.intLength = 0;
                    this.cKey = null;
                }
            } else if (this.stream != null) {
                try {
                    if (this.stream instanceof FormatIdInputStream) {
                        this.readExternal((FormatIdInputStream)this.stream);
                    } else {
                        this.readExternal(new FormatIdInputStream(this.stream));
                    }
                    this.stream = null;
                    return this.getString();
                }
                catch (IOException iOException) {
                    throw StandardException.newException("XCL30.S", iOException, (Object)"java.sql.String");
                }
            }
        }
        return this.value;
    }

    public char[] getCharArray() throws StandardException {
        if (this.isNull()) {
            return null;
        }
        if (this.rawLength != -1) {
            return this.rawData;
        }
        this.getString();
        this.rawData = this.value.toCharArray();
        this.rawLength = this.rawData.length;
        this.intArray = null;
        this.intLength = 0;
        this.cKey = null;
        return this.rawData;
    }

    public InputStream returnStream() {
        return this.stream;
    }

    public void setStream(InputStream inputStream) {
        this.value = null;
        this.rawLength = -1;
        this.stream = inputStream;
        this.intArray = null;
        this.intLength = 0;
        this.cKey = null;
    }

    public void loadStream() throws StandardException {
        this.getString();
    }

    public int getTypeFormatId() {
        return 78;
    }

    public boolean isNull() {
        return this.value == null && this.rawLength == -1 && this.stream == null;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n;
        boolean bl;
        String string = null;
        char[] cArray = null;
        int n2 = this.rawLength;
        if (n2 < 0) {
            string = this.value;
            n2 = string.length();
            bl = false;
        } else {
            cArray = this.rawData;
            bl = true;
        }
        int n3 = n2;
        int n4 = 0;
        while (n4 < n2 && n3 <= 65535) {
            int n5 = n = bl ? cArray[n4] : string.charAt(n4);
            if (n < 1 || n > 127) {
                n3 = n > 2047 ? (n3 += 2) : ++n3;
            }
            ++n4;
        }
        n4 = 0;
        if (n3 > 65535) {
            n4 = 1;
            n3 = 0;
        }
        objectOutput.write(n3 >>> 8 & 0xFF);
        objectOutput.write(n3 & 0xFF);
        n = 0;
        while (n < n2) {
            char c;
            char c2 = c = bl ? cArray[n] : string.charAt(n);
            if (c >= '\u0001' && c <= '\u007f') {
                objectOutput.write(c);
            } else if (c > '\u07ff') {
                objectOutput.write(0xE0 | c >> 12 & 0xF);
                objectOutput.write(0x80 | c >> 6 & 0x3F);
                objectOutput.write(0x80 | c & 0x3F);
            } else {
                objectOutput.write(0xC0 | c >> 6 & 0x1F);
                objectOutput.write(0x80 | c & 0x3F);
            }
            ++n;
        }
        if (n4 != 0) {
            objectOutput.write(224);
            objectOutput.write(0);
            objectOutput.write(0);
        }
    }

    public void readExternalFromArray(ArrayInputStream arrayInputStream) throws IOException {
        this.arg_passer[0] = this.rawData;
        this.rawLength = arrayInputStream.readCloudscapeUTF(this.arg_passer);
        this.rawData = this.arg_passer[0];
        this.value = null;
        this.stream = null;
        this.intArray = null;
        this.intLength = 0;
        this.cKey = null;
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        int n;
        int n2 = objectInput.readUnsignedShort();
        if (n2 != 0) {
            n = n2;
        } else {
            n = objectInput.available();
            if (n < 64) {
                n = 64;
            }
        }
        char[] cArray = this.rawData == null || n > this.rawData.length ? new char[n] : this.rawData;
        int n3 = cArray.length;
        this.rawData = null;
        this.restoreToNull();
        int n4 = 0;
        int n5 = 0;
        while (n4 < n2 || n2 == 0) {
            char c;
            int n6;
            int n7;
            int n8;
            try {
                n8 = objectInput.readUnsignedByte();
            }
            catch (EOFException eOFException) {
                if (n2 == 0) break;
                throw new EOFException();
            }
            if (n5 >= n3) {
                n7 = objectInput.available();
                if (n7 < 64) {
                    n7 = 64;
                }
                n6 = n3 + n7;
                char[] cArray2 = cArray;
                cArray = new char[n6];
                System.arraycopy(cArray2, 0, cArray, 0, n3);
                n3 = n6;
            }
            if ((n8 & 0x80) == 0) {
                ++n4;
                c = (char)n8;
            } else if ((n8 & 0x60) == 64) {
                if (n2 != 0 && (n4 += 2) > n2) {
                    throw new UTFDataFormatException();
                }
                n7 = objectInput.readUnsignedByte();
                if ((n7 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                c = (char)((n8 & 0x1F) << 6 | n7 & 0x3F);
            } else if ((n8 & 0x70) == 96) {
                if (n2 != 0 && (n4 += 3) > n2) {
                    throw new UTFDataFormatException();
                }
                n7 = objectInput.readUnsignedByte();
                n6 = objectInput.readUnsignedByte();
                if (n8 == 224 && n7 == 0 && n6 == 0 && n2 == 0) break;
                if ((n7 & 0xC0) != 128 || (n6 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                c = (char)((n8 & 0xF) << 12 | (n7 & 0x3F) << 6 | n6 & 0x3F);
            } else {
                throw new UTFDataFormatException();
            }
            cArray[n5++] = c;
        }
        this.rawData = cArray;
        this.rawLength = n5;
        this.intArray = null;
        this.intLength = 0;
        this.cKey = null;
    }

    public void restoreToNull() {
        this.value = null;
        this.stream = null;
        this.rawLength = -1;
        this.intArray = null;
        this.intLength = 0;
        this.cKey = null;
    }

    public boolean compare(int n, DataValueDescriptor dataValueDescriptor, boolean bl, boolean bl2) throws StandardException {
        if (!bl && (this.isNull() || dataValueDescriptor.isNull())) {
            return bl2;
        }
        if (!(dataValueDescriptor instanceof SQLChar)) {
            return dataValueDescriptor.compare(DataType.flip(n), this, bl, bl2);
        }
        return super.compare(n, dataValueDescriptor, bl, bl2);
    }

    public int compare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (this.typePrecedence() < dataValueDescriptor.typePrecedence()) {
            return -dataValueDescriptor.compare(this);
        }
        return this.stringCompare(this, (SQLChar)dataValueDescriptor);
    }

    public Object cloneObject() {
        if (this.stream == null) {
            return this.getClone();
        }
        SQLChar sQLChar = (SQLChar)this.getNewNull();
        sQLChar.copyState(this);
        return sQLChar;
    }

    public DataValueDescriptor getClone() {
        try {
            return new SQLChar(this.getString());
        }
        catch (StandardException standardException) {
            return null;
        }
    }

    public DataValueDescriptor getNewNull() {
        return new SQLChar();
    }

    public final void setValueFromResultSet(ResultSet resultSet, int n, boolean bl) throws SQLException {
        this.setValue(resultSet.getString(n));
    }

    public final void setInto(PreparedStatement preparedStatement, int n) throws SQLException, StandardException {
        preparedStatement.setString(n, this.getString());
    }

    public void setValue(String string) {
        this.stream = null;
        this.rawLength = -1;
        this.intArray = null;
        this.intLength = 0;
        this.cKey = null;
        this.value = string;
    }

    public void setValue(boolean bl) throws StandardException {
        this.setValue(bl ? "1" : "0");
    }

    public void setValue(Boolean bl) throws StandardException {
        this.setValue((Object)bl);
    }

    public void setValue(int n) throws StandardException {
        this.setValue(Integer.toString(n));
    }

    public void setValue(Integer n) throws StandardException {
        this.setValue((Object)n);
    }

    public void setValue(double d) throws StandardException {
        this.setValue(Double.toString(d));
    }

    public void setValue(Double d) throws StandardException {
        this.setValue((Object)d);
    }

    public void setValue(float f) throws StandardException {
        this.setValue(Float.toString(f));
    }

    public void setValue(Float f) throws StandardException {
        this.setValue((Object)f);
    }

    public void setValue(short s) throws StandardException {
        this.setValue(Short.toString(s));
    }

    public void setValue(Short s) throws StandardException {
        this.setValue((Object)s);
    }

    public void setValue(long l) throws StandardException {
        this.setValue(Long.toString(l));
    }

    public void setValue(Long l) throws StandardException {
        this.setValue((Object)l);
    }

    public void setValue(byte by) throws StandardException {
        this.setValue(Byte.toString(by));
    }

    public void setValue(Byte by) throws StandardException {
        this.setValue((Object)by);
    }

    public void setValue(byte[] byArray) throws StandardException {
        if (byArray == null) {
            this.restoreToNull();
            return;
        }
        int n = byArray.length % 2;
        int n2 = byArray.length / 2 + n;
        char[] cArray = new char[n2];
        int n3 = 0;
        int n4 = 0;
        if (n == 1) {
            cArray[--n2] = (char)(byArray[byArray.length - 1] << 8);
        }
        while (n3 < n2) {
            cArray[n3] = (char)(byArray[n4] << 8 | byArray[n4 + 1] & 0xFF);
            n4 += 2;
            ++n3;
        }
        this.setValue(new String(cArray));
    }

    public void setValue(BigDecimal bigDecimal) throws StandardException {
        this.setValue((Object)bigDecimal);
    }

    public void setValue(Date date, Calendar calendar) throws StandardException {
        String string = null;
        if (date != null) {
            if (calendar == null) {
                string = date.toString();
            } else {
                calendar.setTime(date);
                StringBuffer stringBuffer = new StringBuffer();
                this.formatJDBCDate(calendar, stringBuffer);
                string = stringBuffer.toString();
            }
        }
        this.setValue(string);
    }

    public void setValue(Time time, Calendar calendar) throws StandardException {
        String string = null;
        if (time != null) {
            if (calendar == null) {
                string = time.toString();
            } else {
                calendar.setTime(time);
                StringBuffer stringBuffer = new StringBuffer();
                this.formatJDBCTime(calendar, stringBuffer);
                string = stringBuffer.toString();
            }
        }
        this.setValue(string);
    }

    public void setValue(Timestamp timestamp, Calendar calendar) throws StandardException {
        String string = null;
        if (timestamp != null) {
            if (calendar == null) {
                string = timestamp.toString();
            } else {
                calendar.setTime(timestamp);
                StringBuffer stringBuffer = new StringBuffer();
                this.formatJDBCDate(calendar, stringBuffer);
                stringBuffer.append(' ');
                this.formatJDBCTime(calendar, stringBuffer);
                int n = (timestamp.getNanos() + 500) / 1000;
                if (n > 0) {
                    stringBuffer.append('.');
                    String string2 = Integer.toString(n);
                    if (string2.length() > 6) {
                        stringBuffer.append(string2.substring(0, 6));
                    } else {
                        int n2 = string2.length();
                        while (n2 < 6) {
                            stringBuffer.append('0');
                            ++n2;
                        }
                        stringBuffer.append(string2);
                    }
                }
                string = stringBuffer.toString();
            }
        }
        this.setValue(string);
    }

    private void formatJDBCDate(Calendar calendar, StringBuffer stringBuffer) {
        SQLDate.dateToString(calendar.get(1), calendar.get(2) + 1, calendar.get(5), stringBuffer);
    }

    private void formatJDBCTime(Calendar calendar, StringBuffer stringBuffer) {
        SQLTime.timeToString(calendar.get(10), calendar.get(12), calendar.get(13), stringBuffer);
    }

    public void setValue(InputStream inputStream, int n) {
        this.value = null;
        this.rawLength = -1;
        this.stream = inputStream;
        this.intArray = null;
        this.intLength = 0;
        this.cKey = null;
    }

    public void setValue(Object object) throws StandardException {
        if (object instanceof String || object == null) {
            this.setValue((String)object);
        } else {
            this.setValue(object.toString());
        }
    }

    protected void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        this.setValue(dataValueDescriptor.getString());
    }

    private void setAsToNationalString(Object object) {
        String string = null;
        if (object != null) {
            string = object.toString();
        }
        this.setValue(string);
    }

    public void normalize(DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor) throws StandardException {
        this.normalize(dataTypeDescriptor, dataValueDescriptor.getString());
    }

    protected void normalize(DataTypeDescriptor dataTypeDescriptor, String string) throws StandardException {
        int n = dataTypeDescriptor.getMaximumWidth();
        int n2 = string.length();
        if (n2 == n) {
            this.setValue(string);
            return;
        }
        if (n2 < n) {
            char[] cArray;
            this.setToNull();
            if (this.rawData == null || n > this.rawData.length) {
                this.rawData = new char[n];
                cArray = this.rawData;
            } else {
                cArray = this.rawData;
            }
            string.getChars(0, n2, cArray, 0);
            SQLChar.appendBlanks(cArray, n2, n - n2);
            this.rawLength = n;
            return;
        }
        this.hasNonBlankChars(string, n, n2);
        String string2 = string.substring(0, n);
        this.setValue(string2);
    }

    protected final void hasNonBlankChars(String string, int n, int n2) throws StandardException {
        int n3 = n;
        while (n3 < n2) {
            if (string.charAt(n3) != ' ') {
                throw StandardException.newException("22001", this.getTypeName(), (Object)StringUtil.formatForPrint(string), (Object)String.valueOf(n));
            }
            ++n3;
        }
    }

    public DataValueDescriptor setWidth(int n, int n2, boolean bl) throws StandardException {
        if (this.getString() == null) {
            return this;
        }
        int n3 = this.getLength();
        if (n3 < n) {
            if (!(this instanceof SQLVarchar)) {
                StringBuffer stringBuffer = new StringBuffer(this.getString());
                while (n3 < n) {
                    stringBuffer.append(' ');
                    ++n3;
                }
                this.setValue(new String(stringBuffer));
            }
        } else if (n3 > n && n > 0) {
            if (bl) {
                this.hasNonBlankChars(this.getString(), n, n3);
            }
            this.setValue(this.getString().substring(0, n));
        }
        return this;
    }

    public BooleanDataValue equals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        boolean bl = dataValueDescriptor instanceof SQLChar && dataValueDescriptor2 instanceof SQLChar ? this.stringCompare((SQLChar)dataValueDescriptor, (SQLChar)dataValueDescriptor2) == 0 : SQLChar.stringCompare(dataValueDescriptor.getString(), dataValueDescriptor2.getString()) == 0;
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, bl);
    }

    public BooleanDataValue notEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        boolean bl = dataValueDescriptor instanceof SQLChar && dataValueDescriptor2 instanceof SQLChar ? this.stringCompare((SQLChar)dataValueDescriptor, (SQLChar)dataValueDescriptor2) != 0 : SQLChar.stringCompare(dataValueDescriptor.getString(), dataValueDescriptor2.getString()) != 0;
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, bl);
    }

    public BooleanDataValue lessThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        boolean bl = dataValueDescriptor instanceof SQLChar && dataValueDescriptor2 instanceof SQLChar ? this.stringCompare((SQLChar)dataValueDescriptor, (SQLChar)dataValueDescriptor2) < 0 : SQLChar.stringCompare(dataValueDescriptor.getString(), dataValueDescriptor2.getString()) < 0;
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, bl);
    }

    public BooleanDataValue greaterThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        boolean bl = dataValueDescriptor instanceof SQLChar && dataValueDescriptor2 instanceof SQLChar ? this.stringCompare((SQLChar)dataValueDescriptor, (SQLChar)dataValueDescriptor2) > 0 : SQLChar.stringCompare(dataValueDescriptor.getString(), dataValueDescriptor2.getString()) > 0;
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, bl);
    }

    public BooleanDataValue lessOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        boolean bl = dataValueDescriptor instanceof SQLChar && dataValueDescriptor2 instanceof SQLChar ? this.stringCompare((SQLChar)dataValueDescriptor, (SQLChar)dataValueDescriptor2) <= 0 : SQLChar.stringCompare(dataValueDescriptor.getString(), dataValueDescriptor2.getString()) <= 0;
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, bl);
    }

    public BooleanDataValue greaterOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        boolean bl = dataValueDescriptor instanceof SQLChar && dataValueDescriptor2 instanceof SQLChar ? this.stringCompare((SQLChar)dataValueDescriptor, (SQLChar)dataValueDescriptor2) >= 0 : SQLChar.stringCompare(dataValueDescriptor.getString(), dataValueDescriptor2.getString()) >= 0;
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, bl);
    }

    public NumberDataValue charLength(NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            numberDataValue = new SQLInteger();
        }
        if (this.isNull()) {
            numberDataValue.setToNull();
            return numberDataValue;
        }
        numberDataValue.setValue(this.getLength());
        return numberDataValue;
    }

    public StringDataValue concatenate(StringDataValue stringDataValue, StringDataValue stringDataValue2, StringDataValue stringDataValue3) throws StandardException {
        if (stringDataValue.isNull() || stringDataValue.getString() == null || stringDataValue2.isNull() || stringDataValue2.getString() == null) {
            stringDataValue3.setToNull();
            return stringDataValue3;
        }
        stringDataValue3.setValue(stringDataValue.getString().concat(stringDataValue2.getString()));
        return stringDataValue3;
    }

    public BooleanDataValue like(DataValueDescriptor dataValueDescriptor) throws StandardException {
        Boolean bl;
        if (!this.isNationalString()) {
            char[] cArray = this.getCharArray();
            char[] cArray2 = ((SQLChar)dataValueDescriptor).getCharArray();
            bl = Like.like(cArray, this.getLength(), cArray2, dataValueDescriptor.getLength());
        } else {
            SQLChar sQLChar = (SQLChar)dataValueDescriptor;
            bl = Like.like(this.getIntArray(), this.getIntLength(), sQLChar.getIntArray(), sQLChar.getIntLength(), this.getLocaleFinder().getCollator());
        }
        return SQLBoolean.truthValue((DataValueDescriptor)this, dataValueDescriptor, bl);
    }

    public BooleanDataValue like(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        Boolean bl;
        if (dataValueDescriptor2.isNull()) {
            throw StandardException.newException("22501");
        }
        if (!this.isNationalString()) {
            char[] cArray = this.getCharArray();
            char[] cArray2 = ((SQLChar)dataValueDescriptor).getCharArray();
            char[] cArray3 = ((SQLChar)dataValueDescriptor2).getCharArray();
            int n = dataValueDescriptor2.getLength();
            if (cArray3 != null && n != 1) {
                throw StandardException.newException("22019", new String(cArray3));
            }
            SQLChar sQLChar = (SQLChar)dataValueDescriptor2;
            int[] nArray = sQLChar.getIntArray();
            if (nArray != null && nArray.length != 1) {
                throw StandardException.newException("22019", new String(sQLChar.getCharArray()));
            }
            bl = Like.like(cArray, this.getLength(), cArray2, dataValueDescriptor.getLength(), cArray3, n);
        } else {
            SQLChar sQLChar = (SQLChar)dataValueDescriptor;
            SQLChar sQLChar2 = (SQLChar)dataValueDescriptor2;
            int[] nArray = sQLChar2.getIntArray();
            int n = sQLChar2.getIntLength();
            if (nArray != null && nArray.length != 1) {
                throw StandardException.newException("22019", new String(sQLChar2.getCharArray()));
            }
            bl = Like.like(this.getIntArray(), this.getIntLength(), sQLChar.getIntArray(), sQLChar.getIntLength(), nArray, n, this.getLocaleFinder().getCollator());
        }
        return SQLBoolean.truthValue((DataValueDescriptor)this, dataValueDescriptor, bl);
    }

    public NumberDataValue locate(StringDataValue stringDataValue, NumberDataValue numberDataValue, NumberDataValue numberDataValue2) throws StandardException {
        if (numberDataValue2 == null) {
            numberDataValue2 = new SQLInteger();
        }
        int n = numberDataValue.isNull() ? 1 : numberDataValue.getInt();
        if (this.isNull() || stringDataValue.isNull()) {
            numberDataValue2.setToNull();
            return numberDataValue2;
        }
        String string = stringDataValue.getString();
        String string2 = this.getString();
        if (n < 1) {
            throw StandardException.newException("22014", new String(this.getString()), (Object)new String(string), (Object)new Integer(n));
        }
        if (string2.length() == 0) {
            numberDataValue2.setValue(n);
            return numberDataValue2;
        }
        numberDataValue2.setValue(string.indexOf(string2, n - 1) + 1);
        return numberDataValue2;
    }

    public ConcatableDataValue substring(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, ConcatableDataValue concatableDataValue, int n) throws StandardException {
        if (concatableDataValue == null) {
            concatableDataValue = this.getNewVarchar();
        }
        StringDataValue stringDataValue = (StringDataValue)concatableDataValue;
        if (this.isNull() || numberDataValue.isNull() || numberDataValue2 != null && numberDataValue2.isNull()) {
            stringDataValue.setToNull();
            return stringDataValue;
        }
        int n2 = numberDataValue.getInt();
        int n3 = numberDataValue2 != null ? numberDataValue2.getInt() : n - n2 + 1;
        if (n2 <= 0 || n3 < 0 || n2 > n || n3 > n - n2 + 1) {
            throw StandardException.newException("22011");
        }
        if (n3 < 0) {
            stringDataValue.setToNull();
            return stringDataValue;
        }
        if (n2 < 0) {
            if (n2 + this.getLength() < 0 && n2 + this.getLength() + n3 <= 0) {
                stringDataValue.setValue("");
                return stringDataValue;
            }
            n2 += this.getLength();
            while (n2 < 0) {
                ++n2;
                --n3;
            }
        } else if (n2 > 0) {
            --n2;
        }
        if (n3 == 0 || n3 <= -n2 || n2 > this.getLength()) {
            stringDataValue.setValue("");
            return stringDataValue;
        }
        if (n3 >= this.getLength() - n2) {
            stringDataValue.setValue(this.getString().substring(n2));
        } else {
            stringDataValue.setValue(this.getString().substring(n2, n2 + n3));
        }
        return stringDataValue;
    }

    public StringDataValue trim(int n, StringDataValue stringDataValue) throws StandardException {
        int n2;
        boolean bl;
        int n3;
        if (stringDataValue == null) {
            stringDataValue = this.getNewVarchar();
        }
        if (this.isNull()) {
            stringDataValue.setToNull();
            return stringDataValue;
        }
        char[] cArray = new char[]{' '};
        String string = this.getString();
        if (n == 2) {
            n3 = 0;
            while (n3 < string.length()) {
                bl = false;
                n2 = 0;
                while (n2 < cArray.length) {
                    if (string.charAt(n3) == cArray[n2]) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl) break;
                ++n3;
            }
            if (n3 == string.length()) {
                string = "";
            } else if (n3 > 0) {
                string = string.substring(n3);
            }
        }
        if (n == 1) {
            n3 = string.length();
            while (n3 > 0) {
                bl = false;
                n2 = 0;
                while (n2 < cArray.length) {
                    if (string.charAt(n3 - 1) == cArray[n2]) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl) break;
                --n3;
            }
            if (n3 == 0) {
                string = "";
            } else if (n3 < string.length()) {
                string = string.substring(0, n3);
            }
        }
        stringDataValue.setValue(string);
        return stringDataValue;
    }

    public StringDataValue upper(StringDataValue stringDataValue) throws StandardException {
        if (stringDataValue == null) {
            stringDataValue = (StringDataValue)this.getNewNull();
        }
        if (this.isNull()) {
            stringDataValue.setToNull();
            return stringDataValue;
        }
        String string = this.getString();
        string = string.toUpperCase(this.getLocale());
        stringDataValue.setValue(string);
        return stringDataValue;
    }

    public StringDataValue lower(StringDataValue stringDataValue) throws StandardException {
        if (stringDataValue == null) {
            stringDataValue = (StringDataValue)this.getNewNull();
        }
        if (this.isNull()) {
            stringDataValue.setToNull();
            return stringDataValue;
        }
        String string = this.getString();
        string = string.toLowerCase(this.getLocale());
        stringDataValue.setValue(string);
        return stringDataValue;
    }

    public int typePrecedence() {
        return 0;
    }

    protected static int stringCompare(String string, String string2) {
        int n;
        String string3;
        int n2;
        int n3;
        if (string == null || string2 == null) {
            if (string != null) {
                return -1;
            }
            if (string2 != null) {
                return 1;
            }
            return 0;
        }
        int n4 = string.length();
        int n5 = n4 < (n3 = string2.length()) ? n4 : n3;
        int n6 = 0;
        while (n6 < n5) {
            char c;
            char c2 = string.charAt(n6);
            if (c2 != (c = string2.charAt(n6))) {
                if (c2 < c) {
                    return -1;
                }
                return 1;
            }
            ++n6;
        }
        if (n4 == n3) {
            return 0;
        }
        if (n4 > n3) {
            n2 = -1;
            string3 = string;
            n6 = n3;
            n = n4;
        } else {
            n2 = 1;
            string3 = string2;
            n6 = n4;
            n = n3;
        }
        while (n6 < n) {
            char c = string3.charAt(n6);
            if (c < ' ') {
                return n2;
            }
            if (c > ' ') {
                return -n2;
            }
            ++n6;
        }
        return 0;
    }

    protected int stringCompare(SQLChar sQLChar, SQLChar sQLChar2) throws StandardException {
        return SQLChar.stringCompare(sQLChar.getCharArray(), sQLChar.getLength(), sQLChar2.getCharArray(), sQLChar2.getLength());
    }

    protected static int stringCompare(char[] cArray, int n, char[] cArray2, int n2) {
        int n3;
        char[] cArray3;
        int n4;
        if (cArray == null || cArray2 == null) {
            if (cArray != null) {
                return -1;
            }
            if (cArray2 != null) {
                return 1;
            }
            return 0;
        }
        int n5 = n < n2 ? n : n2;
        int n6 = 0;
        while (n6 < n5) {
            char c = cArray[n6];
            char c2 = cArray2[n6];
            if (c != c2) {
                if (c < c2) {
                    return -1;
                }
                return 1;
            }
            ++n6;
        }
        if (n == n2) {
            return 0;
        }
        if (n > n2) {
            n4 = -1;
            cArray3 = cArray;
            n6 = n2;
            n3 = n;
        } else {
            n4 = 1;
            cArray3 = cArray2;
            n6 = n;
            n3 = n2;
        }
        while (n6 < n3) {
            char c = cArray3[n6];
            if (c < ' ') {
                return n4;
            }
            if (c > ' ') {
                return -n4;
            }
            ++n6;
        }
        return 0;
    }

    protected int stringCollatorCompare(SQLChar sQLChar) throws StandardException {
        CollationKey collationKey = this.getCollationKey();
        CollationKey collationKey2 = sQLChar.getCollationKey();
        if (collationKey == null || collationKey2 == null) {
            if (collationKey != null) {
                return -1;
            }
            if (collationKey2 != null) {
                return 1;
            }
            return 0;
        }
        return collationKey.compareTo(collationKey2);
    }

    protected CollationKey getCollationKey() throws StandardException {
        char[] cArray;
        if (this.cKey != null) {
            return this.cKey;
        }
        if (this.rawLength == -1 && (cArray = this.getCharArray()) == null) {
            return null;
        }
        int n = this.rawLength;
        while (n > 0 && this.rawData[n - 1] == ' ') {
            --n;
        }
        RuleBasedCollator ruleBasedCollator = this.getLocaleFinder().getCollator();
        this.cKey = ruleBasedCollator.getCollationKey(new String(this.rawData, 0, n));
        return this.cKey;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        if (this.value == null && this.rawLength != -1) {
            return new String(this.rawData, 0, this.rawLength);
        }
        if (this.stream != null) {
            try {
                return this.getString();
            }
            catch (Exception exception) {
                return exception.toString();
            }
        }
        return this.value;
    }

    public int hashCode() {
        try {
            if (this.getString() == null) {
                return 0;
            }
        }
        catch (StandardException standardException) {
            return 0;
        }
        int n = 0;
        String string = this.value;
        int n2 = string.length() - 1;
        while (n2 >= 0 && string.charAt(n2) == ' ') {
            --n2;
        }
        while (n2 >= 0) {
            n += string.charAt(n2);
            --n2;
        }
        return n;
    }

    protected int nationalHashCode() {
        CollationKey collationKey = null;
        try {
            collationKey = this.getCollationKey();
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        if (collationKey == null) {
            return 0;
        }
        return collationKey.hashCode();
    }

    private int[] getIntArray() throws StandardException {
        int n;
        if (this.isNull()) {
            return null;
        }
        if (this.intArray != null) {
            return this.intArray;
        }
        this.intArray = new int[this.getLength()];
        RuleBasedCollator ruleBasedCollator = this.getLocaleFinder().getCollator();
        CollationElementIterator collationElementIterator = ruleBasedCollator.getCollationElementIterator(this.getString());
        while ((n = collationElementIterator.next()) != -1) {
            if (this.intLength == this.intArray.length) {
                int[] nArray = this.intArray;
                this.intArray = new int[this.intLength + 5];
                int n2 = 0;
                while (n2 < nArray.length) {
                    this.intArray[n2] = nArray[n2];
                    ++n2;
                }
            }
            this.intArray[this.intLength++] = n;
        }
        return this.intArray;
    }

    private int getIntLength() {
        return this.intLength;
    }

    protected StringDataValue getNewVarchar() throws StandardException {
        return new SQLVarchar();
    }

    protected boolean isNationalString() {
        return false;
    }

    protected Date nationalGetDate(Calendar calendar) throws StandardException {
        if (this.isNull()) {
            return null;
        }
        SQLDate sQLDate = new SQLDate(this.getString(), false, this.getLocaleFinder(), calendar);
        return sQLDate.getDate(calendar);
    }

    protected Time nationalGetTime(Calendar calendar) throws StandardException {
        if (this.isNull()) {
            return null;
        }
        SQLTime sQLTime = new SQLTime(this.getString(), false, this.getLocaleFinder(), calendar);
        return sQLTime.getTime(calendar);
    }

    protected Timestamp nationalGetTimestamp(Calendar calendar) throws StandardException {
        return SQLChar.getTimestamp(calendar, this.getString(), this.getLocaleFinder());
    }

    protected void setLocaleFinder(LocaleFinder localeFinder) {
        this.localeFinder = localeFinder;
    }

    private Locale getLocale() throws StandardException {
        return this.getLocaleFinder().getCurrentLocale();
    }

    protected LocaleFinder getLocaleFinder() {
        DatabaseContext databaseContext;
        if (this.localeFinder == null && (databaseContext = (DatabaseContext)ContextService.getContext("Database")) != null) {
            this.localeFinder = databaseContext.getDatabase();
        }
        return this.localeFinder;
    }

    protected DateFormat getDateFormat() throws StandardException {
        return this.getLocaleFinder().getDateFormat();
    }

    protected DateFormat getTimeFormat() throws StandardException {
        return this.getLocaleFinder().getTimeFormat();
    }

    protected DateFormat getTimestampFormat() throws StandardException {
        return this.getLocaleFinder().getTimestampFormat();
    }

    protected DateFormat getDateFormat(Calendar calendar) throws StandardException {
        return this.setDateFormatCalendar(this.getLocaleFinder().getDateFormat(), calendar);
    }

    protected DateFormat getTimeFormat(Calendar calendar) throws StandardException {
        return this.setDateFormatCalendar(this.getLocaleFinder().getTimeFormat(), calendar);
    }

    protected DateFormat getTimestampFormat(Calendar calendar) throws StandardException {
        return this.setDateFormatCalendar(this.getLocaleFinder().getTimestampFormat(), calendar);
    }

    private DateFormat setDateFormatCalendar(DateFormat dateFormat, Calendar calendar) {
        if (calendar != null && dateFormat.getTimeZone() != calendar.getTimeZone()) {
            dateFormat = (DateFormat)dateFormat.clone();
            dateFormat.setCalendar(calendar);
        }
        return dateFormat;
    }

    public int estimateMemoryUsage() {
        int n = BASE_MEMORY_USAGE + ClassSize.estimateMemoryUsage(this.value);
        if (this.rawData != null) {
            n += 2 * this.rawData.length;
        }
        if (this.intArray != null) {
            n += this.intArray.length * ClassSize.getIntSize();
        }
        return n;
    }

    protected void copyState(SQLChar sQLChar) {
        this.value = sQLChar.value;
        this.rawData = sQLChar.rawData;
        this.rawLength = sQLChar.rawLength;
        this.cKey = sQLChar.cKey;
        this.stream = sQLChar.stream;
        this.intArray = this.intArray;
        this.intLength = this.intLength;
        this.localeFinder = this.localeFinder;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public SQLChar() {
    }

    public SQLChar(String string) {
        this.value = string;
    }

    static {
        int n = 0;
        while (n < BLANKS.length) {
            SQLChar.BLANKS[n] = 32;
            ++n;
        }
        BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(class$Lorg$apache$derby$iapi$types$SQLChar != null ? class$Lorg$apache$derby$iapi$types$SQLChar : (class$Lorg$apache$derby$iapi$types$SQLChar = SQLChar.class$("org.apache.derby.iapi.types.SQLChar")));
    }
}

