/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.monitor;

import java.util.Hashtable;
import java.util.Properties;
import org.apache.derby.iapi.error.PassThroughException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.PersistentService;
import org.apache.derby.impl.services.monitor.BaseMonitor;
import org.apache.derby.io.WritableStorageFactory;

public class UpdateServiceProperties
extends Properties {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1998, 2004.";
    private PersistentService serviceType;
    private String serviceName;
    private WritableStorageFactory storageFactory;
    private boolean serviceBooted;

    public void setServiceBooted() {
        this.serviceBooted = true;
    }

    public void setStorageFactory(WritableStorageFactory writableStorageFactory) {
        this.storageFactory = writableStorageFactory;
    }

    public WritableStorageFactory getStorageFactory() {
        return this.storageFactory;
    }

    public Object put(Object object, Object object2) {
        Object object3 = ((Hashtable)this.defaults).put(object, object2);
        if (!((String)object).startsWith("derby.__rt.")) {
            this.update();
        }
        return object3;
    }

    public Object remove(Object object) {
        Object v = ((Hashtable)this.defaults).remove(object);
        if (v != null && !((String)object).startsWith("derby.__rt.")) {
            this.update();
        }
        return v;
    }

    public void saveServiceProperties() {
        try {
            this.serviceType.saveServiceProperties(this.serviceName, this.storageFactory, BaseMonitor.removeRuntimeProperties(this.defaults), false);
        }
        catch (StandardException standardException) {
            throw new PassThroughException(standardException);
        }
    }

    private void update() {
        try {
            if (this.serviceBooted) {
                this.serviceType.saveServiceProperties(this.serviceName, this.storageFactory, BaseMonitor.removeRuntimeProperties(this.defaults), true);
            }
        }
        catch (StandardException standardException) {
            throw new PassThroughException(standardException);
        }
    }

    public UpdateServiceProperties(PersistentService persistentService, String string, Properties properties, boolean bl) {
        super(properties);
        this.serviceType = persistentService;
        this.serviceName = string;
        this.serviceBooted = bl;
    }
}

