/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Arrays;
import java.util.Vector;
import org.apache.derby.catalog.AliasInfo;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.CreateStatementNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.TableName;

public class CreateAliasNode
extends CreateStatementNode {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1999, 2004.";
    String javaClassName;
    String methodName;
    char aliasType;
    boolean delimitedIdentifier;
    private AliasInfo aliasInfo;

    public void init(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) throws StandardException {
        TableName tableName = (TableName)object;
        this.initAndCheck(tableName);
        this.javaClassName = (String)object2;
        this.methodName = (String)object3;
        this.aliasType = ((Character)object5).charValue();
        this.delimitedIdentifier = (Boolean)object6;
        switch (this.aliasType) {
            case 'F': 
            case 'P': {
                Integer n;
                int n2;
                Object[] objectArray = (Object[])object4;
                Object[] objectArray2 = (Object[])objectArray[0];
                int n3 = ((Vector)objectArray2[0]).size();
                Object[] objectArray3 = null;
                Object[] objectArray4 = null;
                int[] nArray = null;
                if (n3 > 90) {
                    throw StandardException.newException("54023", String.valueOf(90), object, (Object)String.valueOf(n3));
                }
                if (n3 != 0) {
                    objectArray3 = new String[n3];
                    ((Vector)objectArray2[0]).copyInto(objectArray3);
                    objectArray4 = new TypeDescriptor[n3];
                    ((Vector)objectArray2[1]).copyInto(objectArray4);
                    nArray = new int[n3];
                    int n4 = 0;
                    while (n4 < n3) {
                        nArray[n4] = (Integer)((Vector)objectArray2[2]).elementAt(n4);
                        if (TypeId.getBuiltInTypeId(objectArray4[n4].getJDBCTypeId()).isLongConcatableTypeId()) {
                            throw StandardException.newException("42962", objectArray3[n4]);
                        }
                        ++n4;
                    }
                    if (n3 > 1) {
                        Object[] objectArray5 = new String[n3];
                        System.arraycopy(objectArray3, 0, objectArray5, 0, n3);
                        Arrays.sort(objectArray5);
                        n2 = 1;
                        while (n2 < objectArray5.length) {
                            if (((String)objectArray5[n2]).equals(objectArray5[n2 - 1])) {
                                throw StandardException.newException("42734", objectArray5[n2], (Object)this.getFullName());
                            }
                            ++n2;
                        }
                    }
                }
                n2 = (n = (Integer)objectArray[2]) == null ? 0 : n;
                Short s = (Short)objectArray[6];
                short s2 = s != null ? s : (this.aliasType == 'P' ? (short)0 : 1);
                Boolean bl = (Boolean)objectArray[7];
                boolean bl2 = bl == null ? true : bl;
                this.aliasInfo = new RoutineAliasInfo(this.methodName, n3, (String[])objectArray3, (TypeDescriptor[])objectArray4, nArray, n2, (Short)objectArray[5], s2, bl2, (TypeDescriptor)objectArray[8]);
                this.implicitCreateSchema = true;
                break;
            }
        }
    }

    public String getAliasName() {
        return this.getRelativeName();
    }

    public String getJavaClassName() {
        return this.javaClassName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public char getAliasType() {
        return this.aliasType;
    }

    public String statementToString() {
        switch (this.aliasType) {
            case 'P': {
                return "CREATE PROCEDURE";
            }
        }
        return "CREATE FUNCTION";
    }

    public QueryTreeNode bind() throws StandardException {
        return this;
    }

    public ConstantAction makeConstantAction() throws StandardException {
        String string;
        switch (this.aliasType) {
            case 'F': 
            case 'P': {
                string = this.getSchemaDescriptor().getSchemaName();
                break;
            }
            default: {
                string = null;
            }
        }
        return this.getGenericConstantActionFactory().getCreateAliasConstantAction(this.getRelativeName(), string, this.javaClassName, this.aliasInfo, this.aliasType);
    }
}

