/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.io.StringReader;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Parser;
import org.apache.derby.impl.sql.compile.CharStream;
import org.apache.derby.impl.sql.compile.ParseException;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.SQLParser;
import org.apache.derby.impl.sql.compile.SQLParserTokenManager;
import org.apache.derby.impl.sql.compile.TokenMgrError;
import org.apache.derby.impl.sql.compile.UCode_CharStream;

public class ParserImpl
implements Parser {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    static final int LARGE_TOKEN_SIZE = 128;
    protected Object cachedParser;
    protected Object cachedTokenManager;
    protected CharStream charStream;
    protected String SQLtext;
    protected final CompilerContext cc;

    public QueryTreeNode parseStatement(String string) throws StandardException {
        return this.parseStatement(string, null);
    }

    protected Object getTokenManager() {
        SQLParserTokenManager sQLParserTokenManager = (SQLParserTokenManager)this.cachedTokenManager;
        if (sQLParserTokenManager == null) {
            sQLParserTokenManager = new SQLParserTokenManager(this.charStream);
            this.cachedTokenManager = sQLParserTokenManager;
        } else {
            sQLParserTokenManager.ReInit(this.charStream);
        }
        return sQLParserTokenManager;
    }

    protected Object getParser() {
        SQLParserTokenManager sQLParserTokenManager = (SQLParserTokenManager)this.getTokenManager();
        SQLParser sQLParser = (SQLParser)this.cachedParser;
        if (sQLParser == null) {
            sQLParser = new SQLParser(sQLParserTokenManager);
            sQLParser.setCompilerContext(this.cc);
            this.cachedParser = sQLParser;
        } else {
            sQLParser.ReInit(sQLParserTokenManager);
        }
        return sQLParser;
    }

    public QueryTreeNode parseStatement(String string, Object[] objectArray) throws StandardException {
        StringReader stringReader = new StringReader(string);
        if (this.charStream == null) {
            this.charStream = new UCode_CharStream(stringReader, 1, 1, 128);
        } else {
            this.charStream.ReInit(stringReader, 1, 1, 128);
        }
        this.SQLtext = string;
        try {
            return this.parseGoalProduction(string, objectArray);
        }
        catch (ParseException parseException) {
            throw StandardException.newException("42X01", parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw StandardException.newException("42X02", tokenMgrError.getMessage());
        }
    }

    protected QueryTreeNode parseGoalProduction(String string, Object[] objectArray) throws ParseException, TokenMgrError, StandardException {
        SQLParser sQLParser = (SQLParser)this.getParser();
        return sQLParser.Statement(string, objectArray);
    }

    public String getSQLtext() {
        return this.SQLtext;
    }

    public ParserImpl(CompilerContext compilerContext) {
        this.cc = compilerContext;
    }
}

