/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.depend;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Parser;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionFactory;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.depend.Dependency;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.depend.ProviderList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DataDictionaryContext;
import org.apache.derby.iapi.sql.dictionary.DependencyDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.ViewDescriptor;
import org.apache.derby.impl.sql.compile.CreateViewNode;
import org.apache.derby.impl.sql.depend.BasicDependency;
import org.apache.derby.impl.sql.depend.BasicProviderInfo;

public class BasicDependencyManager
implements DependencyManager {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private static final ProviderInfo[] EMPTY_PROVIDER_INFO = new ProviderInfo[0];
    private DataDictionary dataDictionary = null;
    protected Hashtable dependents = new Hashtable();
    protected Hashtable providers = new Hashtable();

    public void addDependency(Dependent dependent, Provider provider, ContextManager contextManager) throws StandardException {
        BasicDependencyManager basicDependencyManager = this;
        synchronized (basicDependencyManager) {
            BasicDependency basicDependency = new BasicDependency(dependent, provider);
            if (!dependent.isPersistent() || !provider.isPersistent()) {
                boolean bl = false;
                boolean bl2 = false;
                bl = this.addDependencyToTable(this.dependents, dependent.getObjectID(), basicDependency);
                if (bl) {
                    bl2 = this.addDependencyToTable(this.providers, provider.getObjectID(), basicDependency);
                }
                StatementContext statementContext = (StatementContext)contextManager.getContext("StatementContext");
                statementContext.addDependency(basicDependency);
            } else {
                LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext(contextManager);
                DataDictionary dataDictionary = this.getDataDictionary();
                DependencyDescriptor dependencyDescriptor = new DependencyDescriptor(dependent, provider);
                dataDictionary.addDescriptor(dependencyDescriptor, null, 6, true, languageConnectionContext.getTransactionExecute());
            }
        }
    }

    private void dropDependency(LanguageConnectionContext languageConnectionContext, Dependent dependent, Provider provider) throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        DependencyDescriptor dependencyDescriptor = new DependencyDescriptor(dependent, provider);
        dataDictionary.dropStoredDependency(dependencyDescriptor, languageConnectionContext.getTransactionExecute());
    }

    public void invalidateFor(Provider provider, int n, LanguageConnectionContext languageConnectionContext) throws StandardException {
        if (provider.isPersistent()) {
            this.coreInvalidateFor(provider, n, languageConnectionContext);
        } else {
            BasicDependencyManager basicDependencyManager = this;
            synchronized (basicDependencyManager) {
                this.coreInvalidateFor(provider, n, languageConnectionContext);
            }
        }
    }

    private void coreInvalidateFor(Provider provider, int n, LanguageConnectionContext languageConnectionContext) throws StandardException {
        List list = this.getDependents(provider);
        if (list == null) {
            return;
        }
        FormatableBitSet formatableBitSet = null;
        FormatableBitSet formatableBitSet2 = null;
        if (provider instanceof TableDescriptor && (formatableBitSet = ((TableDescriptor)provider).getReferencedColumnMap()) != null) {
            formatableBitSet2 = new FormatableBitSet(formatableBitSet.getLength());
        }
        StandardException standardException = null;
        int n2 = list.size() - 1;
        while (n2 >= 0) {
            block16: {
                Dependent dependent;
                block17: {
                    FormatableBitSet formatableBitSet3;
                    block18: {
                        block19: {
                            if (n2 >= list.size()) break block16;
                            Dependency dependency = (Dependency)list.get(n2);
                            dependent = dependency.getDependent();
                            if (formatableBitSet == null) break block17;
                            TableDescriptor tableDescriptor = (TableDescriptor)dependency.getProvider();
                            formatableBitSet3 = tableDescriptor.getReferencedColumnMap();
                            if (formatableBitSet3 != null) break block18;
                            if (!(dependent instanceof ViewDescriptor)) break block19;
                            ViewDescriptor viewDescriptor = (ViewDescriptor)dependent;
                            DataDictionary dataDictionary = this.getDataDictionary();
                            SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(viewDescriptor.getCompSchemaId(), null);
                            CompilerContext compilerContext = languageConnectionContext.pushCompilerContext(schemaDescriptor);
                            Parser parser = compilerContext.getParser();
                            LanguageConnectionFactory languageConnectionFactory = languageConnectionContext.getLanguageConnectionFactory();
                            CreateViewNode createViewNode = (CreateViewNode)parser.parseStatement(viewDescriptor.getViewText());
                            compilerContext.setCurrentDependent(dependent);
                            createViewNode = (CreateViewNode)createViewNode.bind();
                            ProviderInfo[] providerInfoArray = createViewNode.getProviderInfo();
                            languageConnectionContext.popCompilerContext(compilerContext);
                            boolean bl = false;
                            int n3 = 0;
                            while (n3 < providerInfoArray.length) {
                                TableDescriptor tableDescriptor2;
                                FormatableBitSet formatableBitSet4;
                                Provider provider2 = null;
                                try {
                                    provider2 = (Provider)providerInfoArray[n3].getDependableFinder().getDependable(providerInfoArray[n3].getObjectId());
                                }
                                catch (SQLException sQLException) {
                                    // empty catch block
                                }
                                if (provider2 instanceof TableDescriptor && (formatableBitSet4 = (tableDescriptor2 = (TableDescriptor)provider2).getReferencedColumnMap()) != null) {
                                    tableDescriptor2.setReferencedColumnMap(null);
                                    this.dropDependency(languageConnectionContext, viewDescriptor, tableDescriptor2);
                                    tableDescriptor2.setReferencedColumnMap(formatableBitSet4);
                                    this.addDependency(viewDescriptor, tableDescriptor2, languageConnectionContext.getContextManager());
                                    if (tableDescriptor2.getObjectID().equals(tableDescriptor.getObjectID())) {
                                        System.arraycopy(formatableBitSet.getByteArray(), 0, formatableBitSet2.getByteArray(), 0, formatableBitSet.getLengthInBytes());
                                        formatableBitSet2.and(formatableBitSet4);
                                        if (formatableBitSet2.anySetBit() != -1) {
                                            bl = true;
                                            ((TableDescriptor)provider).setReferencedColumnMap(formatableBitSet2);
                                        }
                                    }
                                }
                                ++n3;
                            }
                            if (bl) break block17;
                            break block16;
                        }
                        ((TableDescriptor)provider).setReferencedColumnMap(null);
                        break block17;
                    }
                    System.arraycopy(formatableBitSet.getByteArray(), 0, formatableBitSet2.getByteArray(), 0, formatableBitSet.getLengthInBytes());
                    formatableBitSet2.and(formatableBitSet3);
                    if (formatableBitSet2.anySetBit() == -1) break block16;
                    ((TableDescriptor)provider).setReferencedColumnMap(formatableBitSet2);
                }
                try {
                    dependent.prepareToInvalidate(provider, n, languageConnectionContext);
                }
                catch (StandardException standardException2) {
                    if (standardException != null) {
                        standardException2.setNestedException(standardException);
                    }
                    standardException = standardException2;
                }
                if (standardException == null) {
                    if (formatableBitSet != null) {
                        ((TableDescriptor)provider).setReferencedColumnMap(formatableBitSet);
                    }
                    dependent.makeInvalid(n, languageConnectionContext);
                }
            }
            --n2;
        }
        if (standardException != null) {
            throw standardException;
        }
    }

    public void clearDependencies(LanguageConnectionContext languageConnectionContext, Dependent dependent) throws StandardException {
        List list = (List)this.dependents.get(dependent.getObjectID());
        BasicDependencyManager basicDependencyManager = this;
        synchronized (basicDependencyManager) {
            Object object;
            if (dependent.isPersistent()) {
                object = this.getDataDictionary();
                object.dropDependentsStoredDependencies(dependent.getObjectID(), languageConnectionContext.getTransactionExecute());
            }
            if (list == null) {
                Object var5_6 = null;
                return;
            }
            object = list.listIterator();
            while (object.hasNext()) {
                Dependency dependency = (Dependency)object.next();
                this.clearProviderDependency(dependency.getProviderKey(), dependency);
            }
            this.dependents.remove(dependent.getObjectID());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clearInMemoryDependency(Dependency dependency) {
        BasicDependencyManager basicDependencyManager = this;
        synchronized (basicDependencyManager) {
            List list = (List)this.dependents.get(dependency.getDependent().getObjectID());
            if (list == null) {
                return;
            }
            List list2 = (List)this.providers.get(dependency.getProvider().getObjectID());
            if (list2 == null) return;
            list.remove(dependency);
            if (list.size() == 0) {
                this.dependents.remove(dependency.getDependent().getObjectID());
            }
            list2.remove(dependency);
            if (list2.size() != 0) return;
            this.providers.remove(dependency.getProvider().getObjectID());
            return;
        }
    }

    public synchronized ProviderInfo[] getPersistentProviderInfos(Dependent dependent) throws StandardException {
        List list = this.getProviders(dependent);
        if (list == null) {
            return EMPTY_PROVIDER_INFO;
        }
        ArrayList<BasicProviderInfo> arrayList = new ArrayList<BasicProviderInfo>();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Dependency dependency = (Dependency)listIterator.next();
            if (!dependency.getProvider().isPersistent()) continue;
            arrayList.add(new BasicProviderInfo(dependency.getProvider().getObjectID(), dependency.getProvider().getDependableFinder(), dependency.getProvider().getObjectName()));
        }
        return arrayList.toArray(EMPTY_PROVIDER_INFO);
    }

    public ProviderInfo[] getPersistentProviderInfos(ProviderList providerList) throws StandardException {
        Enumeration enumeration = providerList.elements();
        int n = 0;
        while (enumeration != null && enumeration.hasMoreElements()) {
            Provider provider = (Provider)enumeration.nextElement();
            if (!provider.isPersistent()) continue;
            ++n;
        }
        enumeration = providerList.elements();
        ProviderInfo[] providerInfoArray = new ProviderInfo[n];
        int n2 = 0;
        while (enumeration != null && enumeration.hasMoreElements()) {
            Provider provider = (Provider)enumeration.nextElement();
            if (!provider.isPersistent()) continue;
            providerInfoArray[n2++] = new BasicProviderInfo(provider.getObjectID(), provider.getDependableFinder(), provider.getObjectName());
        }
        return providerInfoArray;
    }

    public void clearColumnInfoInProviders(ProviderList providerList) throws StandardException {
        Enumeration enumeration = providerList.elements();
        while (enumeration != null && enumeration.hasMoreElements()) {
            Provider provider = (Provider)enumeration.nextElement();
            if (!(provider instanceof TableDescriptor)) continue;
            ((TableDescriptor)provider).setReferencedColumnMap(null);
        }
    }

    public synchronized void copyDependencies(Dependent dependent, Dependent dependent2, boolean bl, ContextManager contextManager) throws StandardException {
        List list = this.getProviders(dependent);
        if (list == null) {
            return;
        }
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Provider provider = ((Dependency)listIterator.next()).getProvider();
            if (bl && !provider.isPersistent()) continue;
            this.addDependency(dependent2, provider, contextManager);
        }
    }

    public String getActionString(int n) {
        switch (n) {
            case 12: {
                return "ALTER TABLE";
            }
            case 34: {
                return "RENAME";
            }
            case 41: {
                return "RENAME INDEX";
            }
            case 0: {
                return "COMPILE FAILED";
            }
            case 1: {
                return "DROP TABLE";
            }
            case 2: {
                return "DROP INDEX";
            }
            case 9: {
                return "DROP VIEW";
            }
            case 3: {
                return "CREATE INDEX";
            }
            case 4: {
                return "ROLLBACK";
            }
            case 5: {
                return "CHANGED CURSOR";
            }
            case 22: {
                return "CREATE CONSTRAINT";
            }
            case 19: {
                return "DROP CONSTRAINT";
            }
            case 6: {
                return "DROP ROUTINE";
            }
            case 11: {
                return "PREPARED STATEMENT RELEASE";
            }
            case 13: {
                return "DROP STORED PREPARED STATEMENT";
            }
            case 14: {
                return "USER REQUESTED INVALIDATION";
            }
            case 15: {
                return "BULK INSERT";
            }
            case 10: {
                return "CREATE_VIEW";
            }
            case 17: {
                return "DROP_JAR";
            }
            case 18: {
                return "REPLACE_JAR";
            }
            case 20: {
                return "SET_CONSTRAINTS_ENABLE";
            }
            case 21: {
                return "SET_CONSTRAINTS_DISABLE";
            }
            case 23: {
                return "INTERNAL RECOMPILE REQUEST";
            }
            case 28: {
                return "CREATE TRIGGER";
            }
            case 27: {
                return "DROP TRIGGER";
            }
            case 29: {
                return "SET TRIGGERS ENABLED";
            }
            case 30: {
                return "SET TRIGGERS DISABLED";
            }
            case 31: {
                return "MODIFY COLUMN DEFAULT";
            }
            case 33: {
                return "COMPRESS TABLE";
            }
            case 35: {
                return "DROP TABLE CASCADE";
            }
            case 36: {
                return "DROP VIEW CASCADE";
            }
            case 37: {
                return "DROP COLUMN";
            }
            case 38: {
                return "DROP COLUMN CASCADE";
            }
            case 39: {
                return "DROP STATISTICS";
            }
            case 40: {
                return "UPDATE STATISTICS";
            }
            case 42: {
                return "TRUNCATE TABLE";
            }
        }
        return "UNKNOWN";
    }

    public int countDependencies() throws StandardException {
        BasicDependencyManager basicDependencyManager = this;
        synchronized (basicDependencyManager) {
            int n = 0;
            Enumeration enumeration = this.dependents.elements();
            Enumeration enumeration2 = this.providers.elements();
            List list = this.getDataDictionary().getAllDependencyDescriptorsList();
            while (enumeration.hasMoreElements()) {
                n += ((List)enumeration.nextElement()).size();
            }
            while (enumeration2.hasMoreElements()) {
                n += ((List)enumeration2.nextElement()).size();
            }
            int n2 = n += list.size();
            Object var2_7 = null;
            return n2;
        }
    }

    public String dumpDependencies() throws StandardException, SQLException {
        BasicDependencyManager basicDependencyManager = this;
        synchronized (basicDependencyManager) {
            boolean bl = false;
            boolean bl2 = false;
            StringBuffer stringBuffer = new StringBuffer();
            String string = stringBuffer.toString();
            Object var2_6 = null;
            return string;
        }
    }

    private boolean addDependencyToTable(Hashtable hashtable, Object object, Dependency dependency) {
        List list = (List)hashtable.get(object);
        if (list == null) {
            list = BasicDependencyManager.newSList();
            list.add(dependency);
            hashtable.put(object, list);
        } else {
            UUID uUID = dependency.getProvider().getObjectID();
            UUID uUID2 = dependency.getDependent().getObjectID();
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                Dependency dependency2 = (Dependency)listIterator.next();
                if (!dependency2.getProvider().getObjectID().equals(uUID) || !dependency2.getDependent().getObjectID().equals(uUID2)) continue;
                return false;
            }
            list.add(dependency);
        }
        return true;
    }

    protected void clearProviderDependency(UUID uUID, Dependency dependency) {
        List list = (List)this.providers.get(uUID);
        if (list == null) {
            return;
        }
        list.remove(dependency);
        if (list.size() == 0) {
            this.providers.remove(uUID);
        }
    }

    private List getDependencyDescriptorList(List list) throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        if (list.size() != 0) {
            ListIterator<BasicDependency> listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                Provider provider;
                Dependent dependent;
                DependableFinder dependableFinder = null;
                DependencyDescriptor dependencyDescriptor = (DependencyDescriptor)listIterator.next();
                try {
                    dependableFinder = dependencyDescriptor.getDependentFinder();
                    dependent = (Dependent)dependableFinder.getDependable(dependencyDescriptor.getUUID());
                    dependableFinder = dependencyDescriptor.getProviderFinder();
                    provider = (Provider)dependableFinder.getDependable(dependencyDescriptor.getProviderID());
                }
                catch (SQLException sQLException) {
                    throw StandardException.newException("XD003.S", dependableFinder.getClass().getName(), (Object)sQLException.getMessage());
                }
                listIterator.set(new BasicDependency(dependent, provider));
            }
        }
        return list;
    }

    private DataDictionary getDataDictionary() {
        if (this.dataDictionary == null) {
            DataDictionaryContext dataDictionaryContext = (DataDictionaryContext)ContextService.getContext("DataDictionaryContext");
            this.dataDictionary = dataDictionaryContext.getDataDictionary();
        }
        return this.dataDictionary;
    }

    private LanguageConnectionContext getLanguageConnectionContext() {
        return (LanguageConnectionContext)ContextService.getContext("LanguageConnectionContext");
    }

    private LanguageConnectionContext getLanguageConnectionContext(ContextManager contextManager) {
        return (LanguageConnectionContext)contextManager.getContext("LanguageConnectionContext");
    }

    private void bubbleSort(UUID[] uUIDArray) {
    }

    protected List getProviders(Dependent dependent) throws StandardException {
        List list = (List)this.dependents.get(dependent.getObjectID());
        if (!dependent.isPersistent()) {
            return list == null ? null : list;
        }
        list = list == null ? BasicDependencyManager.newSList() : BasicDependencyManager.newSList(list);
        List list2 = this.getDependencyDescriptorList(this.getDataDictionary().getDependentsDescriptorList(dependent.getObjectID().toString()));
        if (list2.size() > 0) {
            list.addAll(0, list2);
        }
        return list;
    }

    protected List getDependents(Provider provider) throws StandardException {
        List list = (List)this.providers.get(provider.getObjectID());
        if (!provider.isPersistent()) {
            return list == null ? null : list;
        }
        list = list == null ? BasicDependencyManager.newSList() : BasicDependencyManager.newSList(list);
        List list2 = this.getDependencyDescriptorList(this.getDataDictionary().getProvidersDescriptorList(provider.getObjectID().toString()));
        if (list2.size() > 0) {
            list.addAll(0, list2);
        }
        return list;
    }

    private static List newSList() {
        return Collections.synchronizedList(new LinkedList());
    }

    private static List newSList(List list) {
        return Collections.synchronizedList(new LinkedList(list));
    }
}

