/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.CreateSchemaConstantAction;
import org.apache.derby.impl.sql.execute.GenericConstantAction;

public abstract class DDLConstantAction
extends GenericConstantAction {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1998, 2004.";

    static SchemaDescriptor getAndCheckSchemaDescriptor(DataDictionary dataDictionary, UUID uUID, String string) throws StandardException {
        SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(uUID, null);
        return schemaDescriptor;
    }

    static SchemaDescriptor getSchemaDescriptorForCreate(DataDictionary dataDictionary, Activation activation, String string) throws StandardException {
        TransactionController transactionController = activation.getLanguageConnectionContext().getTransactionExecute();
        SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(string, transactionController, false);
        if (schemaDescriptor == null || schemaDescriptor.getUUID() == null) {
            CreateSchemaConstantAction createSchemaConstantAction = new CreateSchemaConstantAction(string, null);
            createSchemaConstantAction.executeConstantAction(activation);
            schemaDescriptor = dataDictionary.getSchemaDescriptor(string, transactionController, true);
        }
        return schemaDescriptor;
    }

    final void lockTableForDDL(TransactionController transactionController, long l, boolean bl) throws StandardException {
        ConglomerateController conglomerateController = transactionController.openConglomerate(l, false, bl ? 68 : 64, 7, 5);
        conglomerateController.close();
    }

    public boolean modifiesTableId(UUID uUID) throws StandardException {
        return false;
    }

    protected String constructToString(String string, String string2) {
        return string + string2;
    }

    public abstract void executeConstantAction(Activation var1) throws StandardException;
}

