/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;

public class ProjectRestrictResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    public long restrictionTime;
    public long projectionTime;
    public NoPutResultSet source;
    public GeneratedMethod constantRestriction;
    public GeneratedMethod restriction;
    public boolean doesProjection;
    private GeneratedMethod projection;
    private int[] projectMapping;
    private GeneratedMethod closeCleanup;
    private boolean runTimeStatsOn;
    private ExecRow mappedResultRow;
    public boolean reuseResult;
    private boolean shortCircuitOpen;
    private ExecRow projRow;

    public void openCore() throws StandardException {
        boolean bl = true;
        this.beginTime = this.getCurrentTimeMillis();
        if (this.constantRestriction != null) {
            DataValueDescriptor dataValueDescriptor = (DataValueDescriptor)this.constantRestriction.invoke(this.activation);
            boolean bl2 = bl = dataValueDescriptor == null || !dataValueDescriptor.isNull() && dataValueDescriptor.getBoolean();
        }
        if (bl) {
            this.source.openCore();
        } else {
            this.shortCircuitOpen = true;
        }
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public void reopenCore() throws StandardException {
        boolean bl = true;
        this.beginTime = this.getCurrentTimeMillis();
        if (this.constantRestriction != null) {
            DataValueDescriptor dataValueDescriptor = (DataValueDescriptor)this.constantRestriction.invoke(this.activation);
            boolean bl2 = bl = dataValueDescriptor == null || !dataValueDescriptor.isNull() && dataValueDescriptor.getBoolean();
        }
        if (bl) {
            this.source.reopenCore();
        } else {
            this.shortCircuitOpen = true;
        }
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public ExecRow getNextRowCore() throws StandardException {
        ExecRow execRow = null;
        ExecRow execRow2 = null;
        boolean bl = false;
        long l = 0L;
        if (this.shortCircuitOpen) {
            return execRow2;
        }
        this.beginTime = this.getCurrentTimeMillis();
        do {
            if ((execRow = this.source.getNextRowCore()) == null) continue;
            l = this.getCurrentTimeMillis();
            if (this.restriction == null) {
                bl = true;
            } else {
                this.setCurrentRow(execRow);
                DataValueDescriptor dataValueDescriptor = (DataValueDescriptor)this.restriction.invoke(this.activation);
                this.restrictionTime += this.getElapsedMillis(l);
                boolean bl2 = bl = !dataValueDescriptor.isNull() && dataValueDescriptor.getBoolean();
                if (!bl) {
                    ++this.rowsFiltered;
                }
            }
            ++this.rowsSeen;
        } while (execRow != null && !bl);
        if (execRow != null) {
            l = this.getCurrentTimeMillis();
            execRow2 = this.doProjection(execRow);
            this.projectionTime += this.getElapsedMillis(l);
        } else {
            this.clearCurrentRow();
        }
        this.currentRow = execRow2;
        if (this.runTimeStatsOn) {
            if (!this.isTopResultSet) {
                StatementContext statementContext = this.activation.getLanguageConnectionContext().getStatementContext();
                this.subqueryTrackingArray = statementContext.getSubqueryTrackingArray();
            }
            this.nextTime += this.getElapsedMillis(this.beginTime);
        }
        return execRow2;
    }

    public long getTimeSpent(int n) {
        long l = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n == 0) {
            return l - this.source.getTimeSpent(1);
        }
        return l;
    }

    public void close() throws StandardException {
        if (this.shortCircuitOpen) {
            this.isOpen = false;
            this.shortCircuitOpen = false;
            return;
        }
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            if (this.closeCleanup != null) {
                this.closeCleanup.invoke(this.activation);
            }
            this.currentRow = null;
            this.source.close();
            super.close();
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    public void finish() throws StandardException {
        this.source.finish();
        this.finishAndRTS();
    }

    public RowLocation getRowLocation() throws StandardException {
        return ((CursorResultSet)((Object)this.source)).getRowLocation();
    }

    public ExecRow getCurrentRow() throws StandardException {
        ExecRow execRow = null;
        ExecRow execRow2 = null;
        boolean bl = false;
        if (this.currentRow == null) {
            return null;
        }
        execRow = ((CursorResultSet)((Object)this.source)).getCurrentRow();
        if (execRow != null) {
            this.setCurrentRow(execRow);
            DataValueDescriptor dataValueDescriptor = (DataValueDescriptor)(this.restriction == null ? null : this.restriction.invoke(this.activation));
            boolean bl2 = bl = dataValueDescriptor == null || !dataValueDescriptor.isNull() && dataValueDescriptor.getBoolean();
        }
        if (execRow != null && bl) {
            execRow2 = this.doProjection(execRow);
        }
        this.currentRow = execRow2;
        if (execRow2 == null) {
            this.clearCurrentRow();
        }
        return this.currentRow;
    }

    private ExecRow doProjection(ExecRow execRow) throws StandardException {
        if (this.reuseResult && this.projRow != null) {
            return this.projRow;
        }
        ExecRow execRow2 = this.projection != null ? (ExecRow)this.projection.invoke(this.activation) : this.mappedResultRow;
        int n = 0;
        while (n < this.projectMapping.length) {
            if (this.projectMapping[n] != -1) {
                execRow2.setColumn(n + 1, execRow.getColumn(this.projectMapping[n]));
            }
            ++n;
        }
        this.setCurrentRow(execRow2);
        if (this.reuseResult) {
            this.projRow = execRow2;
        }
        return execRow2;
    }

    public boolean isForUpdate() {
        return this.source.isForUpdate();
    }

    public ProjectRestrictResultSet(NoPutResultSet noPutResultSet, Activation activation, GeneratedMethod generatedMethod, GeneratedMethod generatedMethod2, int n, GeneratedMethod generatedMethod3, int n2, boolean bl, boolean bl2, double d, double d2, GeneratedMethod generatedMethod4) throws StandardException {
        super(activation, n, d, d2);
        this.source = noPutResultSet;
        this.restriction = generatedMethod;
        this.projection = generatedMethod2;
        this.constantRestriction = generatedMethod3;
        this.projectMapping = ((ReferencedColumnsDescriptorImpl)activation.getPreparedStatement().getSavedObject(n2)).getReferencedColumnPositions();
        this.reuseResult = bl;
        this.doesProjection = bl2;
        this.closeCleanup = generatedMethod4;
        if (this.projection == null) {
            this.mappedResultRow = this.activation.getExecutionFactory().getValueRow(this.projectMapping.length);
        }
        this.runTimeStatsOn = this.getLanguageConnectionContext().getRunTimeStatisticsMode();
        this.constructorTime += this.getElapsedMillis(this.beginTime);
    }
}

