/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.sort;

import org.apache.derby.impl.store.access.sort.Node;

final class NodeAllocator {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private static final int DEFAULT_INIT_SIZE = 128;
    private static final int GROWTH_MULTIPLIER = 2;
    private static final int DEFAULT_MAX_SIZE = 1024;
    private Node[] array = null;
    private int maxSize = 0;
    private int nAllocated = 0;
    private Node freeList = null;

    public Node newNode() {
        if (this.array == null && !this.init()) {
            return null;
        }
        if (this.freeList != null) {
            Node node = this.freeList;
            this.freeList = node.rightLink;
            node.rightLink = null;
            return node;
        }
        if (this.nAllocated == this.array.length) {
            if (this.array.length >= this.maxSize) {
                return null;
            }
            Node[] nodeArray = new Node[this.array.length * 2];
            if (nodeArray == null) {
                return null;
            }
            System.arraycopy(this.array, 0, nodeArray, 0, this.array.length);
            this.array = nodeArray;
        }
        if (this.array[this.nAllocated] == null) {
            this.array[this.nAllocated] = new Node(this.nAllocated);
        }
        return this.array[this.nAllocated++];
    }

    public void freeNode(Node node) {
        node.reset();
        node.rightLink = this.freeList;
        this.freeList = node;
    }

    public boolean init() {
        return this.init(128, 1024);
    }

    public boolean init(int n) {
        return this.init(128, n);
    }

    public boolean init(int n, int n2) {
        this.maxSize = n2;
        if (n2 < n) {
            n = n2;
        }
        this.array = new Node[n];
        if (this.array == null) {
            return false;
        }
        this.nAllocated = 0;
        return true;
    }

    public void grow(int n) {
        if (n > 0) {
            this.maxSize = this.maxSize * (100 + n) / 100;
        }
    }

    public void reset() {
        if (this.array == null) {
            return;
        }
        int n = 0;
        while (n < this.nAllocated) {
            this.array[n].reset();
            ++n;
        }
        this.nAllocated = 0;
        this.freeList = null;
    }

    public void close() {
        this.array = null;
        this.nAllocated = 0;
        this.maxSize = 0;
        this.freeList = null;
    }

    public int capacity() {
        return this.maxSize;
    }
}

