/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.crypto.CipherFactory;
import org.apache.derby.iapi.services.crypto.CipherProvider;
import org.apache.derby.iapi.services.daemon.DaemonFactory;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.monitor.PersistentService;
import org.apache.derby.iapi.services.property.PersistentSet;
import org.apache.derby.iapi.store.access.DatabaseInstant;
import org.apache.derby.iapi.store.access.TransactionInfo;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.ScanHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.iapi.store.raw.log.LogFactory;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.TransactionFactory;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.services.monitor.UpdateServiceProperties;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.WritableStorageFactory;

public class RawStore
implements RawStoreFactory,
ModuleControl,
ModuleSupportable,
PrivilegedExceptionAction {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private static final String BACKUP_HISTORY = "BACKUP.HISTORY";
    private static final String[] BACKUP_FILTER = new String[]{"tmp", "db.lck", "dbex.lck", "log"};
    private static final int FILE_WRITER_ACTION = 1;
    private static final int REGULAR_FILE_EXISTS_ACTION = 2;
    private static final int STORAGE_FILE_EXISTS_ACTION = 3;
    private static final int REGULAR_FILE_DELETE_ACTION = 4;
    private static final int REGULAR_FILE_MKDIRS_ACTION = 5;
    private static final int REGULAR_FILE_IS_DIRECTORY_ACTION = 6;
    private static final int REGULAR_FILE_REMOVE_DIRECTORY_ACTION = 7;
    private static final int REGULAR_FILE_RENAME_TO_ACTION = 8;
    private static final int COPY_STORAGE_DIRECTORY_TO_REGULAR_ACTION = 9;
    private static final int COPY_REGULAR_DIRECTORY_TO_STORAGE_ACTION = 10;
    private static final int COPY_REGULAR_FILE_TO_STORAGE_ACTION = 11;
    private static final int REGULAR_FILE_LIST_DIRECTORY_ACTION = 12;
    protected TransactionFactory xactFactory;
    protected DataFactory dataFactory;
    protected LogFactory logFactory;
    private StorageFactory storageFactory;
    private SecureRandom random;
    private boolean databaseEncrypted;
    private CipherProvider encryptionEngine;
    private CipherProvider decryptionEngine;
    private CipherFactory cipherFactory;
    private int counter_encrypt;
    private int counter_decrypt;
    private int encryptionBlockSize = 8;
    String dataDirectory;
    protected DaemonService rawStoreDaemon;
    private int actionCode;
    private StorageFile actionStorageFile;
    private boolean actionAppend;
    private File actionRegularFile;
    private File actionRegularFile2;
    private byte[] actionBuffer;
    private String[] actionFilter;

    public boolean canSupport(Properties properties) {
        return true;
    }

    public void boot(boolean bl, Properties properties) throws StandardException {
        String string;
        String string2;
        this.dataDirectory = properties.getProperty("derby.__rt.serviceDirectory");
        DaemonFactory daemonFactory = (DaemonFactory)Monitor.startSystemModule("org.apache.derby.iapi.services.daemon.DaemonFactory");
        this.rawStoreDaemon = daemonFactory.createNewDaemon("rawStoreDaemon");
        this.xactFactory = (TransactionFactory)Monitor.bootServiceModule(bl, this, this.getTransactionFactoryModule(), properties);
        this.dataFactory = (DataFactory)Monitor.bootServiceModule(bl, this, this.getDataFactoryModule(), properties);
        this.storageFactory = this.dataFactory.getStorageFactory();
        if (properties != null) {
            string2 = properties.getProperty("dataEncryption");
            this.databaseEncrypted = Boolean.valueOf(string2);
            if (this.databaseEncrypted) {
                this.cipherFactory = (CipherFactory)Monitor.bootServiceModule(bl, this, "org.apache.derby.iapi.services.crypto.CipherFactory", properties);
                this.cipherFactory.verifyKey(bl, this.storageFactory, properties);
                this.encryptionEngine = this.cipherFactory.createNewCipher(1);
                if (bl) {
                    this.encryptionBlockSize = this.encryptionEngine.getEncryptionBlockSize();
                    ((Hashtable)properties).put("derby.encryptionBlockSize", String.valueOf(this.encryptionBlockSize));
                } else if (properties.getProperty("derby.encryptionBlockSize") != null) {
                    this.encryptionBlockSize = Integer.parseInt(properties.getProperty("derby.encryptionBlockSize"));
                }
                this.decryptionEngine = this.cipherFactory.createNewCipher(2);
                this.random = this.cipherFactory.getSecureRandom();
            }
        }
        this.dataFactory.setRawStoreFactory(this, bl, properties);
        this.xactFactory.setRawStoreFactory(this);
        if (properties instanceof UpdateServiceProperties && this.storageFactory instanceof WritableStorageFactory) {
            ((UpdateServiceProperties)properties).setStorageFactory((WritableStorageFactory)this.storageFactory);
        }
        this.logFactory = (LogFactory)Monitor.findServiceModule(this, this.getLogFactoryModule());
        string2 = null;
        string2 = properties.getProperty("createFrom");
        if (string2 == null) {
            string2 = properties.getProperty("restoreFrom");
        }
        if (string2 == null) {
            string2 = properties.getProperty("rollForwardRecoveryFrom");
        }
        if (string2 != null) {
            this.restoreRemainingFromBackup(string2);
            ((UpdateServiceProperties)properties).saveServiceProperties();
        }
        if ((string = properties.getProperty("logDevice")) != null) {
            if (bl || !string.equals(this.logFactory.getCanonicalLogPath()) || string2 != null) {
                ((Hashtable)properties).put("logDevice", this.logFactory.getCanonicalLogPath());
                ((Hashtable)properties).put("derby.storage.logDeviceWhenBackedUp", this.logFactory.getCanonicalLogPath());
            }
        } else if (string2 != null && this.logFactory.getCanonicalLogPath() != null) {
            ((Hashtable)properties).put("logDevice", this.logFactory.getCanonicalLogPath());
        } else {
            ((Hashtable)properties).remove("derby.storage.logDeviceWhenBackedUp");
        }
        if (string2 != null) {
            this.restoreRemainingFromBackup(string2);
            ((UpdateServiceProperties)properties).saveServiceProperties();
        }
        this.logFactory.recover(this, this.dataFactory, this.xactFactory);
    }

    public void stop() {
        if (this.rawStoreDaemon != null) {
            this.rawStoreDaemon.stop();
        }
        if (this.logFactory == null) {
            return;
        }
        try {
            if (this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, false) && this.dataFactory != null) {
                this.dataFactory.removeStubsOK();
            }
        }
        catch (StandardException standardException) {
            this.markCorrupt(standardException);
        }
    }

    public boolean isReadOnly() {
        return this.dataFactory.isReadOnly();
    }

    public LockFactory getLockFactory() {
        return this.xactFactory.getLockFactory();
    }

    public Object getXAResourceManager() throws StandardException {
        return this.xactFactory.getXAResourceManager();
    }

    public Transaction startGlobalTransaction(ContextManager contextManager, int n, byte[] byArray, byte[] byArray2) throws StandardException {
        return this.xactFactory.startGlobalTransaction(this, contextManager, n, byArray, byArray2);
    }

    public Transaction startTransaction(ContextManager contextManager, String string) throws StandardException {
        return this.xactFactory.startTransaction(this, contextManager, string);
    }

    public Transaction startNestedReadOnlyUserTransaction(Object object, ContextManager contextManager, String string) throws StandardException {
        return this.xactFactory.startNestedReadOnlyUserTransaction(this, object, contextManager, string);
    }

    public Transaction startNestedUpdateUserTransaction(ContextManager contextManager, String string) throws StandardException {
        return this.xactFactory.startNestedUpdateUserTransaction(this, contextManager, string);
    }

    public Transaction findUserTransaction(ContextManager contextManager, String string) throws StandardException {
        return this.xactFactory.findUserTransaction(this, contextManager, string);
    }

    public Transaction startInternalTransaction(ContextManager contextManager) throws StandardException {
        return this.xactFactory.startInternalTransaction(this, contextManager);
    }

    public void checkpoint() throws StandardException {
        this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, false);
    }

    public void freeze() throws StandardException {
        this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, true);
        this.dataFactory.freezePersistentStore();
        this.logFactory.freezePersistentStore();
    }

    public void unfreeze() throws StandardException {
        this.logFactory.unfreezePersistentStore();
        this.dataFactory.unfreezePersistentStore();
    }

    public void backup(String string) throws StandardException {
        if (string == null || string.equals("")) {
            throw StandardException.newException("XSRS6.S", null);
        }
        String string2 = null;
        try {
            URL uRL = new URL(string);
            string2 = uRL.getFile();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (string2 != null) {
            string = string2;
        }
        this.backup(new File(string));
    }

    /*
     * Loose catch block
     */
    public synchronized void backup(File file) throws StandardException {
        Object object;
        if (!this.privExists(file)) {
            if (!this.privMkdirs(file)) {
                throw StandardException.newException("XSRS6.S", file);
            }
        } else if (!this.privIsDirectory(file)) {
            throw StandardException.newException("XSRS1.S", file);
        }
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        File file2 = null;
        File file3 = null;
        OutputStreamWriter outputStreamWriter = null;
        LogInstant logInstant = this.logFactory.getFirstUnflushedInstant();
        Object object22222 = this.storageFactory.newStorageFile(null);
        Object object32222 = this.storageFactory.getCanonicalName();
        int n = ((String)object32222).lastIndexOf(this.storageFactory.getSeparator());
        String string = ((String)object32222).substring(n + 1);
        outputStreamWriter = this.privFileWriter(this.storageFactory.newStorageFile(BACKUP_HISTORY), true);
        this.logHistory(outputStreamWriter, MessageService.getTextMessage("D004", object32222));
        file3 = new File(file, string);
        if (this.privExists(file3)) {
            file2 = new File(file, string + ".OLD");
            if (this.privExists(file2)) {
                if (this.privIsDirectory(file2)) {
                    this.privRemoveDirectory(file2);
                } else {
                    this.privDelete(file2);
                }
            }
            if (!this.privRenameTo(file3, file2)) {
                bl3 = true;
                throw StandardException.newException("XSRS4.S", file3, (Object)file2, null);
            }
            this.logHistory(outputStreamWriter, MessageService.getTextMessage("D005", file3.getCanonicalPath(), file2.getCanonicalPath()));
            bl2 = true;
        }
        this.freeze();
        if (!this.privCopyDirectory((StorageFile)object22222, file3, null, BACKUP_FILTER)) {
            throw StandardException.newException("XSRS5.S", object22222, (Object)file3, null);
        }
        this.logHistory(outputStreamWriter, MessageService.getTextMessage("D006", object32222, file3.getCanonicalPath()));
        StorageFile storageFile = this.logFactory.getLogDirectory();
        StorageFile storageFile2 = this.storageFactory.newStorageFile("log");
        if (!storageFile.equals(storageFile2)) {
            try {
                object = Monitor.getMonitor().getServiceName(this);
                PersistentService persistentService = Monitor.getMonitor().getServiceType(this);
                String string2 = persistentService.getCanonicalServiceName((String)object);
                Properties properties = persistentService.getServiceProperties(string2, null);
                ((Hashtable)properties).remove("logDevice");
                persistentService.saveServiceProperties(file3.getCanonicalPath(), properties, true);
                this.logHistory(outputStreamWriter, MessageService.getTextMessage("D007"));
            }
            catch (StandardException standardException) {
                this.logHistory(outputStreamWriter, MessageService.getTextMessage("D008") + standardException);
                Object var10_23 = null;
                this.unfreeze();
                try {
                    if (bl) {
                        if (!bl3) {
                            this.privRemoveDirectory(file3);
                        }
                        if (bl2) {
                            this.privRenameTo(file2, file3);
                        }
                        this.logHistory(outputStreamWriter, MessageService.getTextMessage("D010"));
                    } else {
                        if (bl2 && this.privExists(file2)) {
                            this.privRemoveDirectory(file2);
                            this.logHistory(outputStreamWriter, MessageService.getTextMessage("D011", file2.getCanonicalPath()));
                        }
                        this.logHistory(outputStreamWriter, MessageService.getTextMessage("D012", logInstant));
                    }
                    outputStreamWriter.close();
                }
                catch (IOException object22222) {
                    try {
                        outputStreamWriter.close();
                    }
                    catch (IOException object32222) {
                        // empty catch block
                    }
                    throw StandardException.newException("XSRS7.S", (Throwable)object22222);
                }
                return;
            }
        }
        if (this.privExists((File)(object = new File(file3, "log")))) {
            this.privRemoveDirectory((File)object);
        }
        if (!this.privMkdirs((File)object)) {
            throw StandardException.newException("XSRS6.S", object);
        }
        if (!this.logFactory.copyActiveLogFiles((File)object)) {
            throw StandardException.newException("XSRS5.S", storageFile, object, null);
        }
        this.logHistory(outputStreamWriter, MessageService.getTextMessage("D009", storageFile.getCanonicalPath(), ((File)object).getCanonicalPath()));
        bl = false;
        Object var10_24 = null;
        this.unfreeze();
        try {
            if (bl) {
                if (!bl3) {
                    this.privRemoveDirectory(file3);
                }
                if (bl2) {
                    this.privRenameTo(file2, file3);
                }
                this.logHistory(outputStreamWriter, MessageService.getTextMessage("D010"));
            } else {
                if (bl2 && this.privExists(file2)) {
                    this.privRemoveDirectory(file2);
                    this.logHistory(outputStreamWriter, MessageService.getTextMessage("D011", file2.getCanonicalPath()));
                }
                this.logHistory(outputStreamWriter, MessageService.getTextMessage("D012", logInstant));
            }
            outputStreamWriter.close();
        }
        catch (IOException object22222) {
            try {
                outputStreamWriter.close();
            }
            catch (IOException object32222) {
                // empty catch block
            }
            throw StandardException.newException("XSRS7.S", (Throwable)object22222);
        }
        {
            catch (IOException iOException) {
                throw StandardException.newException("XSRS7.S", iOException);
            }
        }
        catch (Throwable throwable) {
            Object var10_25 = null;
            this.unfreeze();
            try {
                if (bl) {
                    if (!bl3) {
                        this.privRemoveDirectory(file3);
                    }
                    if (bl2) {
                        this.privRenameTo(file2, file3);
                    }
                    this.logHistory(outputStreamWriter, MessageService.getTextMessage("D010"));
                } else {
                    if (bl2 && this.privExists(file2)) {
                        this.privRemoveDirectory(file2);
                        this.logHistory(outputStreamWriter, MessageService.getTextMessage("D011", file2.getCanonicalPath()));
                    }
                    this.logHistory(outputStreamWriter, MessageService.getTextMessage("D012", logInstant));
                }
                outputStreamWriter.close();
            }
            catch (IOException iOException) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                throw StandardException.newException("XSRS7.S", iOException);
            }
            throw throwable;
        }
    }

    public void backupAndEnableLogArchiveMode(String string, boolean bl) throws StandardException {
        this.enableLogArchiveMode();
        this.backup(string);
        if (bl) {
            this.logFactory.deleteOnlineArchivedLogFiles();
        }
    }

    public void backupAndEnableLogArchiveMode(File file, boolean bl) throws StandardException {
        this.enableLogArchiveMode();
        this.backup(file);
        if (bl) {
            this.logFactory.deleteOnlineArchivedLogFiles();
        }
    }

    private void enableLogArchiveMode() throws StandardException {
        this.logFactory.enableLogArchiveMode();
    }

    public void disableLogArchiveMode(boolean bl) throws StandardException {
        this.logFactory.disableLogArchiveMode();
        if (bl) {
            this.logFactory.deleteOnlineArchivedLogFiles();
        }
    }

    private void restoreRemainingFromBackup(String string) throws StandardException {
        File file = new File(string);
        String[] stringArray = this.privList(file);
        int n = 0;
        while (n < stringArray.length) {
            File file2;
            StorageFile storageFile = this.storageFactory.newStorageFile(stringArray[n]);
            if (!this.privExists(storageFile) && !stringArray[n].equals("service.properties") && (this.privIsDirectory(file2 = new File(file, stringArray[n])) ? !this.privCopyDirectory(file2, storageFile) : !this.privCopyFile(file2, storageFile))) {
                throw StandardException.newException("XBM0Z.D", file2, (Object)storageFile);
            }
            ++n;
        }
    }

    public void idle() throws StandardException {
        this.dataFactory.idle();
    }

    public TransactionInfo[] getTransactionInfo() {
        return this.xactFactory.getTransactionInfo();
    }

    public LogInstant setTruncationLWM(UUID uUID, DatabaseInstant databaseInstant) throws StandardException {
        return this.logFactory.setTruncationLWM(uUID, (LogInstant)databaseInstant, this, this.xactFactory);
    }

    public LogInstant getTruncationLWM(UUID uUID) throws StandardException {
        return this.logFactory.getTruncationLWM(uUID);
    }

    public void removeTruncationLWM(UUID uUID) throws StandardException {
        this.logFactory.removeTruncationLWM(uUID, this, this.xactFactory);
    }

    public ScanHandle openFlushedScan(DatabaseInstant databaseInstant, int n) throws StandardException {
        return this.logFactory.openFlushedScan(databaseInstant, n);
    }

    public DaemonService getDaemon() {
        return this.rawStoreDaemon;
    }

    public void createFinished() throws StandardException {
        this.xactFactory.createFinished();
        this.dataFactory.createFinished();
    }

    public void getRawStoreProperties(PersistentSet persistentSet) throws StandardException {
        this.logFactory.getLogFactoryProperties(persistentSet);
    }

    public void freezePersistentStore() throws StandardException {
        this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, true);
        this.logFactory.freezePersistentStore();
    }

    public void unfreezePersistentStore() throws StandardException {
        this.logFactory.unfreezePersistentStore();
    }

    public int encrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws StandardException {
        if (!this.databaseEncrypted || this.encryptionEngine == null) {
            throw StandardException.newException("XSAI3.S");
        }
        ++this.counter_encrypt;
        return this.encryptionEngine.encrypt(byArray, n, n2, byArray2, n3);
    }

    public int decrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws StandardException {
        if (!this.databaseEncrypted || this.decryptionEngine == null) {
            throw StandardException.newException("XSAI3.S");
        }
        ++this.counter_decrypt;
        return this.decryptionEngine.decrypt(byArray, n, n2, byArray2, n3);
    }

    public int getEncryptionBlockSize() {
        return this.encryptionBlockSize;
    }

    public int random() {
        return this.databaseEncrypted ? this.random.nextInt() : 0;
    }

    public Serializable changeBootPassword(Properties properties, Serializable serializable) throws StandardException {
        if (this.isReadOnly()) {
            throw StandardException.newException("XBCX9.S");
        }
        if (!this.databaseEncrypted) {
            throw StandardException.newException("XBCX8.S");
        }
        if (serializable == null) {
            throw StandardException.newException("XBCX5.S");
        }
        if (!(serializable instanceof String)) {
            throw StandardException.newException("XBCX6.S");
        }
        String string = (String)((Object)serializable);
        return this.cipherFactory.changeBootPassword((String)((Object)serializable), properties, this.encryptionEngine);
    }

    public StandardException markCorrupt(StandardException standardException) {
        this.logFactory.markCorrupt(standardException);
        this.dataFactory.markCorrupt(standardException);
        this.xactFactory.markCorrupt(standardException);
        return standardException;
    }

    public String getTransactionFactoryModule() {
        return "org.apache.derby.iapi.store.raw.xact.TransactionFactory";
    }

    public String getDataFactoryModule() {
        return "org.apache.derby.iapi.store.raw.data.DataFactory";
    }

    public String getLogFactoryModule() {
        return "org.apache.derby.iapi.store.raw.log.LogFactory";
    }

    private void logHistory(OutputStreamWriter outputStreamWriter, String string) throws IOException {
        Date date = new Date();
        outputStreamWriter.write(date.toString() + ":" + string + "\n");
        outputStreamWriter.flush();
    }

    protected boolean privCopyDirectory(StorageFile storageFile, File file) {
        return this.privCopyDirectory(storageFile, file, null, null);
    }

    protected boolean privCopyDirectory(File file, StorageFile storageFile) {
        return this.privCopyDirectory(file, storageFile, null, null);
    }

    public long getMaxContainerId() throws StandardException {
        return this.dataFactory.getMaxContainerId();
    }

    private synchronized OutputStreamWriter privFileWriter(StorageFile storageFile, boolean bl) throws IOException {
        this.actionCode = 1;
        this.actionStorageFile = storageFile;
        this.actionAppend = bl;
        try {
            try {
                OutputStreamWriter outputStreamWriter = (OutputStreamWriter)AccessController.doPrivileged(this);
                Object var4_4 = null;
                this.actionStorageFile = null;
                return outputStreamWriter;
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.actionStorageFile = null;
            throw throwable;
        }
    }

    protected synchronized boolean privExists(File file) {
        this.actionCode = 2;
        this.actionRegularFile = file;
        try {
            try {
                Object t = AccessController.doPrivileged(this);
                boolean bl = (Boolean)t;
                Object var3_6 = null;
                this.actionRegularFile = null;
                return bl;
            }
            catch (PrivilegedActionException privilegedActionException) {
                boolean bl = false;
                Object var3_7 = null;
                this.actionRegularFile = null;
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var3_8 = null;
            this.actionRegularFile = null;
            throw throwable;
        }
    }

    protected synchronized boolean privExists(StorageFile storageFile) {
        this.actionCode = 3;
        this.actionStorageFile = storageFile;
        try {
            try {
                Object t = AccessController.doPrivileged(this);
                boolean bl = (Boolean)t;
                Object var3_6 = null;
                this.actionStorageFile = null;
                return bl;
            }
            catch (PrivilegedActionException privilegedActionException) {
                boolean bl = false;
                Object var3_7 = null;
                this.actionStorageFile = null;
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var3_8 = null;
            this.actionStorageFile = null;
            throw throwable;
        }
    }

    protected synchronized boolean privDelete(File file) {
        this.actionCode = 4;
        this.actionRegularFile = file;
        try {
            try {
                Object t = AccessController.doPrivileged(this);
                boolean bl = (Boolean)t;
                Object var3_6 = null;
                this.actionRegularFile = null;
                return bl;
            }
            catch (PrivilegedActionException privilegedActionException) {
                boolean bl = false;
                Object var3_7 = null;
                this.actionRegularFile = null;
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var3_8 = null;
            this.actionRegularFile = null;
            throw throwable;
        }
    }

    protected synchronized boolean privMkdirs(File file) {
        this.actionCode = 5;
        this.actionRegularFile = file;
        try {
            try {
                Object t = AccessController.doPrivileged(this);
                boolean bl = (Boolean)t;
                Object var3_6 = null;
                this.actionRegularFile = null;
                return bl;
            }
            catch (PrivilegedActionException privilegedActionException) {
                boolean bl = false;
                Object var3_7 = null;
                this.actionRegularFile = null;
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var3_8 = null;
            this.actionRegularFile = null;
            throw throwable;
        }
    }

    protected synchronized boolean privIsDirectory(File file) {
        this.actionCode = 6;
        this.actionRegularFile = file;
        try {
            try {
                Object t = AccessController.doPrivileged(this);
                boolean bl = (Boolean)t;
                Object var3_6 = null;
                this.actionRegularFile = null;
                return bl;
            }
            catch (PrivilegedActionException privilegedActionException) {
                boolean bl = false;
                Object var3_7 = null;
                this.actionRegularFile = null;
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var3_8 = null;
            this.actionRegularFile = null;
            throw throwable;
        }
    }

    protected synchronized boolean privRemoveDirectory(File file) {
        this.actionCode = 7;
        this.actionRegularFile = file;
        try {
            try {
                Object t = AccessController.doPrivileged(this);
                boolean bl = (Boolean)t;
                Object var3_6 = null;
                this.actionRegularFile = null;
                return bl;
            }
            catch (PrivilegedActionException privilegedActionException) {
                boolean bl = false;
                Object var3_7 = null;
                this.actionRegularFile = null;
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var3_8 = null;
            this.actionRegularFile = null;
            throw throwable;
        }
    }

    protected synchronized boolean privRenameTo(File file, File file2) {
        this.actionCode = 8;
        this.actionRegularFile = file;
        this.actionRegularFile2 = file2;
        try {
            try {
                Object t = AccessController.doPrivileged(this);
                boolean bl = (Boolean)t;
                Object var4_7 = null;
                this.actionRegularFile = null;
                this.actionRegularFile2 = null;
                return bl;
            }
            catch (PrivilegedActionException privilegedActionException) {
                boolean bl = false;
                Object var4_8 = null;
                this.actionRegularFile = null;
                this.actionRegularFile2 = null;
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            this.actionRegularFile = null;
            this.actionRegularFile2 = null;
            throw throwable;
        }
    }

    protected synchronized boolean privCopyDirectory(StorageFile storageFile, File file, byte[] byArray, String[] stringArray) {
        this.actionCode = 9;
        this.actionStorageFile = storageFile;
        this.actionRegularFile = file;
        this.actionBuffer = byArray;
        this.actionFilter = stringArray;
        try {
            try {
                Object t = AccessController.doPrivileged(this);
                boolean bl = (Boolean)t;
                Object var6_9 = null;
                this.actionStorageFile = null;
                this.actionRegularFile = null;
                this.actionBuffer = null;
                this.actionFilter = null;
                return bl;
            }
            catch (PrivilegedActionException privilegedActionException) {
                boolean bl = false;
                Object var6_10 = null;
                this.actionStorageFile = null;
                this.actionRegularFile = null;
                this.actionBuffer = null;
                this.actionFilter = null;
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            this.actionStorageFile = null;
            this.actionRegularFile = null;
            this.actionBuffer = null;
            this.actionFilter = null;
            throw throwable;
        }
    }

    protected synchronized boolean privCopyDirectory(File file, StorageFile storageFile, byte[] byArray, String[] stringArray) {
        this.actionCode = 10;
        this.actionStorageFile = storageFile;
        this.actionRegularFile = file;
        this.actionBuffer = byArray;
        this.actionFilter = stringArray;
        try {
            try {
                Object t = AccessController.doPrivileged(this);
                boolean bl = (Boolean)t;
                Object var6_9 = null;
                this.actionStorageFile = null;
                this.actionRegularFile = null;
                this.actionBuffer = null;
                this.actionFilter = null;
                return bl;
            }
            catch (PrivilegedActionException privilegedActionException) {
                boolean bl = false;
                Object var6_10 = null;
                this.actionStorageFile = null;
                this.actionRegularFile = null;
                this.actionBuffer = null;
                this.actionFilter = null;
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            this.actionStorageFile = null;
            this.actionRegularFile = null;
            this.actionBuffer = null;
            this.actionFilter = null;
            throw throwable;
        }
    }

    protected synchronized boolean privCopyFile(File file, StorageFile storageFile) {
        this.actionCode = 11;
        this.actionStorageFile = storageFile;
        this.actionRegularFile = file;
        try {
            try {
                Object t = AccessController.doPrivileged(this);
                boolean bl = (Boolean)t;
                Object var4_7 = null;
                this.actionStorageFile = null;
                this.actionRegularFile = null;
                return bl;
            }
            catch (PrivilegedActionException privilegedActionException) {
                boolean bl = false;
                Object var4_8 = null;
                this.actionStorageFile = null;
                this.actionRegularFile = null;
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            this.actionStorageFile = null;
            this.actionRegularFile = null;
            throw throwable;
        }
    }

    protected synchronized String[] privList(File file) {
        this.actionCode = 12;
        this.actionRegularFile = file;
        try {
            try {
                String[] stringArray = (String[])AccessController.doPrivileged(this);
                Object var3_4 = null;
                this.actionRegularFile = null;
                return stringArray;
            }
            catch (PrivilegedActionException privilegedActionException) {
                String[] stringArray = null;
                Object var3_5 = null;
                this.actionRegularFile = null;
                return stringArray;
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this.actionRegularFile = null;
            throw throwable;
        }
    }

    public Object run() throws IOException {
        switch (this.actionCode) {
            case 1: {
                return new OutputStreamWriter(this.actionStorageFile.getOutputStream(this.actionAppend));
            }
            case 2: {
                return ReuseFactory.getBoolean(this.actionRegularFile.exists());
            }
            case 3: {
                return ReuseFactory.getBoolean(this.actionStorageFile.exists());
            }
            case 4: {
                return ReuseFactory.getBoolean(this.actionRegularFile.delete());
            }
            case 5: {
                return ReuseFactory.getBoolean(this.actionRegularFile.mkdirs());
            }
            case 6: {
                return ReuseFactory.getBoolean(this.actionRegularFile.isDirectory());
            }
            case 7: {
                return ReuseFactory.getBoolean(FileUtil.removeDirectory(this.actionRegularFile));
            }
            case 8: {
                return ReuseFactory.getBoolean(this.actionRegularFile.renameTo(this.actionRegularFile2));
            }
            case 9: {
                return ReuseFactory.getBoolean(FileUtil.copyDirectory(this.storageFactory, this.actionStorageFile, this.actionRegularFile, this.actionBuffer, this.actionFilter));
            }
            case 10: {
                return ReuseFactory.getBoolean(FileUtil.copyDirectory((WritableStorageFactory)this.storageFactory, this.actionRegularFile, this.actionStorageFile, this.actionBuffer, this.actionFilter));
            }
            case 11: {
                return ReuseFactory.getBoolean(FileUtil.copyFile((WritableStorageFactory)this.storageFactory, this.actionRegularFile, this.actionStorageFile));
            }
            case 12: {
                return this.actionRegularFile.list();
            }
        }
        return null;
    }
}

