/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.impl.store.raw.data.AllocPage;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.PhysicalPageOperation;

public final class AllocPageOperation
extends PhysicalPageOperation {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    protected long newPageNumber;
    protected int doStatus;
    protected int undoStatus;

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        CompressedNumber.writeLong(objectOutput, this.newPageNumber);
        CompressedNumber.writeInt(objectOutput, this.doStatus);
        CompressedNumber.writeInt(objectOutput, this.undoStatus);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.newPageNumber = CompressedNumber.readLong(objectInput);
        this.doStatus = CompressedNumber.readInt(objectInput);
        this.undoStatus = CompressedNumber.readInt(objectInput);
    }

    public int getTypeFormatId() {
        return 111;
    }

    public final void doMe(Transaction transaction, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException {
        ((AllocPage)this.page).setPageStatus(logInstant, this.newPageNumber, this.doStatus);
    }

    public void undoMe(Transaction transaction, BasePage basePage, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException {
        ((AllocPage)basePage).setPageStatus(logInstant, this.newPageNumber, this.undoStatus);
    }

    public void restoreMe(Transaction transaction, BasePage basePage, LogInstant logInstant, LimitObjectInput limitObjectInput) {
    }

    public String toString() {
        return null;
    }

    public AllocPageOperation(AllocPage allocPage, long l, int n, int n2) throws StandardException {
        super(allocPage);
        this.newPageNumber = l;
        this.doStatus = n;
        this.undoStatus = n2;
    }

    public AllocPageOperation() {
    }
}

