/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.impl.store.raw.data.AllocExtent;
import org.apache.derby.impl.store.raw.data.AllocPage;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.SpaceInformation;

class AllocationCache {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private int numExtents = 0;
    private long[] lowRange;
    private long[] hiRange;
    private boolean[] isDirty;
    private AllocExtent[] extents;
    private long[] extentPageNums;
    private boolean isValid = false;

    protected void reset() {
        this.numExtents = 0;
        this.isValid = false;
        if (this.lowRange != null) {
            int n = 0;
            while (n < this.lowRange.length) {
                this.lowRange[n] = -1L;
                this.hiRange[n] = -1L;
                this.extentPageNums[n] = -1L;
                this.extents[n] = null;
                this.isDirty[n] = false;
                ++n;
            }
        }
    }

    protected long getAllocPageNumber(BaseContainerHandle baseContainerHandle, long l, long l2) throws StandardException {
        int n = 0;
        while (n < this.numExtents) {
            if (this.lowRange[n] <= l && l <= this.hiRange[n]) {
                return this.extentPageNums[n];
            }
            ++n;
        }
        if (!this.isValid) {
            this.validate(baseContainerHandle, l2);
            n = 0;
            while (n < this.numExtents) {
                if (this.lowRange[n] <= l && l <= this.hiRange[n]) {
                    return this.extentPageNums[n];
                }
                ++n;
            }
        }
        return -1L;
    }

    protected long getLastPageNumber(BaseContainerHandle baseContainerHandle, long l) throws StandardException {
        if (!this.isValid) {
            this.validate(baseContainerHandle, l);
        }
        return this.hiRange[this.numExtents - 1];
    }

    protected void trackUnfilledPage(long l, boolean bl) {
        if (!this.isValid || this.numExtents <= 0) {
            return;
        }
        int n = 0;
        while (n < this.numExtents) {
            if (this.lowRange[n] <= l && l <= this.hiRange[n]) {
                AllocExtent allocExtent = this.extents[n];
                if (allocExtent == null || !allocExtent.trackUnfilledPage(l, bl) || this.extents[n] == null) break;
                this.isDirty[n] = true;
                break;
            }
            ++n;
        }
    }

    protected long getUnfilledPageNumber(BaseContainerHandle baseContainerHandle, long l, long l2) throws StandardException {
        if (!this.isValid) {
            this.validate(baseContainerHandle, l);
        }
        if (l2 == -1L) {
            int n = 0;
            while (n < this.numExtents) {
                if (this.extents[n] != null) {
                    return this.extents[n].getUnfilledPageNumber(l2);
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.numExtents) {
                if (l2 <= this.hiRange[n] && this.extents[n] != null) {
                    return this.extents[n].getUnfilledPageNumber(l2);
                }
                ++n;
            }
        }
        return -1L;
    }

    protected long getEstimatedPageCount(BaseContainerHandle baseContainerHandle, long l) throws StandardException {
        if (!this.isValid) {
            this.validate(baseContainerHandle, l);
        }
        long l2 = 0L;
        int n = 0;
        while (n < this.numExtents) {
            if (this.extents[n] != null) {
                l2 += (long)this.extents[n].getAllocatedPageCount();
            }
            ++n;
        }
        return l2;
    }

    protected SpaceInformation getAllPageCounts(BaseContainerHandle baseContainerHandle, long l) throws StandardException {
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        if (!this.isValid) {
            this.validate(baseContainerHandle, l);
        }
        int n = 0;
        while (n < this.numExtents) {
            if (this.extents[n] != null) {
                l2 = this.extents[n].getAllocatedPageCount();
                l3 += l2;
                l5 += (long)this.extents[n].getUnfilledPageCount();
                l4 += (long)this.extents[n].getTotalPageCount() - l2;
            }
            ++n;
        }
        return new SpaceInformation(l3, l4, l5);
    }

    protected void invalidate() {
        int n = 0;
        while (n < this.numExtents) {
            this.isDirty[n] = false;
            this.extents[n] = null;
            ++n;
        }
        this.isValid = false;
    }

    protected void invalidate(AllocPage allocPage, long l) throws StandardException {
        this.isValid = false;
        if (this.numExtents == 0) {
            return;
        }
        int n = 0;
        while (n < this.numExtents) {
            if (this.extentPageNums[n] == l) {
                if (allocPage != null && this.extents[n] != null && this.isDirty[n]) {
                    allocPage.updateUnfilledPageInfo(this.extents[n]);
                    this.isDirty[n] = false;
                }
                this.extents[n] = null;
                return;
            }
            ++n;
        }
        if (l > this.hiRange[this.numExtents - 1]) {
            return;
        }
    }

    protected void invalidateLastExtent() {
        this.isValid = false;
        if (this.numExtents > 0) {
            this.extents[this.numExtents - 1] = null;
        }
    }

    protected long getLastValidPage(BaseContainerHandle baseContainerHandle, long l) throws StandardException {
        AllocExtent allocExtent = null;
        long l2 = -1L;
        if (!this.isValid) {
            this.validate(baseContainerHandle, l);
        }
        if (this.numExtents == 0) {
            return -1L;
        }
        int n = this.numExtents - 1;
        while (n >= 0) {
            allocExtent = this.extents[n];
            l2 = allocExtent.getLastValidPageNumber();
            if (l2 != -1L) break;
            --n;
        }
        return l2;
    }

    protected long getNextValidPage(BaseContainerHandle baseContainerHandle, long l, long l2) throws StandardException {
        if (!this.isValid) {
            this.validate(baseContainerHandle, l2);
        }
        if (this.numExtents == 0) {
            return -1L;
        }
        AllocExtent allocExtent = null;
        int n = 0;
        while (n < this.numExtents) {
            if (l < this.hiRange[n]) {
                allocExtent = this.extents[n];
                break;
            }
            ++n;
        }
        if (allocExtent == null) {
            return -1L;
        }
        long l3 = -1L;
        while (n < this.numExtents) {
            allocExtent = this.extents[n];
            l3 = allocExtent.getNextValidPageNumber(l);
            if (l3 != -1L) break;
            ++n;
        }
        return l3;
    }

    protected int getPageStatus(BaseContainerHandle baseContainerHandle, long l, long l2) throws StandardException {
        AllocExtent allocExtent = null;
        int n = 0;
        while (n < this.numExtents) {
            if (this.lowRange[n] <= l && l <= this.hiRange[n]) {
                allocExtent = this.extents[n];
                break;
            }
            ++n;
        }
        if (allocExtent == null) {
            if (!this.isValid) {
                this.validate(baseContainerHandle, l2);
            }
            n = 0;
            while (n < this.numExtents) {
                if (this.lowRange[n] <= l && l <= this.hiRange[n]) {
                    allocExtent = this.extents[n];
                    break;
                }
                ++n;
            }
        }
        return allocExtent.getPageStatus(l);
    }

    private void validate(BaseContainerHandle baseContainerHandle, long l) throws StandardException {
        if (this.numExtents == 0) {
            long l2 = l;
            while (!this.isValid) {
                this.growArrays(++this.numExtents);
                Page page = baseContainerHandle.getAllocPage(l2);
                AllocPage allocPage = (AllocPage)page;
                this.setArrays(this.numExtents - 1, allocPage);
                if (allocPage.isLast()) {
                    this.isValid = true;
                } else {
                    l2 = allocPage.getNextAllocPageNumber();
                }
                allocPage.unlatch();
            }
        } else {
            int n = 0;
            while (n < this.numExtents - 1) {
                if (this.extents[n] == null) {
                    AllocPage allocPage = (AllocPage)baseContainerHandle.getAllocPage(this.extentPageNums[n]);
                    this.setArrays(n, allocPage);
                    allocPage.unlatch();
                }
                ++n;
            }
            long l3 = this.extentPageNums[this.numExtents - 1];
            while (!this.isValid) {
                AllocPage allocPage = (AllocPage)baseContainerHandle.getAllocPage(l3);
                if (this.extents[this.numExtents - 1] == null) {
                    this.setArrays(this.numExtents - 1, allocPage);
                }
                if (!allocPage.isLast()) {
                    this.growArrays(++this.numExtents);
                    l3 = allocPage.getNextAllocPageNumber();
                } else {
                    this.isValid = true;
                }
                allocPage.unlatch();
            }
        }
    }

    private void setArrays(int n, AllocPage allocPage) {
        AllocExtent allocExtent;
        this.extents[n] = allocExtent = allocPage.getAllocExtent();
        this.lowRange[n] = allocExtent.getFirstPagenum();
        this.hiRange[n] = allocExtent.getLastPagenum();
        this.extentPageNums[n] = allocPage.getPageNumber();
    }

    private void growArrays(int n) {
        int n2 = this.lowRange == null || this.lowRange.length == 0 ? 0 : this.lowRange.length;
        if (n2 >= n) {
            return;
        }
        long[] lArray = this.lowRange;
        long[] lArray2 = this.hiRange;
        AllocExtent[] allocExtentArray = this.extents;
        boolean[] blArray = this.isDirty;
        long[] lArray3 = this.extentPageNums;
        this.lowRange = new long[n];
        this.hiRange = new long[n];
        this.isDirty = new boolean[n];
        this.extents = new AllocExtent[n];
        this.extentPageNums = new long[n];
        if (n2 > 0) {
            System.arraycopy(lArray, 0, this.lowRange, 0, lArray.length);
            System.arraycopy(lArray2, 0, this.hiRange, 0, lArray2.length);
            System.arraycopy(blArray, 0, this.isDirty, 0, blArray.length);
            System.arraycopy(allocExtentArray, 0, this.extents, 0, allocExtentArray.length);
            System.arraycopy(lArray3, 0, this.extentPageNums, 0, lArray3.length);
        }
        int n3 = n2;
        while (n3 < n) {
            this.lowRange[n3] = -1L;
            this.hiRange[n3] = -1L;
            this.isDirty[n3] = false;
            this.extentPageNums[n3] = -1L;
            this.extents[n3] = null;
            ++n3;
        }
    }

    protected void dumpAllocationCache() {
    }

    protected AllocationCache() {
    }
}

