/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.log;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.log.LogCounter;
import org.apache.derby.impl.store.raw.log.TruncationPoint;

public final class SaveLWMOperation
implements Loggable {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private UUID name;
    private LogInstant LWMinstant;
    private boolean set;

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeBoolean(this.set);
        objectOutput.writeObject(this.name);
        long l = 0L;
        if (this.LWMinstant != null) {
            l = ((LogCounter)this.LWMinstant).getValueAsLong();
        }
        CompressedNumber.writeLong(objectOutput, l);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.set = objectInput.readBoolean();
        this.name = (UUID)objectInput.readObject();
        long l = CompressedNumber.readLong(objectInput);
        this.LWMinstant = l != 0L ? new LogCounter(l) : null;
    }

    public int getTypeFormatId() {
        return 114;
    }

    public void doMe(Transaction transaction, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException {
        if (this.set) {
            ((RawTransaction)transaction).addTruncationLWM(this.name, this.LWMinstant);
        } else {
            ((RawTransaction)transaction).removeTruncationLWM(this.name);
        }
    }

    public ByteArray getPreparedLog() {
        return null;
    }

    public boolean needsRedo(Transaction transaction) {
        return true;
    }

    public void releaseResource(Transaction transaction) {
    }

    public int group() {
        return 256;
    }

    public TruncationPoint truncationLWM() {
        return new TruncationPoint(this.name, this.LWMinstant);
    }

    public String toString() {
        return null;
    }

    public SaveLWMOperation(UUID uUID, LogInstant logInstant, boolean bl) {
        this.name = uUID;
        this.LWMinstant = logInstant;
        this.set = bl;
    }

    public SaveLWMOperation() {
    }
}

