/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;

public class CastExpression
extends Expression {
    private Expression expression;
    private boolean ignoreAutoboxing = false;
    private boolean coerce = false;

    public static CastExpression asExpression(ClassNode type, Expression expression) {
        CastExpression answer = new CastExpression(type, expression);
        answer.setCoerce(true);
        return answer;
    }

    public CastExpression(ClassNode type, Expression expression) {
        this(type, expression, false);
    }

    public CastExpression(ClassNode type, Expression expression, boolean ignoreAutoboxing) {
        super.setType(type);
        this.expression = expression;
        this.ignoreAutoboxing = ignoreAutoboxing;
    }

    public boolean isIgnoringAutoboxing() {
        return this.ignoreAutoboxing;
    }

    public boolean isCoerce() {
        return this.coerce;
    }

    public void setCoerce(boolean coerce) {
        this.coerce = coerce;
    }

    public String toString() {
        return super.toString() + "[(" + this.getType().getName() + ") " + this.expression + "]";
    }

    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitCastExpression(this);
    }

    public Expression transformExpression(ExpressionTransformer transformer) {
        return new CastExpression(this.getType(), transformer.transform(this.expression));
    }

    public String getText() {
        return "(" + this.getType() + ") " + this.expression.getText();
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setType(ClassNode t) {
        super.setType(t);
    }
}

