/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.ij;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.Properties;
import org.apache.derby.iapi.tools.i18n.LocalizedInput;
import org.apache.derby.iapi.tools.i18n.LocalizedOutput;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.tools.ij.util;
import org.apache.derby.impl.tools.ij.utilMain;
import org.apache.derby.tools.JDBCDisplayUtil;

public class Main {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    public LocalizedOutput out;
    public utilMain utilInstance;
    public Class langUtilClass;

    public static void main(String[] stringArray) throws IOException {
        Main.mainCore(stringArray, new Main(true));
    }

    public static void mainCore(String[] stringArray, Main main) throws IOException {
        Object object;
        String string;
        LocalizedOutput localizedOutput;
        LocalizedResource localizedResource;
        Properties properties;
        String string2;
        LocalizedInput localizedInput;
        block18: {
            localizedInput = null;
            InputStream inputStream = null;
            string2 = null;
            properties = null;
            boolean bl = util.getPropertyArg(stringArray);
            properties = util.getConnAttributeArg(stringArray);
            main.initAppUI();
            localizedResource = LocalizedResource.getInstance();
            localizedOutput = localizedResource.getNewOutput(System.out);
            String string3 = util.getFileArg(stringArray);
            String string4 = util.getInputResourceNameArg(stringArray);
            if (util.invalidArgs(stringArray, bl, string3, string4)) {
                util.Usage(localizedOutput);
                return;
            }
            if (string4 != null) {
                localizedInput = localizedResource.getNewInput(util.getResourceAsStream(string4));
                if (localizedInput == null) {
                    localizedOutput.println(localizedResource.getTextMessage("IJ_IjErroResoNo", string4));
                    return;
                }
            } else if (string3 == null) {
                localizedInput = localizedResource.getNewInput(System.in);
                localizedOutput.flush();
            } else {
                try {
                    inputStream = new FileInputStream(string3);
                    if (inputStream != null) {
                        inputStream = new BufferedInputStream(inputStream, 2048);
                        localizedInput = localizedResource.getNewInput(inputStream);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (Boolean.getBoolean("ij.searchClassPath")) {
                        localizedInput = localizedResource.getNewInput(util.getResourceAsStream(string3));
                    }
                    if (localizedInput != null) break block18;
                    localizedOutput.println(localizedResource.getTextMessage("IJ_IjErroFileNo", string3));
                    return;
                }
            }
        }
        string2 = util.getSystemProperty("ij.unicodeEscape");
        if (string2 != null && string2.toUpperCase(Locale.ENGLISH).equals("ON")) {
            LocalizedResource.setUnicodeEscape(true);
        }
        if ((string = util.getSystemProperty("ij.outfile")) != null && string.length() > 0) {
            object = localizedOutput;
            try {
                localizedOutput = localizedResource.getNewOutput(new FileOutputStream(string));
            }
            catch (IOException iOException) {
                ((PrintWriter)object).println(localizedResource.getTextMessage("IJ_IjErroUnabTo", string));
            }
        }
        if ((object = util.getSystemProperty("maximumDisplayWidth")) == null) {
            object = util.getSystemProperty("ij.maximumDisplayWidth");
        }
        if (object != null && ((String)object).length() > 0) {
            try {
                int n = Integer.parseInt((String)object);
                JDBCDisplayUtil.setMaxDisplayWidth(n);
            }
            catch (NumberFormatException numberFormatException) {
                localizedOutput.println(localizedResource.getTextMessage("IJ_IjErroMaxiVa", object));
            }
        }
        Main main2 = main.getMain(localizedOutput);
        main2.go(localizedInput, localizedOutput, properties);
        localizedInput.close();
        localizedOutput.close();
    }

    public Main getMain(LocalizedOutput localizedOutput) {
        return new Main(localizedOutput);
    }

    public utilMain getutilMain(int n, LocalizedOutput localizedOutput) {
        return new utilMain(n, localizedOutput);
    }

    public void go(LocalizedInput localizedInput, LocalizedOutput localizedOutput, Properties properties) {
        LocalizedInput[] localizedInputArray = new LocalizedInput[]{localizedInput};
        this.utilInstance.go(localizedInputArray, localizedOutput, properties);
    }

    public void go(InputStream inputStream, PrintStream printStream, Properties properties) {
        this.initAppUI();
        LocalizedResource localizedResource = LocalizedResource.getInstance();
        this.go(localizedResource.getNewInput(inputStream), localizedResource.getNewOutput(printStream), properties);
    }

    public void initAppUI() {
        LocalizedResource.getInstance();
    }

    public Main() {
        this(null);
    }

    public Main(LocalizedOutput localizedOutput) {
        this.out = localizedOutput != null ? localizedOutput : LocalizedResource.getInstance().getNewOutput(System.out);
        this.utilInstance = this.getutilMain(1, this.out);
    }

    public Main(boolean bl) {
    }
}

