/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.BaseTypeIdImpl;
import org.apache.derby.iapi.services.io.Formatable;

public class TypeDescriptorImpl
implements TypeDescriptor,
Formatable {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1998, 2004.";
    private BaseTypeIdImpl typeId;
    private int precision;
    private int scale;
    private boolean isNullable;
    private int maximumWidth;

    public int getMaximumWidth() {
        return this.maximumWidth;
    }

    public int getJDBCTypeId() {
        return this.typeId.getJDBCTypeId();
    }

    public String getTypeName() {
        return this.typeId.getSQLTypeName();
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public void setNullability(boolean bl) {
        this.isNullable = bl;
    }

    public String getSQLstring() {
        return this.typeId.toParsableString(this);
    }

    public String toString() {
        String string = this.getSQLstring();
        if (!this.isNullable()) {
            return string + " NOT NULL";
        }
        return string;
    }

    public BaseTypeIdImpl getTypeId() {
        return this.typeId;
    }

    public boolean equals(Object object) {
        TypeDescriptor typeDescriptor = (TypeDescriptor)object;
        return this.getTypeName().equals(typeDescriptor.getTypeName()) && this.precision == typeDescriptor.getPrecision() && this.scale == typeDescriptor.getScale() && this.isNullable == typeDescriptor.isNullable() && this.maximumWidth == typeDescriptor.getMaximumWidth();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.typeId = (BaseTypeIdImpl)objectInput.readObject();
        this.precision = objectInput.readInt();
        this.scale = objectInput.readInt();
        this.isNullable = objectInput.readBoolean();
        this.maximumWidth = objectInput.readInt();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.typeId);
        objectOutput.writeInt(this.precision);
        objectOutput.writeInt(this.scale);
        objectOutput.writeBoolean(this.isNullable);
        objectOutput.writeInt(this.maximumWidth);
    }

    public int getTypeFormatId() {
        return 14;
    }

    public TypeDescriptorImpl() {
    }

    public TypeDescriptorImpl(BaseTypeIdImpl baseTypeIdImpl, int n, int n2, boolean bl, int n3) {
        this.typeId = baseTypeIdImpl;
        this.precision = n;
        this.scale = n2;
        this.isNullable = bl;
        this.maximumWidth = n3;
    }

    public TypeDescriptorImpl(BaseTypeIdImpl baseTypeIdImpl, boolean bl, int n) {
        this.typeId = baseTypeIdImpl;
        this.isNullable = bl;
        this.maximumWidth = n;
    }

    public TypeDescriptorImpl(TypeDescriptorImpl typeDescriptorImpl, int n, int n2, boolean bl, int n3) {
        this.typeId = typeDescriptorImpl.typeId;
        this.precision = n;
        this.scale = n2;
        this.isNullable = bl;
        this.maximumWidth = n3;
    }

    public TypeDescriptorImpl(TypeDescriptorImpl typeDescriptorImpl, boolean bl, int n) {
        this.typeId = typeDescriptorImpl.typeId;
        this.precision = typeDescriptorImpl.precision;
        this.scale = typeDescriptorImpl.scale;
        this.isNullable = bl;
        this.maximumWidth = n;
    }
}

