/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.context;

import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import org.apache.derby.iapi.error.PassThroughException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.context.ErrorStringBuilder;
import org.apache.derby.iapi.services.context.ShutdownException;
import org.apache.derby.iapi.services.i18n.LocaleFinder;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;

public class ContextManager {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private final Stack holder;
    private Locale messageLocale;
    private final Hashtable ctxTable;
    final ContextService owningCsf;
    private int logSeverityLevel;
    private HeaderPrintWriter errorStream;
    private ErrorStringBuilder errorStringBuilder;
    private boolean shutdown;
    private LocaleFinder finder;
    final Stack cmStack = new Stack();
    Thread activeThread;
    int activeCount;

    public void pushContext(Context context) {
        this.checkInterrupt();
        String string = context.getIdName();
        Stack<Context> stack = (Stack<Context>)this.ctxTable.get(string);
        if (stack == null) {
            stack = new Stack<Context>();
            this.ctxTable.put(string, stack);
        }
        stack.push(context);
        this.holder.push(context);
    }

    public Context getContext(String string) {
        this.checkInterrupt();
        Stack stack = (Stack)this.ctxTable.get(string);
        if (stack == null || stack.empty()) {
            return null;
        }
        return (Context)stack.peek();
    }

    public void popContext() {
        this.checkInterrupt();
        if (this.holder.empty()) {
            return;
        }
        Context context = (Context)this.holder.pop();
        String string = context.getIdName();
        Stack stack = (Stack)this.ctxTable.get(string);
        stack.pop();
    }

    void popContext(Context context) {
        this.checkInterrupt();
        int n = this.holder.lastIndexOf(context);
        if (n != -1) {
            this.holder.removeElementAt(n);
        }
        Stack stack = (Stack)this.ctxTable.get(context.getIdName());
        boolean bl = stack.removeElement(context);
    }

    public boolean cleanupOnError(Throwable throwable) {
        Context context;
        boolean bl;
        if (this.shutdown) {
            return true;
        }
        if (this.errorStringBuilder == null) {
            this.errorStringBuilder = new ErrorStringBuilder(this.errorStream.getHeader());
        }
        ThreadDeath threadDeath = null;
        if (throwable instanceof ThreadDeath) {
            threadDeath = (ThreadDeath)throwable;
        }
        if (throwable instanceof PassThroughException) {
            throwable = ((PassThroughException)throwable).getException();
        }
        if (bl = this.reportError(throwable)) {
            ContextImpl contextImpl = null;
            StringBuffer stringBuffer = null;
            if (!this.shutdown && (contextImpl = (ContextImpl)this.getContext("LanguageConnectionContext")) != null) {
                stringBuffer = contextImpl.appendErrorInfo();
            }
            String string = "Cleanup action starting";
            if (stringBuffer != null) {
                stringBuffer.append(string);
                string = stringBuffer.toString();
            }
            this.errorStringBuilder.appendln(string);
            if (!this.shutdown && (context = (ContextImpl)this.getContext("StatementContext")) != null && (stringBuffer = ((ContextImpl)context).appendErrorInfo()) != null) {
                this.errorStringBuilder.appendln(stringBuffer.toString());
            }
        }
        block3: while (true) {
            int n;
            int n2 = n = throwable instanceof StandardException ? ((StandardException)throwable).getSeverity() : 0;
            if (bl) {
                this.errorStringBuilder.stackTrace(throwable);
                this.flushErrorString();
            }
            boolean bl2 = false;
            int n3 = this.holder.size() - 1;
            while (n3 >= 0) {
                block21: {
                    try {
                        if (bl2) break block3;
                        context = (Context)this.holder.elementAt(n3);
                        bl2 = context.isLastHandler(n);
                        context.cleanupOnError(throwable);
                    }
                    catch (StandardException standardException) {
                        if (throwable instanceof StandardException && standardException.getSeverity() > ((StandardException)throwable).getSeverity()) {
                            throwable = standardException;
                            bl = this.reportError(standardException);
                            if (!bl) continue block3;
                            this.errorStream.println("New exception raised during cleanup " + throwable.getMessage());
                            this.errorStream.flush();
                            continue block3;
                        }
                        if (this.reportError(standardException)) {
                            this.errorStringBuilder.appendln("Less severe exception raised during cleanup (ignored) " + standardException.getMessage());
                            this.errorStringBuilder.stackTrace(standardException);
                            this.flushErrorString();
                        }
                    }
                    catch (Throwable throwable2) {
                        bl = this.reportError(throwable2);
                        if (throwable instanceof StandardException) {
                            throwable = throwable2;
                            if (!bl) continue block3;
                            this.errorStream.println("New exception raised during cleanup " + throwable.getMessage());
                            this.errorStream.flush();
                            continue block3;
                        }
                        if (bl) {
                            this.errorStringBuilder.appendln("Equally severe exception raised during cleanup (ignored) " + throwable2.getMessage());
                            this.errorStringBuilder.stackTrace(throwable2);
                            this.flushErrorString();
                        }
                        if (!(throwable2 instanceof ThreadDeath)) break block21;
                        if (threadDeath != null) {
                            throw threadDeath;
                        }
                        threadDeath = (ThreadDeath)throwable2;
                    }
                }
                --n3;
            }
            break;
        }
        if (bl) {
            this.errorStream.println("Cleanup action completed");
            this.errorStream.flush();
        }
        if (threadDeath != null) {
            throw threadDeath;
        }
        return false;
    }

    synchronized boolean setInterrupted(Context context) {
        boolean bl;
        boolean bl2 = bl = context == null || this.holder.contains(context);
        if (bl) {
            this.shutdown = true;
        }
        return bl;
    }

    private void checkInterrupt() {
        if (this.shutdown) {
            throw new ShutdownException();
        }
    }

    public void setLocaleFinder(LocaleFinder localeFinder) {
        this.finder = localeFinder;
    }

    public void setMessageLocale(String string) throws StandardException {
        this.messageLocale = Monitor.getLocaleFromString(string);
    }

    public Locale getMessageLocale() {
        if (this.messageLocale != null) {
            return this.messageLocale;
        }
        if (this.finder != null) {
            try {
                return this.finder.getCurrentLocale();
            }
            catch (StandardException standardException) {
                // empty catch block
            }
        }
        return Locale.getDefault();
    }

    private void flushErrorString() {
        this.errorStream.print(this.errorStringBuilder.get().toString());
        this.errorStream.flush();
        this.errorStringBuilder.reset();
    }

    private boolean reportError(Throwable throwable) {
        if (throwable instanceof StandardException) {
            StandardException standardException = (StandardException)throwable;
            switch (standardException.report()) {
                case 0: {
                    int n = standardException.getSeverity();
                    return n >= this.logSeverityLevel || n == 0;
                }
                case 1: {
                    return false;
                }
            }
            return true;
        }
        return !(throwable instanceof ShutdownException);
    }

    ContextManager(ContextService contextService, HeaderPrintWriter headerPrintWriter) {
        this.errorStream = headerPrintWriter;
        this.ctxTable = new Hashtable();
        this.owningCsf = contextService;
        this.logSeverityLevel = PropertyUtil.getSystemInt("derby.stream.error.logSeverityLevel", 40000);
        this.holder = new Stack();
    }
}

