/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.loader;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.ClassFactory;

public final class ClassInspector {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1998, 2004.";
    private static final String[] primTypeNames = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double"};
    private static final String[] nonPrimTypeNames = new String[]{"java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double"};
    private final ClassFactory cf;
    private static /* synthetic */ Class class$Ljava$lang$Object;

    public boolean instanceOf(String string, Object object) throws ClassNotFoundException {
        Class clazz = this.getClass(string);
        if (clazz == null) {
            return false;
        }
        return clazz.isInstance(object);
    }

    public boolean assignableTo(String string, String string2) {
        try {
            Class clazz = this.getClass(string2);
            if (clazz == null) {
                return false;
            }
            Class clazz2 = this.getClass(string);
            if (clazz2 == null) {
                return !clazz.isPrimitive() || clazz == Void.TYPE;
            }
            return clazz.isAssignableFrom(clazz2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public boolean accessible(String string) throws ClassNotFoundException {
        Class clazz = this.getClass(string);
        if (clazz == null) {
            return false;
        }
        return Modifier.isPublic(clazz.getModifiers());
    }

    public String getType(Member member) {
        Class<Object> clazz = member instanceof Method ? ((Method)member).getReturnType() : (member instanceof Field ? ((Field)member).getType() : (member instanceof Constructor ? ((Constructor)member).getDeclaringClass() : Void.TYPE));
        return ClassInspector.readableClassName(clazz);
    }

    public Member findPublicMethod(String string, String string2, String[] stringArray, String[] stringArray2, boolean[] blArray, boolean bl, boolean bl2) throws ClassNotFoundException, StandardException {
        Class[] classArray;
        Class[] classArray2;
        Class clazz;
        block15: {
            clazz = this.getClass(string);
            if (clazz == null) {
                return null;
            }
            if (clazz.isPrimitive()) {
                return null;
            }
            if (stringArray == null) {
                Method[] methodArray = clazz.getMethods();
                int n = 0;
                while (n < methodArray.length) {
                    if ((!bl || Modifier.isStatic(methodArray[n].getModifiers())) && string2.equals(methodArray[n].getName())) {
                        return methodArray[n];
                    }
                    ++n;
                }
                return null;
            }
            classArray2 = new Class[stringArray.length];
            classArray = null;
            if (stringArray2 != null) {
                classArray = new Class[stringArray2.length];
            }
            int n = 0;
            while (n < classArray2.length) {
                classArray2[n] = this.getClass(stringArray[n]);
                if (stringArray2 != null) {
                    classArray[n] = stringArray2[n].equals(stringArray[n]) ? null : this.getClass(stringArray2[n]);
                }
                ++n;
            }
            if (classArray2.length == 0) {
                try {
                    Method method = clazz.getMethod(string2, classArray2);
                    if (bl && !Modifier.isStatic(method.getModifiers())) {
                        return null;
                    }
                    return method;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (clazz.isInterface()) break block15;
                    return null;
                }
            }
        }
        Member[] memberArray = clazz.getMethods();
        if (clazz.isInterface()) {
            Method[] methodArray = (class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = ClassInspector.class$("java.lang.Object"))).getMethods();
            if (memberArray.length == 0) {
                memberArray = methodArray;
            } else {
                Member[] memberArray2 = new Member[memberArray.length + methodArray.length];
                System.arraycopy(memberArray, 0, memberArray2, 0, memberArray.length);
                System.arraycopy(methodArray, 0, memberArray2, memberArray.length, methodArray.length);
                memberArray = memberArray2;
            }
        }
        return this.resolveMethod(clazz, string2, classArray2, classArray, blArray, bl, bl2, memberArray);
    }

    public Member findPublicField(String string, String string2, boolean bl) throws StandardException {
        Exception exception;
        block9: {
            exception = null;
            try {
                Class clazz = this.getClass(string);
                if (clazz == null) {
                    return null;
                }
                if (clazz.isArray() || clazz.isPrimitive()) {
                    return null;
                }
                int n = bl ? 9 : 1;
                Field field = clazz.getField(string2);
                if ((field.getModifiers() & n) != n) break block9;
                if (clazz.isInterface() || field.getDeclaringClass().equals(clazz)) {
                    return field;
                }
                try {
                    Field field2 = clazz.getDeclaredField(string2);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    return field;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                exception = classNotFoundException;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                exception = noSuchFieldException;
            }
            catch (SecurityException securityException) {
                exception = securityException;
            }
        }
        throw StandardException.newException(bl ? "42X72" : "42X68", exception, (Object)string2, (Object)string);
    }

    public Member findPublicConstructor(String string, String[] stringArray, String[] stringArray2, boolean[] blArray) throws ClassNotFoundException, StandardException {
        Class[] classArray;
        Class[] classArray2;
        Class clazz;
        block9: {
            clazz = this.getClass(string);
            if (clazz == null) {
                return null;
            }
            if (clazz.isArray() || clazz.isPrimitive() || clazz.isInterface()) {
                return null;
            }
            classArray2 = new Class[stringArray.length];
            classArray = null;
            if (stringArray2 != null) {
                classArray = new Class[stringArray2.length];
            }
            boolean bl = false;
            int n = 0;
            while (n < classArray2.length) {
                classArray2[n] = this.getClass(stringArray[n]);
                if (classArray2[n] == null) {
                    bl = true;
                }
                if (stringArray2 != null) {
                    classArray[n] = stringArray2[n].equals(stringArray[n]) ? null : this.getClass(stringArray2[n]);
                }
                ++n;
            }
            try {
                if (!bl && stringArray2 == null) {
                    Constructor constructor = clazz.getConstructor(classArray2);
                    return constructor;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (classArray2.length != 0) break block9;
                return null;
            }
        }
        return this.resolveMethod(clazz, "<init>", classArray2, classArray, blArray, false, false, clazz.getConstructors());
    }

    public String[] getParameterTypes(Member member) {
        Class<?>[] classArray = member instanceof Method ? ((Method)member).getParameterTypes() : ((Constructor)member).getParameterTypes();
        String[] stringArray = new String[classArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = ClassInspector.readableClassName(classArray[n]);
            ++n;
        }
        return stringArray;
    }

    public static boolean primitiveType(String string) {
        int n = 0;
        while (n < primTypeNames.length) {
            if (string.equals(primTypeNames[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private Member resolveMethod(Class var1_1, String var2_2, Class[] var3_3, Class[] var4_4, boolean[] var5_5, boolean var6_6, boolean var7_7, Member[] var8_8) throws StandardException {
        var9_9 = -1;
        var10_10 = true;
        do {
            var11_11 = false;
            var12_12 = false;
            var13_13 = 0;
            while (var13_13 < var8_8.length) {
                block24: {
                    block25: {
                        var14_15 = var8_8[var13_13];
                        if (var14_15 == null || var13_13 == var9_9) break block24;
                        v0 = var15_17 = var14_15 instanceof Method != false ? ((Method)var14_15).getParameterTypes() : ((Constructor)var14_15).getParameterTypes();
                        if (!var10_10) ** GOTO lbl34
                        if (!var7_7) break block25;
                        if (var15_17.length >= var3_3.length) ** GOTO lbl-1000
                        var8_8[var13_13] = null;
                        break block24;
                    }
                    if (var15_17.length != var3_3.length) {
                        var8_8[var13_13] = null;
                    } else if (var6_6 && !Modifier.isStatic(var14_15.getModifiers())) {
                        var8_8[var13_13] = null;
                    } else if (!var2_2.startsWith("<") && !var2_2.equals(var14_15.getName())) {
                        var8_8[var13_13] = null;
                    } else {
                        if (var7_7) {
                            var16_18 = var3_3.length - 1;
                            while (var16_18 < var15_17.length) {
                                if (!var15_17[var16_18].equals(var3_3[var3_3.length - 1])) {
                                    var8_8[var13_13] = null;
                                    break block24;
                                }
                                ++var16_18;
                            }
                        }
lbl34:
                        // 4 sources

                        if (!this.signatureConvertableFromTo(var3_3, var4_4, var15_17, var5_5, false)) {
                            var8_8[var13_13] = null;
                        } else if (var9_9 == -1) {
                            var9_9 = var13_13;
                        } else {
                            var16_19 = var8_8[var9_9];
                            var17_20 = this.isMethodMoreSpecificOrEqual(var16_19, var14_15, var5_5);
                            var18_21 = this.isMethodMoreSpecificOrEqual(var14_15, var16_19, var5_5);
                            if (var17_20 && !var18_21) {
                                var8_8[var13_13] = null;
                            } else if (var18_21 && !var17_20) {
                                var8_8[var9_9] = null;
                                var9_9 = var13_13;
                                var12_12 = true;
                            } else {
                                var11_11 = true;
                            }
                        }
                    }
                }
                ++var13_13;
            }
            var10_10 = false;
        } while (var11_11 && var12_12);
        if (var11_11) {
            var13_14 = "";
            var14_16 = 0;
            while (var14_16 < var3_3.length) {
                if (var14_16 != 0) {
                    var13_14 = var13_14 + ", ";
                }
                var13_14 = var13_14 + (var3_3[var14_16] == null ? "null" : var3_3[var14_16].getName());
                if (var4_4 != null && var4_4[var14_16] != null) {
                    var13_14 = var13_14 + "(" + var4_4[var14_16].getName() + ")";
                }
                ++var14_16;
            }
            throw StandardException.newException("42X73", var1_1.getName(), (Object)var2_2, (Object)var13_14);
        }
        if (var9_9 == -1) {
            return null;
        }
        return var8_8[var9_9];
    }

    public Class getClass(String string) throws ClassNotFoundException {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = 0;
        int n2 = string.length();
        int n3 = n2 - 2;
        while (n3 >= 0 && string.substring(n3, n3 + 2).equals("[]")) {
            ++n;
            n3 -= 2;
            n2 -= 2;
        }
        if (n2 <= 0) {
            return Class.forName(string);
        }
        if (n != 0) {
            string = string.substring(0, n2);
        }
        Class<Object> clazz = null;
        if (n2 >= 3 && n2 <= 7) {
            if ("int".equals(string)) {
                clazz = Integer.TYPE;
            } else if ("short".equals(string)) {
                clazz = Short.TYPE;
            } else if ("boolean".equals(string)) {
                clazz = Boolean.TYPE;
            } else if ("byte".equals(string)) {
                clazz = Byte.TYPE;
            } else if ("float".equals(string)) {
                clazz = Float.TYPE;
            } else if ("double".equals(string)) {
                clazz = Double.TYPE;
            } else if ("long".equals(string)) {
                clazz = Long.TYPE;
            } else if ("char".equals(string)) {
                clazz = Character.TYPE;
            } else if ("void".equals(string)) {
                clazz = Void.TYPE;
            }
        }
        if (clazz == null) {
            clazz = this.cf.loadApplicationClass(string);
        }
        if (n == 0) {
            return clazz;
        }
        if (n == 1) {
            return Array.newInstance(clazz, 0).getClass();
        }
        return Array.newInstance(clazz, new int[n]).getClass();
    }

    private boolean isMethodMoreSpecificOrEqual(Member member, Member member2, boolean[] blArray) {
        Class[] classArray;
        Class[] classArray2;
        if (member instanceof Method) {
            if (!this.classConvertableFromTo(member.getDeclaringClass(), member2.getDeclaringClass(), true)) {
                return false;
            }
            classArray2 = ((Method)member).getParameterTypes();
            classArray = ((Method)member2).getParameterTypes();
        } else {
            classArray2 = ((Constructor)member).getParameterTypes();
            classArray = ((Constructor)member2).getParameterTypes();
        }
        return this.signatureConvertableFromTo(classArray2, null, classArray, blArray, true);
    }

    private boolean signatureConvertableFromTo(Class[] classArray, Class[] classArray2, Class[] classArray3, boolean[] blArray, boolean bl) {
        int n = classArray.length;
        if (classArray3.length < n) {
            n = classArray3.length;
        }
        int n2 = 0;
        while (n2 < n) {
            Class clazz = classArray[n2];
            Class clazz2 = classArray3[n2];
            if (clazz == null ? clazz2.isPrimitive() && (classArray2 == null || blArray != null && !blArray[n2]) : !this.classConvertableFromTo(clazz, clazz2, bl) && (classArray2 == null || classArray2[n2] == null || !this.classConvertableFromTo(classArray2[n2], clazz2, bl))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected boolean classConvertableFromTo(Class clazz, Class clazz2, boolean bl) {
        if (clazz2.isAssignableFrom(clazz)) {
            return true;
        }
        if (!(clazz2.isPrimitive() && clazz.isPrimitive() || bl)) {
            return false;
        }
        String string = clazz.getName();
        String string2 = clazz2.getName();
        return clazz == Boolean.TYPE || string.equals(nonPrimTypeNames[0]) ? clazz2 == Boolean.TYPE || string2.equals(nonPrimTypeNames[0]) : (clazz == Byte.TYPE || string.equals(nonPrimTypeNames[1]) ? clazz2 == Byte.TYPE || string2.equals(nonPrimTypeNames[1]) || clazz2 == Short.TYPE || clazz2 == Integer.TYPE || clazz2 == Long.TYPE || clazz2 == Float.TYPE || clazz2 == Double.TYPE : (clazz == Character.TYPE || string.equals(nonPrimTypeNames[2]) ? clazz2 == Character.TYPE || string2.equals(nonPrimTypeNames[2]) || clazz2 == Integer.TYPE || clazz2 == Long.TYPE || clazz2 == Float.TYPE || clazz2 == Double.TYPE : (clazz == Short.TYPE || string.equals(nonPrimTypeNames[3]) ? clazz2 == Short.TYPE || string2.equals(nonPrimTypeNames[3]) || clazz2 == Integer.TYPE || clazz2 == Long.TYPE || clazz2 == Float.TYPE || clazz2 == Double.TYPE : (clazz == Integer.TYPE || string.equals(nonPrimTypeNames[4]) ? clazz2 == Integer.TYPE || string2.equals(nonPrimTypeNames[4]) || clazz2 == Long.TYPE || clazz2 == Float.TYPE || clazz2 == Double.TYPE : (clazz == Long.TYPE || string.equals(nonPrimTypeNames[5]) ? clazz2 == Long.TYPE || string2.equals(nonPrimTypeNames[5]) || clazz2 == Float.TYPE || clazz2 == Double.TYPE : (clazz == Float.TYPE || string.equals(nonPrimTypeNames[6]) ? clazz2 == Float.TYPE || string2.equals(nonPrimTypeNames[6]) || clazz2 == Double.TYPE : !(clazz != Double.TYPE && !string.equals(nonPrimTypeNames[7]) || clazz2 != Double.TYPE && !string2.equals(nonPrimTypeNames[7]))))))));
    }

    public static String readableClassName(Class clazz) {
        if (!clazz.isArray()) {
            return clazz.getName();
        }
        int n = 0;
        do {
            ++n;
        } while ((clazz = clazz.getComponentType()).isArray());
        StringBuffer stringBuffer = new StringBuffer(clazz.getName());
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("[]");
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String getDeclaringClass(Member member) {
        return member.getDeclaringClass().getName();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ClassInspector(ClassFactory classFactory) {
        this.cf = classFactory;
    }
}

