/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLBit;
import org.apache.derby.iapi.util.StringUtil;

public class SQLVarbit
extends SQLBit {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1999, 2004.";

    public String getTypeName() {
        return "VARCHAR () FOR BIT DATA";
    }

    public DataValueDescriptor getNewNull() {
        return new SQLVarbit();
    }

    public int getTypeFormatId() {
        return 88;
    }

    public void normalize(DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor) throws StandardException {
        int n = dataTypeDescriptor.getMaximumWidth();
        byte[] byArray = dataValueDescriptor.getBytes();
        this.setValue(byArray);
        if (byArray.length > n) {
            this.setWidth(n, 0, true);
        }
    }

    public DataValueDescriptor setWidth(int n, int n2, boolean bl) throws StandardException {
        if (this.getValue() == null) {
            return this;
        }
        int n3 = this.dataValue.length;
        if (n3 > n) {
            if (bl) {
                int n4 = n;
                while (n4 < this.dataValue.length) {
                    if (this.dataValue[n4] != 32) {
                        throw StandardException.newException("22001", this.getTypeName(), (Object)StringUtil.formatForPrint(this.toString()), (Object)String.valueOf(n));
                    }
                    ++n4;
                }
            }
            byte[] byArray = new byte[n];
            System.arraycopy(this.dataValue, 0, byArray, 0, n);
            this.dataValue = byArray;
        }
        return this;
    }

    public int typePrecedence() {
        return 150;
    }

    public SQLVarbit() {
    }

    public SQLVarbit(byte[] byArray) {
        super(byArray);
    }
}

