/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedPreparedStatement;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.Util;

public abstract class EmbedCallableStatement
extends EmbedPreparedStatement
implements CallableStatement {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private boolean hasReturnOutputParameter;
    protected boolean wasNull;

    protected void checkRequiresCallableStatement(Activation activation) {
    }

    protected final boolean executeStatement(Activation activation, boolean bl, boolean bl2) throws SQLException {
        this.checkExecStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.wasNull = false;
            ParameterValueSet parameterValueSet = this.getParms();
            try {
                parameterValueSet.validate();
            }
            catch (StandardException standardException) {
                throw EmbedResultSet.noStateChangeException(standardException);
            }
            boolean bl3 = super.executeStatement(activation, bl, bl2 && !this.hasReturnOutputParameter);
            if (this.hasReturnOutputParameter) {
                boolean bl4 = this.results.next();
                try {
                    try {
                        parameterValueSet.setReturnValue(this.results.getObject(1));
                    }
                    catch (StandardException standardException) {
                        throw EmbedResultSet.noStateChangeException(standardException);
                    }
                    Object var11_9 = null;
                    this.results = null;
                }
                catch (Throwable throwable) {
                    Object var11_10 = null;
                    this.results = null;
                    throw throwable;
                }
                bl3 = false;
            }
            boolean bl5 = bl3;
            Object var5_14 = null;
            return bl5;
        }
    }

    public final void registerOutParameter(int n, int n2) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().registerOutParameter(n - 1, n2, -1);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final void registerOutParameter(int n, int n2, int n3) throws SQLException {
        this.checkStatus();
        if (n3 < 0) {
            throw this.newSQLException("XJ044.S", new Integer(n3));
        }
        try {
            this.getParms().registerOutParameter(n - 1, n2, n3);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        throw Util.notImplemented("registerOutParameter");
    }

    public boolean wasNull() throws SQLException {
        this.checkStatus();
        return this.wasNull;
    }

    public String getString(int n) throws SQLException {
        this.checkStatus();
        try {
            String string = this.getParms().getParameterForGet(n - 1).getString();
            this.wasNull = string == null;
            return string;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public boolean getBoolean(int n) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor dataValueDescriptor = this.getParms().getParameterForGet(n - 1);
            boolean bl = dataValueDescriptor.getBoolean();
            this.wasNull = !bl && dataValueDescriptor.isNull();
            return bl;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public byte getByte(int n) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor dataValueDescriptor = this.getParms().getParameterForGet(n - 1);
            byte by = dataValueDescriptor.getByte();
            this.wasNull = by == 0 && dataValueDescriptor.isNull();
            return by;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public short getShort(int n) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor dataValueDescriptor = this.getParms().getParameterForGet(n - 1);
            short s = dataValueDescriptor.getShort();
            this.wasNull = s == 0 && dataValueDescriptor.isNull();
            return s;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public int getInt(int n) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor dataValueDescriptor = this.getParms().getParameterForGet(n - 1);
            int n2 = dataValueDescriptor.getInt();
            this.wasNull = n2 == 0 && dataValueDescriptor.isNull();
            return n2;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public long getLong(int n) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor dataValueDescriptor = this.getParms().getParameterForGet(n - 1);
            long l = dataValueDescriptor.getLong();
            this.wasNull = l == 0L && dataValueDescriptor.isNull();
            return l;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public float getFloat(int n) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor dataValueDescriptor = this.getParms().getParameterForGet(n - 1);
            float f = dataValueDescriptor.getFloat();
            this.wasNull = (double)f == 0.0 && dataValueDescriptor.isNull();
            return f;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public double getDouble(int n) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor dataValueDescriptor = this.getParms().getParameterForGet(n - 1);
            double d = dataValueDescriptor.getDouble();
            this.wasNull = d == 0.0 && dataValueDescriptor.isNull();
            return d;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.checkStatus();
        try {
            BigDecimal bigDecimal = this.getParms().getParameterForGet(n - 1).getBigDecimal();
            this.wasNull = bigDecimal == null;
            return bigDecimal;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public byte[] getBytes(int n) throws SQLException {
        this.checkStatus();
        try {
            byte[] byArray = this.getParms().getParameterForGet(n - 1).getBytes();
            this.wasNull = byArray == null;
            return byArray;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public Date getDate(int n) throws SQLException {
        this.checkStatus();
        try {
            Date date = this.getParms().getParameterForGet(n - 1).getDate(this.getCal());
            this.wasNull = date == null;
            return date;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public Time getTime(int n) throws SQLException {
        this.checkStatus();
        try {
            Time time = this.getParms().getParameterForGet(n - 1).getTime(this.getCal());
            this.wasNull = time == null;
            return time;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        this.checkStatus();
        try {
            Timestamp timestamp = this.getParms().getParameterForGet(n - 1).getTimestamp(this.getCal());
            this.wasNull = timestamp == null;
            return timestamp;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public Object getObject(int n) throws SQLException {
        this.checkStatus();
        try {
            Object object = this.getParms().getObject(n - 1);
            this.wasNull = object == null;
            return object;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void addBatch() throws SQLException {
        this.checkStatus();
        ParameterValueSet parameterValueSet = this.getParms();
        int n = parameterValueSet.getParameterCount();
        int n2 = 1;
        while (n2 <= n) {
            switch (parameterValueSet.getParameterMode(n2)) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: 
                case 4: {
                    throw this.newSQLException("XJ04C.S");
                }
            }
            ++n2;
        }
        super.addBatch();
    }

    public abstract void setRef(int var1, Ref var2) throws SQLException;

    public abstract void setBlob(int var1, Blob var2) throws SQLException;

    public abstract void setClob(int var1, Clob var2) throws SQLException;

    public abstract void setArray(int var1, Array var2) throws SQLException;

    public abstract BigDecimal getBigDecimal(int var1) throws SQLException;

    public abstract Object getObject(int var1, Map var2) throws SQLException;

    public abstract Ref getRef(int var1) throws SQLException;

    public abstract Blob getBlob(int var1) throws SQLException;

    public abstract Clob getClob(int var1) throws SQLException;

    public abstract Array getArray(int var1) throws SQLException;

    public abstract Date getDate(int var1, Calendar var2) throws SQLException;

    public abstract Time getTime(int var1, Calendar var2) throws SQLException;

    public abstract Timestamp getTimestamp(int var1, Calendar var2) throws SQLException;

    public EmbedCallableStatement(EmbedConnection embedConnection, String string, int n, int n2, int n3) throws SQLException {
        super(embedConnection, string, false, n, n2, n3, 2, null, null);
        ParameterValueSet parameterValueSet = this.getParms();
        this.hasReturnOutputParameter = parameterValueSet.hasReturnOutputParameter();
    }
}

