/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.ConnectionContext;
import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.Util;

public class EmbedConnectionContext
extends ContextImpl
implements ConnectionContext {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private SoftReference connRef;

    public void cleanupOnError(Throwable throwable) {
        StandardException standardException;
        if (this.connRef == null) {
            return;
        }
        EmbedConnection embedConnection = (EmbedConnection)this.connRef.get();
        if (throwable instanceof StandardException && (standardException = (StandardException)throwable).getSeverity() < 40000) {
            if (embedConnection != null) {
                embedConnection.needCommit = false;
            }
            return;
        }
        if (embedConnection != null) {
            embedConnection.setInactive();
        }
        this.connRef = null;
        this.popMe();
    }

    public Connection getNestedConnection(boolean bl) throws SQLException {
        StatementContext statementContext;
        EmbedConnection embedConnection = (EmbedConnection)this.connRef.get();
        if (embedConnection == null || embedConnection.isClosed()) {
            throw Util.noCurrentConnection();
        }
        if (!(bl || (statementContext = embedConnection.getLanguageConnection().getStatementContext()) != null && statementContext.getSQLAllowed() >= 0)) {
            throw Util.noCurrentConnection();
        }
        return embedConnection.getLocalDriver().getNewNestedConnection(embedConnection);
    }

    public ResultSet getResultSet(org.apache.derby.iapi.sql.ResultSet resultSet) {
        EmbedConnection embedConnection = (EmbedConnection)this.connRef.get();
        EmbedResultSet embedResultSet = embedConnection.getLocalDriver().newEmbedResultSet(embedConnection, resultSet, false, null, true);
        return embedResultSet;
    }

    EmbedConnectionContext(ContextManager contextManager, EmbedConnection embedConnection) {
        super(contextManager, "JDBC_ConnectionContext");
        this.connRef = new SoftReference<EmbedConnection>(embedConnection);
    }
}

