/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UTFDataFormatException;
import java.sql.SQLException;
import org.apache.derby.impl.jdbc.ConnectionChild;

public final class UTF8Reader
extends Reader {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 2004.";
    private InputStream in;
    private final long utfLen;
    private long utfCount;
    private long readerCharCount;
    private long maxFieldSize;
    private char[] buffer = new char[8192];
    private int charactersInBuffer;
    private int readPositionInBuffer;
    private boolean noMoreReads;
    private ConnectionChild parent;

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.noMoreReads) {
                throw new IOException();
            }
            if (this.readPositionInBuffer >= this.charactersInBuffer) {
                if (this.fillBuffer()) {
                    int n = -1;
                    Object var2_4 = null;
                    return n;
                }
                this.readPositionInBuffer = 0;
            }
            char c = this.buffer[this.readPositionInBuffer++];
            Object var2_5 = null;
            return c;
        }
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n3;
            if (this.noMoreReads) {
                throw new IOException();
            }
            if (this.readPositionInBuffer >= this.charactersInBuffer) {
                if (this.fillBuffer()) {
                    int n4 = -1;
                    Object var5_7 = null;
                    return n4;
                }
                this.readPositionInBuffer = 0;
            }
            if (n2 > (n3 = this.charactersInBuffer - this.readPositionInBuffer)) {
                n2 = n3;
            }
            System.arraycopy(this.buffer, this.readPositionInBuffer, cArray, n, n2);
            this.readPositionInBuffer += n2;
            int n5 = n2;
            Object var5_8 = null;
            return n5;
        }
    }

    public long skip(long l) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n;
            if (this.noMoreReads) {
                throw new IOException();
            }
            if (this.readPositionInBuffer >= this.charactersInBuffer) {
                if (this.fillBuffer()) {
                    long l2 = -1L;
                    Object var4_5 = null;
                    return l2;
                }
                this.readPositionInBuffer = 0;
            }
            if (l > (long)(n = this.charactersInBuffer - this.readPositionInBuffer)) {
                l = n;
            }
            this.readPositionInBuffer = (int)((long)this.readPositionInBuffer + l);
            long l3 = l;
            Object var4_6 = null;
            return l3;
        }
    }

    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.closeIn();
            this.parent = null;
            this.noMoreReads = true;
        }
    }

    public int readInto(StringBuffer stringBuffer, int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n2;
            if (this.readPositionInBuffer >= this.charactersInBuffer) {
                if (this.fillBuffer()) {
                    int n3 = -1;
                    Object var4_6 = null;
                    return n3;
                }
                this.readPositionInBuffer = 0;
            }
            if (n > (n2 = this.charactersInBuffer - this.readPositionInBuffer)) {
                n = n2;
            }
            stringBuffer.append(this.buffer, this.readPositionInBuffer, n);
            this.readPositionInBuffer += n;
            int n4 = n;
            Object var4_7 = null;
            return n4;
        }
    }

    int readAsciiInto(byte[] byArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n3;
            if (this.readPositionInBuffer >= this.charactersInBuffer) {
                if (this.fillBuffer()) {
                    int n4 = -1;
                    Object var5_7 = null;
                    return n4;
                }
                this.readPositionInBuffer = 0;
            }
            if (n2 > (n3 = this.charactersInBuffer - this.readPositionInBuffer)) {
                n2 = n3;
            }
            char[] cArray = this.buffer;
            int n5 = 0;
            while (n5 < n2) {
                char c = cArray[this.readPositionInBuffer + n5];
                int n6 = c <= '\u00ff' ? (int)((byte)c) : 63;
                byArray[n + n5] = n6;
                ++n5;
            }
            this.readPositionInBuffer += n2;
            int n7 = n2;
            Object var5_8 = null;
            return n7;
        }
    }

    private void closeIn() {
        if (this.in != null) {
            try {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {
                    Object var2_2 = null;
                    this.in = null;
                }
                Object var2_1 = null;
                this.in = null;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.in = null;
                throw throwable;
            }
        }
    }

    private IOException utfFormatException(String string) {
        this.noMoreReads = true;
        this.closeIn();
        return new UTFDataFormatException(string);
    }

    private IOException utfFormatException() {
        this.noMoreReads = true;
        this.closeIn();
        return new UTFDataFormatException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean fillBuffer() throws IOException {
        if (this.in == null) {
            return true;
        }
        this.charactersInBuffer = 0;
        try {
            boolean bl;
            block22: {
                boolean bl2;
                block21: {
                    try {
                        this.parent.setupContextStack();
                        block9: while (!(this.charactersInBuffer >= this.buffer.length || this.utfCount >= this.utfLen && this.utfLen != 0L || this.maxFieldSize != 0L && this.readerCharCount >= this.maxFieldSize)) {
                            int n;
                            int n2 = this.in.read();
                            if (n2 == -1) {
                                if (this.utfLen != 0L) {
                                    throw this.utfFormatException();
                                }
                                this.closeIn();
                                break;
                            }
                            switch (n2 >> 4) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: {
                                    ++this.utfCount;
                                    n = n2;
                                    break;
                                }
                                case 12: 
                                case 13: {
                                    this.utfCount += 2L;
                                    int n3 = this.in.read();
                                    if (n3 == -1) {
                                        throw this.utfFormatException();
                                    }
                                    if ((n3 & 0xC0) != 128) {
                                        throw this.utfFormatException();
                                    }
                                    n = (n2 & 0x1F) << 6 | n3 & 0x3F;
                                    break;
                                }
                                case 14: {
                                    this.utfCount += 3L;
                                    int n3 = this.in.read();
                                    int n4 = this.in.read();
                                    if (n3 == -1 || n4 == -1) {
                                        throw this.utfFormatException();
                                    }
                                    if (n2 == 224 && n3 == 0 && n4 == 0) {
                                        if (this.utfLen != 0L) {
                                            throw this.utfFormatException();
                                        }
                                        this.closeIn();
                                        break block9;
                                    }
                                    if ((n3 & 0xC0) != 128 || (n4 & 0xC0) != 128) {
                                        throw this.utfFormatException();
                                    }
                                    n = (n2 & 0xF) << 12 | (n3 & 0x3F) << 6 | n4 & 0x3F;
                                    break;
                                }
                                default: {
                                    throw this.utfFormatException();
                                }
                            }
                            this.buffer[this.charactersInBuffer++] = (char)n;
                            ++this.readerCharCount;
                        }
                        if (this.utfLen != 0L && this.utfCount > this.utfLen) {
                            throw this.utfFormatException("utfCount " + this.utfCount + " utfLen " + this.utfLen);
                        }
                        if (this.charactersInBuffer != 0) {
                            bl2 = false;
                            Object var2_7 = null;
                            break block21;
                        }
                        this.closeIn();
                        bl = true;
                        break block22;
                    }
                    catch (Throwable throwable) {
                        Object var2_9 = null;
                        this.parent.restoreContextStack();
                        throw throwable;
                    }
                }
                this.parent.restoreContextStack();
                return bl2;
            }
            Object var2_8 = null;
            this.parent.restoreContextStack();
            return bl;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getSQLState() + ":" + sQLException.getMessage());
        }
    }

    private final int readUnsignedShort() throws IOException {
        int n;
        int n2 = this.in.read();
        if ((n2 | (n = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + n;
    }

    public UTF8Reader(InputStream inputStream, long l, ConnectionChild connectionChild, Object object) throws IOException {
        super(object);
        this.in = inputStream;
        this.maxFieldSize = l;
        this.parent = connectionChild;
        Object object2 = this.lock;
        synchronized (object2) {
            this.utfLen = this.readUnsignedShort();
        }
    }
}

