/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.reflect;

import java.io.InputStream;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.loader.ClassFactoryContext;
import org.apache.derby.iapi.services.loader.JarReader;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.locks.ShExLockable;
import org.apache.derby.iapi.services.locks.ShExQual;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PersistentSet;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.services.reflect.ClassLoaderLock;
import org.apache.derby.impl.services.reflect.DatabaseClasses;
import org.apache.derby.impl.services.reflect.JarFile;
import org.apache.derby.impl.services.reflect.JarLoader;

public class UpdateLoader {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1998, 2004.";
    private JarLoader[] jarList;
    private HeaderPrintWriter vs;
    private final ClassLoader myLoader;
    private boolean initDone;
    private String thisClasspath;
    private final LockFactory lf;
    private final ShExLockable classLoaderLock;
    private int version;
    private boolean normalizeToUpper;
    private DatabaseClasses parent;
    private boolean needReload;
    private JarReader jarReader;

    private void initializeFromClassPath(String string) throws StandardException {
        String[][] stringArray = IdUtil.parseDbClassPath(string, this.normalizeToUpper);
        int n = stringArray.length;
        this.jarList = new JarLoader[n];
        int n2 = 0;
        while (n2 < n) {
            this.jarList[n2] = new JarLoader(this, stringArray[n2], this.vs);
            ++n2;
        }
        if (this.vs != null) {
            this.vs.println(MessageService.getTextMessage("C005", string));
        }
        this.thisClasspath = string;
        this.initDone = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        JarLoader jarLoader = null;
        boolean bl2 = false;
        try {
            try {
                bl2 = this.lockClassLoader(ShExQual.SH);
                UpdateLoader updateLoader = this;
                synchronized (updateLoader) {
                    Class clazz;
                    if (this.needReload) {
                        this.reload();
                    }
                    if ((clazz = this.checkLoaded(string, bl)) != null) {
                        Class clazz2 = clazz;
                        Object var9_10 = null;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3, 12] lbl15 : MonitorExitStatement: MONITOREXIT : var8_5
                        Class clazz3 = clazz2;
                        Object var6_15 = null;
                        if (!bl2) return clazz3;
                        this.lf.unlock(this, this, this.classLoaderLock, ShExQual.SH);
                        return clazz3;
                    }
                    String string2 = string.replace('.', '/').concat(".class");
                    if (!this.initDone) {
                        this.initLoaders();
                    }
                    int n = 0;
                    while (n < this.jarList.length) {
                        jarLoader = this.jarList[n];
                        Class clazz4 = jarLoader.loadClassData(string, string2, bl);
                        if (clazz4 != null) {
                            if (this.vs != null) {
                                this.vs.println(MessageService.getTextMessage("C006", string, jarLoader.getJarName()));
                            }
                            Class clazz5 = clazz4;
                            Object var9_11 = null;
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3, 7, 10] lbl39 : MonitorExitStatement: MONITOREXIT : var8_5
                            Class clazz6 = clazz5;
                            Object var6_16 = null;
                            if (!bl2) return clazz6;
                            this.lf.unlock(this, this, this.classLoaderLock, ShExQual.SH);
                            return clazz6;
                        }
                        ++n;
                    }
                }
                Class clazz = null;
                Object var6_17 = null;
                if (!bl2) return clazz;
                this.lf.unlock(this, this, this.classLoaderLock, ShExQual.SH);
                return clazz;
            }
            catch (StandardException standardException) {
                String string3;
                if (jarLoader == null) {
                    string3 = null;
                    throw new ClassNotFoundException(MessageService.getTextMessage("C007", string, string3, standardException));
                }
                string3 = jarLoader.getJarName();
                throw new ClassNotFoundException(MessageService.getTextMessage("C007", string, string3, standardException));
            }
        }
        catch (Throwable throwable) {
            Object var6_18 = null;
            if (!bl2) throw throwable;
            this.lf.unlock(this, this, this.classLoaderLock, ShExQual.SH);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getResourceAsStream(String string) {
        InputStream inputStream;
        InputStream inputStream2;
        InputStream inputStream3 = inputStream2 = this.myLoader == null ? ClassLoader.getSystemResourceAsStream(string) : this.myLoader.getResourceAsStream(string);
        if (inputStream2 != null) {
            return inputStream2;
        }
        if (string.endsWith(".class")) {
            return null;
        }
        boolean bl = false;
        try {
            try {
                block14: {
                    InputStream inputStream4;
                    bl = this.lockClassLoader(ShExQual.SH);
                    UpdateLoader updateLoader = this;
                    synchronized (updateLoader) {
                        if (this.needReload) {
                            this.reload();
                        }
                        if (!this.initDone) {
                            this.initLoaders();
                        }
                        int n = 0;
                        while (true) {
                            if (n >= this.jarList.length) {
                                break block14;
                            }
                            JarLoader jarLoader = this.jarList[n];
                            inputStream2 = jarLoader.getStream(string);
                            if (inputStream2 != null) {
                                inputStream4 = inputStream2;
                                Object var8_9 = null;
                                break;
                            }
                            ++n;
                        }
                    }
                    InputStream inputStream5 = inputStream4;
                    Object var5_13 = null;
                    if (!bl) return inputStream5;
                    this.lf.unlock(this, this, this.classLoaderLock, ShExQual.SH);
                    return inputStream5;
                }
                inputStream = null;
            }
            catch (StandardException standardException) {
                InputStream inputStream6 = null;
                Object var5_15 = null;
                if (!bl) return inputStream6;
                this.lf.unlock(this, this, this.classLoaderLock, ShExQual.SH);
                return inputStream6;
            }
        }
        catch (Throwable throwable) {
            Object var5_16 = null;
            if (!bl) throw throwable;
            this.lf.unlock(this, this, this.classLoaderLock, ShExQual.SH);
            throw throwable;
        }
        Object var5_14 = null;
        if (!bl) return inputStream;
        this.lf.unlock(this, this, this.classLoaderLock, ShExQual.SH);
        return inputStream;
    }

    public synchronized void modifyClasspath(String string) throws StandardException {
        this.lockClassLoader(ShExQual.EX);
        ++this.version;
        this.modifyJar(false);
        this.initializeFromClassPath(string);
    }

    public synchronized void modifyJar(boolean bl) throws StandardException {
        this.lockClassLoader(ShExQual.EX);
        ++this.version;
        if (!this.initDone) {
            return;
        }
        if (bl) {
            this.close();
            this.initializeFromClassPath(this.thisClasspath);
            return;
        }
        UpdateLoader updateLoader = this;
        synchronized (updateLoader) {
            int n = 0;
            while (n < this.jarList.length) {
                JarLoader jarLoader = this.jarList[n];
                JarFile jarFile = jarLoader.setInvalid(bl);
                ++n;
            }
        }
    }

    private boolean lockClassLoader(ShExQual shExQual) throws StandardException {
        if (this.lf == null) {
            return false;
        }
        ClassFactoryContext classFactoryContext = (ClassFactoryContext)ContextService.getContextOrNull("ClassFactoryContext");
        Object object = null;
        if (classFactoryContext != null) {
            object = classFactoryContext.getLockSpace();
        }
        if (object == null) {
            object = this;
        }
        this.lf.lockObject(object, object, this.classLoaderLock, shExQual, -2);
        return object == this;
    }

    Class checkLoaded(String string, boolean bl) {
        int n = 0;
        while (n < this.jarList.length) {
            Class clazz = this.jarList[n].checkLoaded(string, bl);
            if (clazz != null) {
                return clazz;
            }
            ++n;
        }
        return null;
    }

    public void close() {
        int n = 0;
        while (n < this.jarList.length) {
            this.jarList[n].setInvalid(false);
            ++n;
        }
    }

    private void initLoaders() {
        if (this.initDone) {
            return;
        }
        int n = 0;
        while (n < this.jarList.length) {
            this.jarList[n].initialize();
            ++n;
        }
        this.initDone = true;
    }

    public int getClassLoaderVersion() {
        return this.version;
    }

    synchronized void needReload() {
        ++this.version;
        this.needReload = true;
    }

    private void reload() throws StandardException {
        this.thisClasspath = this.getClasspath();
        this.close();
        this.initializeFromClassPath(this.thisClasspath);
        this.needReload = false;
    }

    private String getClasspath() throws StandardException {
        ClassFactoryContext classFactoryContext = (ClassFactoryContext)ContextService.getContextOrNull("ClassFactoryContext");
        PersistentSet persistentSet = classFactoryContext.getPersistentSet();
        String string = PropertyUtil.getServiceProperty(persistentSet, "derby.database.classpath");
        if (string == null) {
            string = "";
        }
        return string;
    }

    JarReader getJarReader() {
        if (this.jarReader == null) {
            ClassFactoryContext classFactoryContext = (ClassFactoryContext)ContextService.getContextOrNull("ClassFactoryContext");
            this.jarReader = classFactoryContext.getJarReader();
        }
        return this.jarReader;
    }

    public UpdateLoader(String string, DatabaseClasses databaseClasses, boolean bl, boolean bl2) throws StandardException {
        this.normalizeToUpper = bl2;
        this.parent = databaseClasses;
        this.lf = (LockFactory)Monitor.getServiceModule(databaseClasses, "org.apache.derby.iapi.services.locks.LockFactory");
        if (bl) {
            this.vs = Monitor.getStream();
        }
        this.myLoader = this.getClass().getClassLoader();
        this.classLoaderLock = new ClassLoaderLock(this);
        this.initializeFromClassPath(string);
    }
}

