/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.NodeFactory;
import org.apache.derby.iapi.sql.compile.Parser;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.GenericDescriptorList;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.CursorNode;
import org.apache.derby.impl.sql.compile.DMLStatementNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.TestConstraintNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.TriggerInfo;

public abstract class DMLModStatementNode
extends DMLStatementNode {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    protected FromVTI targetVTI;
    protected TableName targetTableName;
    protected ResultColumnList resultColumnList;
    protected int lockMode;
    protected FKInfo[] fkInfo;
    protected TriggerInfo triggerInfo;
    public TableDescriptor targetTableDescriptor;
    public IndexRowGenerator[] indicesToMaintain;
    public long[] indexConglomerateNumbers;
    public String[] indexNames;
    protected ConstraintDescriptorList relevantCdl;
    protected GenericDescriptorList relevantTriggers;
    private boolean requiresDeferredProcessing;
    private int statementType;
    private boolean bound;
    private ValueNode checkConstraints;
    protected String[] fkTableNames;
    protected int[] fkRefActions;
    protected ColumnDescriptorList[] fkColDescriptors;
    protected long[] fkIndexConglomNumbers;
    protected boolean isDependentTable;
    protected int[][] fkColArrays;
    protected Hashtable graphHashTable;

    public void init(Object object) {
        super.init(object);
        this.statementType = this.getStatementType();
    }

    public void init(Object object, Object object2) {
        super.init(object);
        this.statementType = (Integer)object2;
    }

    void setTarget(QueryTreeNode queryTreeNode) {
        if (queryTreeNode instanceof TableName) {
            this.targetTableName = (TableName)queryTreeNode;
        } else {
            this.targetVTI = (FromVTI)queryTreeNode;
            this.targetVTI.setTarget();
        }
    }

    protected void generateCodeForTemporaryTable(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        if (this.targetTableDescriptor != null && this.targetTableDescriptor.getTableType() == 3 && this.targetTableDescriptor.isOnRollbackDeleteRows()) {
            methodBuilder.pushThis();
            methodBuilder.callMethod((short)185, "org.apache.derby.iapi.sql.Activation", "getLanguageConnectionContext", "org.apache.derby.iapi.sql.conn.LanguageConnectionContext", 0);
            methodBuilder.push(this.targetTableDescriptor.getName());
            methodBuilder.callMethod((short)185, null, "markTempTableAsModifiedInUnitOfWork", "void", 1);
            methodBuilder.endStatement();
        }
    }

    void verifyTargetTable() throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        if (this.targetTableName != null) {
            String string = this.targetTableName.getSchemaName();
            SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor(string);
            this.targetTableDescriptor = this.getTableDescriptor(this.targetTableName.getTableName(), schemaDescriptor);
            if (this.targetTableDescriptor == null) {
                throw StandardException.newException("42X05", this.targetTableName);
            }
            if (this.targetTableDescriptor.getTableType() == 2) {
                throw StandardException.newException("42Y24", this.targetTableName);
            }
            if (this.targetTableDescriptor.getTableType() == 1) {
                throw StandardException.newException("42Y25", this.targetTableName);
            }
            this.targetTableDescriptor = this.lockTableForCompilation(this.targetTableDescriptor);
            this.getCompilerContext().createDependency(this.targetTableDescriptor);
        } else {
            FromList fromList = new FromList();
            this.targetVTI = (FromVTI)this.targetVTI.bindNonVTITables(dataDictionary, fromList);
            this.targetVTI = (FromVTI)this.targetVTI.bindVTITables(fromList);
        }
    }

    public boolean isAtomic() {
        return true;
    }

    public SchemaDescriptor getSchemaDescriptor() throws StandardException {
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor(this.targetTableName.getSchemaName());
        return schemaDescriptor;
    }

    public static int[] getReadColMap(int n, FormatableBitSet formatableBitSet) {
        if (formatableBitSet == null) {
            return null;
        }
        int n2 = 0;
        int[] nArray = new int[n];
        int n3 = formatableBitSet.size();
        int n4 = 0;
        while (n4 < nArray.length) {
            nArray[n4] = n3 > n4 && formatableBitSet.get(n4 + 1) ? n2++ : -1;
            ++n4;
        }
        return nArray;
    }

    protected void getResultColumnList() throws StandardException {
        if (this.targetVTI == null) {
            this.getResultColumnList(null);
        } else {
            this.resultColumnList = this.targetVTI.getResultColumns();
        }
    }

    protected FromBaseTable getResultColumnList(ResultColumnList resultColumnList) throws StandardException {
        FromBaseTable fromBaseTable = (FromBaseTable)this.getNodeFactory().getNode(135, this.targetTableName, null, null, null, this.getContextManager());
        fromBaseTable.bindNonVTITables(this.getDataDictionary(), (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()));
        this.getResultColumnList(fromBaseTable, resultColumnList);
        return fromBaseTable;
    }

    private void getResultColumnList(FromBaseTable fromBaseTable, ResultColumnList resultColumnList) throws StandardException {
        if (resultColumnList == null) {
            this.resultColumnList = fromBaseTable.getAllResultColumns(null);
            this.resultColumnList.bindResultColumnsByPosition(this.targetTableDescriptor);
        } else {
            this.resultColumnList = fromBaseTable.getResultColumnsForList(null, resultColumnList, fromBaseTable.getTableNameField());
            this.resultColumnList.bindResultColumnsByName(this.targetTableDescriptor, this);
        }
    }

    public ValueNode bindConstraints(DataDictionary dataDictionary, NodeFactory nodeFactory, TableDescriptor tableDescriptor, Dependent dependent, ResultColumnList resultColumnList, int[] nArray, FormatableBitSet formatableBitSet, boolean bl, boolean bl2) throws StandardException {
        this.bound = true;
        if (this.targetVTI != null) {
            return null;
        }
        this.getAllRelevantConstraints(dataDictionary, tableDescriptor, bl, nArray);
        this.createConstraintDependencies(dataDictionary, this.relevantCdl, dependent);
        this.generateFKInfo(this.relevantCdl, dataDictionary, tableDescriptor, formatableBitSet);
        this.getAllRelevantTriggers(dataDictionary, tableDescriptor, nArray, bl2);
        this.createTriggerDependencies(this.relevantTriggers, dependent);
        this.generateTriggerInfo(this.relevantTriggers, tableDescriptor, nArray);
        if (bl) {
            return null;
        }
        this.checkConstraints = this.generateCheckTree(this.relevantCdl, tableDescriptor);
        if (this.checkConstraints != null) {
            this.bindCheckConstraint(nodeFactory, tableDescriptor, resultColumnList, this.checkConstraints);
        }
        return this.checkConstraints;
    }

    public void bindCheckConstraint(NodeFactory nodeFactory, TableDescriptor tableDescriptor, ResultColumnList resultColumnList, ValueNode valueNode) throws StandardException {
        TableName tableName = this.makeTableName(tableDescriptor.getSchemaName(), tableDescriptor.getName());
        FromList fromList = (FromList)nodeFactory.getNode(37, nodeFactory.doJoinOrderOptimization(), this.getContextManager());
        FromBaseTable fromBaseTable = (FromBaseTable)nodeFactory.getNode(135, tableName, null, resultColumnList, null, this.getContextManager());
        fromBaseTable.setTableNumber(0);
        fromList.addFromTable(fromBaseTable);
        valueNode = valueNode.bindExpression(fromList, null, null);
    }

    protected boolean hasCheckConstraints(DataDictionary dataDictionary, TableDescriptor tableDescriptor) throws StandardException {
        ConstraintDescriptorList constraintDescriptorList = dataDictionary.getConstraintDescriptors(tableDescriptor);
        if (constraintDescriptorList == null) {
            return false;
        }
        ConstraintDescriptorList constraintDescriptorList2 = constraintDescriptorList.getSubList(4);
        return constraintDescriptorList2.size() > 0;
    }

    private ValueNode generateCheckTree(ConstraintDescriptorList constraintDescriptorList, TableDescriptor tableDescriptor) throws StandardException {
        ConstraintDescriptorList constraintDescriptorList2 = constraintDescriptorList.getSubList(4);
        int n = constraintDescriptorList2.size();
        ValueNode valueNode = null;
        int n2 = 0;
        while (n2 < n) {
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList2.elementAt(n2);
            String string = constraintDescriptor.getConstraintText();
            ValueNode valueNode2 = this.parseCheckConstraint(string, tableDescriptor);
            TestConstraintNode testConstraintNode = (TestConstraintNode)this.getNodeFactory().getNode(1, valueNode2, "23513", tableDescriptor.getQualifiedName(), constraintDescriptor.getConstraintName(), this.getContextManager());
            valueNode = valueNode == null ? testConstraintNode : (ValueNode)this.getNodeFactory().getNode(39, testConstraintNode, valueNode, this.getContextManager());
            ++n2;
        }
        return valueNode;
    }

    private void generateFKInfo(ConstraintDescriptorList constraintDescriptorList, DataDictionary dataDictionary, TableDescriptor tableDescriptor, FormatableBitSet formatableBitSet) throws StandardException {
        Vector<FKInfo> vector = new Vector<FKInfo>(10);
        UUID[] uUIDArray = null;
        long[] lArray = null;
        String[] stringArray = null;
        ConstraintDescriptorList constraintDescriptorList2 = dataDictionary.getActiveConstraintDescriptors(constraintDescriptorList);
        int[] nArray = this.getRowMap(formatableBitSet, tableDescriptor);
        int[] nArray2 = null;
        Vector<String> vector2 = new Vector<String>(1);
        Vector<Long> vector3 = new Vector<Long>(1);
        Vector<Integer> vector4 = new Vector<Integer>(1);
        Vector<ColumnDescriptorList> vector5 = new Vector<ColumnDescriptorList>(1);
        Vector<int[]> vector6 = new Vector<int[]>(1);
        int n = constraintDescriptorList2.size();
        int n2 = 0;
        while (n2 < n) {
            block12: {
                Object object;
                TupleDescriptor tupleDescriptor;
                Object object2;
                boolean[] blArray;
                ReferencedKeyConstraintDescriptor referencedKeyConstraintDescriptor;
                int n3;
                ConstraintDescriptor constraintDescriptor;
                block11: {
                    block10: {
                        constraintDescriptor = constraintDescriptorList2.elementAt(n2);
                        if (!(constraintDescriptor instanceof ForeignKeyConstraintDescriptor)) break block10;
                        n3 = 1;
                        referencedKeyConstraintDescriptor = ((ForeignKeyConstraintDescriptor)constraintDescriptor).getReferencedConstraint();
                        uUIDArray = new UUID[1];
                        lArray = new long[1];
                        stringArray = new String[1];
                        blArray = new boolean[1];
                        nArray2 = new int[1];
                        this.fkSetupArrays(dataDictionary, (ForeignKeyConstraintDescriptor)constraintDescriptor, 0, uUIDArray, lArray, stringArray, blArray, nArray2);
                        stringArray[0] = constraintDescriptor.getConstraintName();
                        break block11;
                    }
                    if (constraintDescriptor instanceof ReferencedKeyConstraintDescriptor) {
                        referencedKeyConstraintDescriptor = (ReferencedKeyConstraintDescriptor)constraintDescriptor;
                        n3 = 2;
                        ConstraintDescriptorList constraintDescriptorList3 = dataDictionary.getActiveConstraintDescriptors(((ReferencedKeyConstraintDescriptor)constraintDescriptor).getForeignKeyConstraints(1));
                        int n4 = constraintDescriptorList3.size();
                        if (n4 != 0) {
                            uUIDArray = new UUID[n4];
                            stringArray = new String[n4];
                            lArray = new long[n4];
                            blArray = new boolean[n4];
                            nArray2 = new int[n4];
                            object2 = null;
                            int[] nArray3 = this.remapReferencedColumns(constraintDescriptor, nArray);
                            int n5 = 0;
                            while (n5 < n4) {
                                object2 = (ForeignKeyConstraintDescriptor)constraintDescriptorList3.elementAt(n5);
                                this.fkSetupArrays(dataDictionary, (ForeignKeyConstraintDescriptor)object2, n5, uUIDArray, lArray, stringArray, blArray, nArray2);
                                if (nArray2[n5] == 0 || nArray2[n5] == 3) {
                                    tupleDescriptor = ((ConstraintDescriptor)object2).getTableDescriptor();
                                    vector2.addElement(((TableDescriptor)tupleDescriptor).getSchemaName() + "." + ((TableDescriptor)tupleDescriptor).getName());
                                    vector4.addElement(new Integer(nArray2[n5]));
                                    int[] nArray4 = ((ConstraintDescriptor)object2).getReferencedColumns();
                                    object = ((TableDescriptor)tupleDescriptor).getColumnDescriptorList();
                                    ColumnDescriptorList columnDescriptorList = new ColumnDescriptorList();
                                    int n6 = 0;
                                    while (n6 < nArray4.length) {
                                        ColumnDescriptor columnDescriptor = ((ColumnDescriptorList)object).elementAt(nArray4[n6] - 1);
                                        columnDescriptorList.add(columnDescriptor);
                                        ++n6;
                                    }
                                    vector5.addElement(columnDescriptorList);
                                    vector3.addElement(new Long(lArray[n5]));
                                    vector6.addElement(nArray3);
                                }
                                ++n5;
                            }
                        }
                    }
                    break block12;
                }
                TableDescriptor tableDescriptor2 = referencedKeyConstraintDescriptor.getTableDescriptor();
                object2 = referencedKeyConstraintDescriptor.getIndexId();
                tupleDescriptor = tableDescriptor2.getConglomerateDescriptor((UUID)object2);
                object = constraintDescriptor.getTableDescriptor();
                vector.addElement(new FKInfo(stringArray, ((TableDescriptor)object).getName(), this.statementType, n3, (UUID)object2, ((ConglomerateDescriptor)tupleDescriptor).getConglomerateNumber(), uUIDArray, lArray, blArray, this.remapReferencedColumns(constraintDescriptor, nArray), dataDictionary.getRowLocationTemplate(this.getLanguageConnectionContext(), (TableDescriptor)object), nArray2));
            }
            ++n2;
        }
        n2 = vector.size();
        if (n2 > 0) {
            this.fkInfo = new FKInfo[n2];
            int n7 = 0;
            while (n7 < n2) {
                this.fkInfo[n7] = (FKInfo)vector.elementAt(n7);
                ++n7;
            }
        }
        if ((n2 = vector4.size()) > 0) {
            this.fkTableNames = new String[n2];
            this.fkRefActions = new int[n2];
            this.fkColDescriptors = new ColumnDescriptorList[n2];
            this.fkIndexConglomNumbers = new long[n2];
            this.fkColArrays = new int[n2][];
            int n8 = 0;
            while (n8 < n2) {
                this.fkTableNames[n8] = (String)vector2.elementAt(n8);
                this.fkRefActions[n8] = (Integer)vector4.elementAt(n8);
                this.fkColDescriptors[n8] = (ColumnDescriptorList)vector5.elementAt(n8);
                this.fkIndexConglomNumbers[n8] = (Long)vector3.elementAt(n8);
                this.fkColArrays[n8] = (int[])vector6.elementAt(n8);
                ++n8;
            }
        }
    }

    private void fkSetupArrays(DataDictionary dataDictionary, ForeignKeyConstraintDescriptor foreignKeyConstraintDescriptor, int n, UUID[] uUIDArray, long[] lArray, String[] stringArray, boolean[] blArray, int[] nArray) throws StandardException {
        stringArray[n] = foreignKeyConstraintDescriptor.getConstraintName();
        uUIDArray[n] = foreignKeyConstraintDescriptor.getIndexId();
        lArray[n] = foreignKeyConstraintDescriptor.getIndexConglomerateDescriptor(dataDictionary).getConglomerateNumber();
        blArray[n] = foreignKeyConstraintDescriptor.isSelfReferencingFK();
        if (this.statementType == 4) {
            nArray[n] = foreignKeyConstraintDescriptor.getRaDeleteRule();
        } else if (this.statementType == 3) {
            nArray[n] = foreignKeyConstraintDescriptor.getRaUpdateRule();
        }
    }

    private void generateTriggerInfo(GenericDescriptorList genericDescriptorList, TableDescriptor tableDescriptor, int[] nArray) throws StandardException {
        if (genericDescriptorList != null && genericDescriptorList.size() > 0) {
            this.triggerInfo = new TriggerInfo(tableDescriptor, nArray, genericDescriptorList);
        }
    }

    public FKInfo[] getFKInfo() {
        return this.fkInfo;
    }

    public TriggerInfo getTriggerInfo() {
        return this.triggerInfo;
    }

    public ValueNode getCheckConstraints() {
        return this.checkConstraints;
    }

    private void createTriggerDependencies(GenericDescriptorList genericDescriptorList, Dependent dependent) throws StandardException {
        CompilerContext compilerContext = this.getCompilerContext();
        Enumeration enumeration = genericDescriptorList.elements();
        while (enumeration.hasMoreElements()) {
            TriggerDescriptor triggerDescriptor = (TriggerDescriptor)enumeration.nextElement();
            if (dependent == null) {
                compilerContext.createDependency(triggerDescriptor);
                continue;
            }
            compilerContext.createDependency(dependent, triggerDescriptor);
        }
    }

    protected GenericDescriptorList getAllRelevantTriggers(DataDictionary dataDictionary, TableDescriptor tableDescriptor, int[] nArray, boolean bl) throws StandardException {
        if (this.relevantTriggers != null) {
            return this.relevantTriggers;
        }
        this.relevantTriggers = new GenericDescriptorList();
        if (!bl) {
            return this.relevantTriggers;
        }
        tableDescriptor.getAllRelevantTriggers(this.statementType, nArray, this.relevantTriggers);
        this.adjustDeferredFlag(this.relevantTriggers.size() > 0);
        return this.relevantTriggers;
    }

    protected void adjustDeferredFlag(boolean bl) {
        if (!this.requiresDeferredProcessing) {
            this.requiresDeferredProcessing = bl;
        }
    }

    private void createConstraintDependencies(DataDictionary dataDictionary, ConstraintDescriptorList constraintDescriptorList, Dependent dependent) throws StandardException {
        CompilerContext compilerContext = this.getCompilerContext();
        int n = constraintDescriptorList.size();
        int n2 = 0;
        while (n2 < n) {
            Object object;
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(n2);
            if (dependent == null) {
                compilerContext.createDependency(constraintDescriptor);
            } else {
                compilerContext.createDependency(dependent, constraintDescriptor);
            }
            if (constraintDescriptor instanceof ReferencedKeyConstraintDescriptor) {
                object = dataDictionary.getActiveConstraintDescriptors(((ReferencedKeyConstraintDescriptor)constraintDescriptor).getForeignKeyConstraints(1));
                int n3 = ((ArrayList)object).size();
                int n4 = 0;
                while (n4 < n3) {
                    ConstraintDescriptor constraintDescriptor2 = ((ConstraintDescriptorList)object).elementAt(n4);
                    if (dependent == null) {
                        compilerContext.createDependency(constraintDescriptor2);
                        compilerContext.createDependency(constraintDescriptor2.getTableDescriptor());
                    } else {
                        compilerContext.createDependency(dependent, constraintDescriptor2);
                        compilerContext.createDependency(dependent, constraintDescriptor2.getTableDescriptor());
                    }
                    ++n4;
                }
            } else if (constraintDescriptor instanceof ForeignKeyConstraintDescriptor) {
                object = (ForeignKeyConstraintDescriptor)constraintDescriptor;
                if (dependent == null) {
                    compilerContext.createDependency(((ForeignKeyConstraintDescriptor)object).getReferencedConstraint().getTableDescriptor());
                } else {
                    compilerContext.createDependency(dependent, ((ForeignKeyConstraintDescriptor)object).getReferencedConstraint().getTableDescriptor());
                }
            }
            ++n2;
        }
    }

    protected ConstraintDescriptorList getAllRelevantConstraints(DataDictionary dataDictionary, TableDescriptor tableDescriptor, boolean bl, int[] nArray) throws StandardException {
        if (this.relevantCdl != null) {
            return this.relevantCdl;
        }
        boolean[] blArray = new boolean[1];
        this.relevantCdl = new ConstraintDescriptorList();
        blArray[0] = this.requiresDeferredProcessing;
        tableDescriptor.getAllRelevantConstraints(this.statementType, bl, nArray, blArray, this.relevantCdl);
        this.adjustDeferredFlag(blArray[0]);
        return this.relevantCdl;
    }

    public boolean requiresDeferredProcessing() {
        return this.requiresDeferredProcessing;
    }

    public ValueNode parseCheckConstraint(String string, TableDescriptor tableDescriptor) throws StandardException {
        LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
        CompilerContext compilerContext = this.getCompilerContext();
        String string2 = "SELECT * FROM " + tableDescriptor.getQualifiedName() + " WHERE " + string;
        CompilerContext compilerContext2 = languageConnectionContext.pushCompilerContext();
        Parser parser = compilerContext2.getParser();
        QueryTreeNode queryTreeNode = parser.parseStatement(string2);
        ValueNode valueNode = ((SelectNode)((CursorNode)queryTreeNode).getResultSetNode()).getWhereClause();
        languageConnectionContext.popCompilerContext(compilerContext2);
        return valueNode;
    }

    public void generateCheckConstraints(ValueNode valueNode, ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        if (valueNode == null) {
            methodBuilder.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        } else {
            MethodBuilder methodBuilder2 = this.generateCheckConstraints(valueNode, expressionClassBuilder);
            expressionClassBuilder.pushMethodReference(methodBuilder, methodBuilder2);
        }
    }

    public MethodBuilder generateCheckConstraints(ValueNode valueNode, ExpressionClassBuilder expressionClassBuilder) throws StandardException {
        MethodBuilder methodBuilder = expressionClassBuilder.newUserExprFun();
        valueNode.generateExpression(expressionClassBuilder, methodBuilder);
        methodBuilder.methodReturn();
        methodBuilder.complete();
        return methodBuilder;
    }

    public QueryTreeNode optimize() throws StandardException {
        ResultSetNode resultSetNode = this.getResultSetNode();
        QueryTreeNode queryTreeNode = super.optimize();
        this.lockMode = 6;
        return queryTreeNode;
    }

    protected void getAffectedIndexes(TableDescriptor tableDescriptor, ResultColumnList resultColumnList, FormatableBitSet formatableBitSet) throws StandardException {
        Vector vector = new Vector();
        DMLModStatementNode.getXAffectedIndexes(tableDescriptor, resultColumnList, formatableBitSet, vector);
        this.markAffectedIndexes(vector);
    }

    static void getXAffectedIndexes(TableDescriptor tableDescriptor, ResultColumnList resultColumnList, FormatableBitSet formatableBitSet, Vector vector) throws StandardException {
        ConglomerateDescriptor[] conglomerateDescriptorArray = tableDescriptor.getConglomerateDescriptors();
        long[] lArray = new long[conglomerateDescriptorArray.length - 1];
        int n = 0;
        int n2 = 0;
        while (n2 < conglomerateDescriptorArray.length) {
            ConglomerateDescriptor conglomerateDescriptor = conglomerateDescriptorArray[n2];
            if (conglomerateDescriptor.isIndex() && (resultColumnList == null || resultColumnList.updateOverlaps(conglomerateDescriptor.getIndexDescriptor().baseColumnPositions()))) {
                if (vector != null) {
                    int n3 = 0;
                    while (n3 < n) {
                        if (lArray[n3] == conglomerateDescriptor.getConglomerateNumber()) break;
                        ++n3;
                    }
                    if (n3 == n) {
                        lArray[n++] = conglomerateDescriptor.getConglomerateNumber();
                        vector.addElement(conglomerateDescriptor);
                    }
                }
                IndexRowGenerator indexRowGenerator = conglomerateDescriptor.getIndexDescriptor();
                int[] nArray = indexRowGenerator.baseColumnPositions();
                if (formatableBitSet != null) {
                    int n4 = 0;
                    while (n4 < nArray.length) {
                        formatableBitSet.set(nArray[n4]);
                        ++n4;
                    }
                }
            }
            ++n2;
        }
    }

    protected void markAffectedIndexes(Vector vector) throws StandardException {
        int n = vector.size();
        CompilerContext compilerContext = this.getCompilerContext();
        this.indicesToMaintain = new IndexRowGenerator[n];
        this.indexConglomerateNumbers = new long[n];
        this.indexNames = new String[n];
        int n2 = 0;
        while (n2 < n) {
            ConglomerateDescriptor conglomerateDescriptor = (ConglomerateDescriptor)vector.elementAt(n2);
            this.indicesToMaintain[n2] = conglomerateDescriptor.getIndexDescriptor();
            this.indexConglomerateNumbers[n2] = conglomerateDescriptor.getConglomerateNumber();
            this.indexNames[n2] = conglomerateDescriptor.isConstraint() ? null : conglomerateDescriptor.getConglomerateName();
            compilerContext.createDependency(conglomerateDescriptor);
            ++n2;
        }
    }

    public String statementToString() {
        return "DML MOD";
    }

    private int[] remapReferencedColumns(ConstraintDescriptor constraintDescriptor, int[] nArray) {
        int[] nArray2 = constraintDescriptor.getReferencedColumns();
        if (nArray == null) {
            return nArray2;
        }
        int[] nArray3 = new int[nArray2.length];
        int n = 0;
        while (n < nArray2.length) {
            nArray3[n] = nArray[nArray2[n]];
            ++n;
        }
        return nArray3;
    }

    private int[] getRowMap(FormatableBitSet formatableBitSet, TableDescriptor tableDescriptor) throws StandardException {
        if (formatableBitSet == null) {
            return null;
        }
        int n = tableDescriptor.getMaxColumnID();
        int[] nArray = new int[n + 1];
        int n2 = 1;
        int n3 = 1;
        while (n3 <= n) {
            if (formatableBitSet.get(n3)) {
                nArray[n3] = n2++;
            }
            ++n3;
        }
        return nArray;
    }

    public void setRefActionInfo(long l, int[] nArray, String string, boolean bl) {
        this.resultSet.setRefActionInfo(l, nArray, string, bl);
    }
}

