/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.PreparedStatement;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.compile.TableName;

public class ExecSPSNode
extends StatementNode {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1998, 2004.";
    private TableName name;
    private SPSDescriptor spsd;
    private ExecPreparedStatement ps;
    private ResultSetNode usingClause;
    private String usingText;

    public void init(Object object, Object object2, Object object3) throws StandardException {
        this.name = (TableName)object;
        this.usingClause = (ResultSetNode)object2;
        this.usingText = (String)object3;
    }

    public QueryTreeNode bind() throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        if (this.usingClause != null) {
            this.usingClause.bind();
        }
        String string = this.name.getSchemaName();
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor(this.name.getSchemaName());
        if (string == null) {
            this.name.setSchemaName(schemaDescriptor.getSchemaName());
        }
        if (schemaDescriptor.getUUID() != null) {
            this.spsd = dataDictionary.getSPSDescriptor(this.name.getTableName(), schemaDescriptor);
        }
        if (this.spsd == null) {
            throw StandardException.newException("42X94", "STATEMENT", (Object)this.name);
        }
        if (this.spsd.getType() == SPSDescriptor.SPS_TYPE_TRIGGER) {
            throw StandardException.newException("42Y41", this.name);
        }
        this.getCompilerContext().createDependency(this.spsd);
        return this;
    }

    public boolean isAtomic() {
        return this.ps.isAtomic();
    }

    public GeneratedClass generate(ByteArray byteArray) throws StandardException {
        if (!this.spsd.isValid()) {
            this.getLanguageConnectionContext().commitNestedTransaction();
            this.getLanguageConnectionContext().beginNestedTransaction(true);
        }
        this.ps = this.spsd.getPreparedStatement();
        this.getCompilerContext().setSavedObjects(this.ps.getSavedObjects());
        this.getCompilerContext().setCursorInfo(this.ps.getCursorInfo());
        GeneratedClass generatedClass = this.ps.getActivationClass();
        this.setupParams();
        return generatedClass;
    }

    public ResultDescription makeResultDescription() {
        return this.ps.getResultDescription();
    }

    public Object getCursorInfo() {
        return this.ps.getCursorInfo();
    }

    public DataTypeDescriptor[] getParameterTypes() throws StandardException {
        return this.spsd.getParams();
    }

    public ConstantAction makeConstantAction() {
        return this.ps.getConstantAction();
    }

    public boolean needsSavepoint() {
        return this.ps.needsSavepoint();
    }

    public String executeStatementName() {
        return this.name.getTableName();
    }

    public String executeSchemaName() {
        return this.name.getSchemaName();
    }

    public String getSPSName() {
        return this.spsd.getQualifiedName();
    }

    int activationKind() {
        return 2;
    }

    private void setupParams() throws StandardException {
        if (this.usingClause == null) {
            return;
        }
        DataTypeDescriptor[] dataTypeDescriptorArray = this.spsd.getParams();
        if (dataTypeDescriptorArray == null) {
            return;
        }
        LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
        PreparedStatement preparedStatement = languageConnectionContext.prepareInternalStatement(this.usingText);
        ResultSet resultSet = preparedStatement.execute(languageConnectionContext, false);
        try {
            ExecRow execRow = resultSet.getNextRow();
            if (execRow == null) {
                throw StandardException.newException("42X63");
            }
            ParameterValueSet parameterValueSet = languageConnectionContext.getLanguageFactory().newParameterValueSet(languageConnectionContext.getLanguageConnectionFactory().getClassFactory().getClassInspector(), dataTypeDescriptorArray.length, false);
            DataValueDescriptor[] dataValueDescriptorArray = execRow.getRowArray();
            if (dataValueDescriptorArray.length != dataTypeDescriptorArray.length) {
                throw StandardException.newException("XJ080.S", Integer.toString(dataValueDescriptorArray.length), (Object)Integer.toString(dataTypeDescriptorArray.length));
            }
            int n = 0;
            while (n < dataTypeDescriptorArray.length) {
                TypeId typeId = dataTypeDescriptorArray[n].getTypeId();
                parameterValueSet.setStorableDataValue(typeId.getNull(), n, typeId.getJDBCTypeId(), typeId.getCorrespondingJavaTypeName());
                parameterValueSet.getParameterForSet(n).setValue(dataValueDescriptorArray[n]);
                ++n;
            }
            if (resultSet.getNextRow() != null) {
                throw StandardException.newException("42X82");
            }
            parameterValueSet.setUsingParameterValueSet();
            this.getCompilerContext().setParams(parameterValueSet);
        }
        finally {
            Object var6_10 = null;
            resultSet.close();
        }
    }

    public String statementToString() {
        return "EXECUTE STATEMENT";
    }

    SPSDescriptor getSPSDescriptor() {
        return this.spsd;
    }

    String getUsingText() {
        return this.usingText;
    }
}

