/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;

public class TimeTypeCompiler
extends BaseTypeCompiler {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1999, 2004.";

    public boolean comparable(TypeId typeId, boolean bl, ClassFactory classFactory) {
        int n = typeId.getJDBCTypeId();
        if (typeId.isLongConcatableTypeId()) {
            return false;
        }
        if (n == 92 || typeId.isStringTypeId()) {
            return true;
        }
        TypeCompiler typeCompiler = this.getTypeCompiler(typeId);
        if (typeId.userType()) {
            return typeCompiler.comparable(this.getTypeId(), bl, classFactory);
        }
        return false;
    }

    public boolean convertible(TypeId typeId, boolean bl) {
        if (typeId.isStringTypeId() && !typeId.isLOBTypeId() && !typeId.isLongVarcharTypeId()) {
            return true;
        }
        return this.getStoredFormatIdFromTypeId() == typeId.getTypeFormatId();
    }

    public boolean compatible(TypeId typeId) {
        return this.convertible(typeId, false);
    }

    public boolean storable(TypeId typeId, ClassFactory classFactory) {
        int n = typeId.getJDBCTypeId();
        if (n == 92 || n == 1 || n == 12) {
            return true;
        }
        return classFactory.getClassInspector().assignableTo(typeId.getCorrespondingJavaTypeName(), "java.sql.Time");
    }

    public String interfaceName() {
        return "org.apache.derby.iapi.types.DateTimeDataValue";
    }

    public String getCorrespondingPrimitiveTypeName() {
        return "java.sql.Time";
    }

    public int getCastToCharWidth(DataTypeDescriptor dataTypeDescriptor) {
        return 8;
    }

    public double estimatedMemoryUsage(DataTypeDescriptor dataTypeDescriptor) {
        return 12.0;
    }

    protected String nullMethodName() {
        return "getNullTime";
    }
}

