/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class UnaryArithmeticOperatorNode
extends UnaryOperatorNode {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private static final int UNARY_PLUS = 0;
    private static final int UNARY_MINUS = 1;
    private static final int SQRT = 2;
    private static final int ABSOLUTE = 3;
    private static final String[] UNARY_OPERATORS = new String[]{"+", "-", "SQRT", "ABS/ABSVAL"};
    private static final String[] UNARY_METHODS = new String[]{"plus", "minus", "sqrt", "absolute"};
    private int operatorType;

    public void init(Object object) {
        switch (this.getNodeType()) {
            case 30: {
                this.operatorType = 0;
                break;
            }
            case 29: {
                this.operatorType = 1;
                break;
            }
            case 189: {
                this.operatorType = 2;
                break;
            }
            case 188: {
                this.operatorType = 3;
                break;
            }
        }
        this.init(object, UNARY_OPERATORS[this.operatorType], UNARY_METHODS[this.operatorType]);
    }

    void bindParameter() throws StandardException {
        if (this.operatorType == 2 || this.operatorType == 3) {
            ((ParameterNode)this.operand).setDescriptor(new DataTypeDescriptor(TypeId.getBuiltInTypeId(8), true));
        } else if (this.operand.getTypeServices() == null) {
            throw StandardException.newException("42X36", this.operator);
        }
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        TypeId typeId;
        super.bindExpression(fromList, subqueryList, vector);
        if (this.operatorType == 2 || this.operatorType == 3) {
            this.bindSQRTABS();
        } else if (!(this.operatorType != 0 && this.operatorType != 1 || (typeId = this.operand.getTypeId()).isNumericTypeId())) {
            throw StandardException.newException("42X37", this.operatorType == 0 ? "+" : "-", (Object)typeId.getSQLTypeName());
        }
        this.setType(this.operand.getTypeServices());
        return this;
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        if (this.operatorType == 0) {
            this.operand.generateExpression(expressionClassBuilder, methodBuilder);
        } else {
            super.generateExpression(expressionClassBuilder, methodBuilder);
        }
    }

    private void bindSQRTABS() throws StandardException {
        TypeId typeId = this.operand.getTypeId();
        if (!typeId.systemBuiltIn()) {
            this.operand = this.operand.genSQLJavaSQLTree();
        }
        int n = typeId.getJDBCTypeId();
        if (!typeId.isNumericTypeId()) {
            throw StandardException.newException("42X25", this.getOperatorString(), (Object)typeId.getSQLTypeName());
        }
        if (this.operatorType == 2 && n != 8) {
            this.operand = (ValueNode)this.getNodeFactory().getNode(60, this.operand, new DataTypeDescriptor(TypeId.getBuiltInTypeId(8), true), this.getContextManager());
            ((CastNode)this.operand).bindCastNodeOnly();
        }
    }
}

