/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public class ValueNodeList
extends QueryTreeNodeVector {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";

    public void printSubNodes(int n) {
    }

    public void setClause(int n) {
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2) {
            ValueNode valueNode = (ValueNode)this.elementAt(n3);
            valueNode.setClause(n);
            ++n3;
        }
    }

    public void addValueNode(ValueNode valueNode) throws StandardException {
        this.addElement(valueNode);
    }

    public void bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ValueNode valueNode = (ValueNode)this.elementAt(n2);
            valueNode = valueNode.bindExpression(fromList, subqueryList, vector);
            this.setElementAt(valueNode, n2);
            ++n2;
        }
    }

    public void genSQLJavaSQLTrees() throws StandardException {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ValueNode valueNode = (ValueNode)this.elementAt(n2);
            if (!valueNode.getTypeId().systemBuiltIn()) {
                this.setElementAt(valueNode.genSQLJavaSQLTree(), n2);
            }
            ++n2;
        }
    }

    public DataTypeDescriptor getDominantTypeServices() throws StandardException {
        DataTypeDescriptor dataTypeDescriptor = null;
        int n = 0;
        while (n < this.size()) {
            ValueNode valueNode = (ValueNode)this.elementAt(n);
            if (!valueNode.isParameterNode()) {
                DataTypeDescriptor dataTypeDescriptor2 = valueNode.getTypeServices();
                dataTypeDescriptor = dataTypeDescriptor == null ? dataTypeDescriptor2 : dataTypeDescriptor.getDominantType(dataTypeDescriptor2, this.getClassFactory());
            }
            ++n;
        }
        return dataTypeDescriptor;
    }

    public DataTypeDescriptor getTypeServices() throws StandardException {
        DataTypeDescriptor dataTypeDescriptor = null;
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ValueNode valueNode = (ValueNode)this.elementAt(n2);
            DataTypeDescriptor dataTypeDescriptor2 = valueNode.getTypeServices();
            if (dataTypeDescriptor == null && dataTypeDescriptor2 != null) {
                dataTypeDescriptor = dataTypeDescriptor2;
                break;
            }
            ++n2;
        }
        return dataTypeDescriptor;
    }

    boolean allSamePrecendence(int n) {
        boolean bl = true;
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2) {
            ValueNode valueNode = (ValueNode)this.elementAt(n3);
            DataTypeDescriptor dataTypeDescriptor = valueNode.getTypeServices();
            if (dataTypeDescriptor == null) {
                return false;
            }
            if (n != dataTypeDescriptor.getTypeId().typePrecedence()) {
                return false;
            }
            ++n3;
        }
        return bl;
    }

    public void compatible(ValueNode valueNode) throws StandardException {
        int n = this.size();
        TypeId typeId = valueNode.getTypeId();
        TypeCompiler typeCompiler = valueNode.getTypeCompiler();
        int n2 = 0;
        while (n2 < n) {
            ValueNode valueNode2 = (ValueNode)this.elementAt(n2);
            if (!valueNode2.isParameterNode() && !typeCompiler.compatible(valueNode2.getTypeId())) {
                throw StandardException.newException("42815.S.171", typeId.getSQLTypeName(), (Object)valueNode2.getTypeId().getSQLTypeName());
            }
            ++n2;
        }
    }

    public void comparable(ValueNode valueNode) throws StandardException {
        int n = this.size();
        TypeId typeId = valueNode.getTypeId();
        TypeCompiler typeCompiler = valueNode.getTypeCompiler();
        int n2 = 0;
        while (n2 < n) {
            ValueNode valueNode2 = (ValueNode)this.elementAt(n2);
            if (!typeCompiler.comparable(valueNode2.getTypeId(), false, this.getClassFactory())) {
                throw StandardException.newException("42818", typeId.getSQLTypeName(), (Object)valueNode2.getTypeId().getSQLTypeName());
            }
            ++n2;
        }
    }

    public boolean isNullable() {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            if (((ValueNode)this.elementAt(n2)).getTypeServices().isNullable()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean containsParameterNode() {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            if (((ValueNode)this.elementAt(n2)).isParameterNode()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean containsAllParameterNodes() {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            if (!((ValueNode)this.elementAt(n2)).isParameterNode()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean containsAllConstantNodes() {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            if (!((ValueNode)this.elementAt(n2) instanceof ConstantNode)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    void sortInAscendingOrder(DataValueDescriptor dataValueDescriptor) throws StandardException {
        int n = this.size();
        boolean bl = true;
        while (bl) {
            bl = false;
            int n2 = 1;
            while (n2 < n) {
                ConstantNode constantNode = (ConstantNode)this.elementAt(n2);
                DataValueDescriptor dataValueDescriptor2 = constantNode.getValue();
                ConstantNode constantNode2 = (ConstantNode)this.elementAt(n2 - 1);
                DataValueDescriptor dataValueDescriptor3 = constantNode2.getValue();
                if (dataValueDescriptor == null && dataValueDescriptor3.compare(dataValueDescriptor2) > 0 || dataValueDescriptor != null && dataValueDescriptor.greaterThan(dataValueDescriptor3, dataValueDescriptor2).equals(true)) {
                    this.setElementAt(constantNode, n2 - 1);
                    this.setElementAt(constantNode2, n2);
                    bl = true;
                }
                ++n2;
            }
        }
    }

    public void setParameterDescriptor(DataTypeDescriptor dataTypeDescriptor) throws StandardException {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ValueNode valueNode = (ValueNode)this.elementAt(n2);
            if (valueNode.isParameterNode()) {
                ((ParameterNode)valueNode).setDescriptor(dataTypeDescriptor);
            }
            ++n2;
        }
    }

    public void preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2) {
            ValueNode valueNode = (ValueNode)this.elementAt(n3);
            valueNode.preprocess(n, fromList, subqueryList, predicateList);
            ++n3;
        }
    }

    public ValueNodeList remapColumnReferencesToExpressions() throws StandardException {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            this.setElementAt(((ValueNode)this.elementAt(n2)).remapColumnReferencesToExpressions(), n2);
            ++n2;
        }
        return this;
    }

    public boolean isConstantExpression() {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            boolean bl = ((ValueNode)this.elementAt(n2)).isConstantExpression();
            if (!bl) {
                return bl;
            }
            ++n2;
        }
        return true;
    }

    public boolean constantExpression(PredicateList predicateList) {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            boolean bl = ((ValueNode)this.elementAt(n2)).constantExpression(predicateList);
            if (!bl) {
                return bl;
            }
            ++n2;
        }
        return true;
    }

    public boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        boolean bl2 = true;
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            bl2 = ((ValueNode)this.elementAt(n2)).categorize(jBitSet, bl) && bl2;
            ++n2;
        }
        return bl2;
    }

    protected int getOrderableVariantType() throws StandardException {
        int n = 3;
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = ((ValueNode)this.elementAt(n3)).getOrderableVariantType();
            n = Math.min(n, n4);
            ++n3;
        }
        return n;
    }
}

