/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.apache.derby.catalog.AliasInfo;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class CreateAliasConstantAction
extends DDLConstantAction {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1999, 2004.";
    private final String aliasName;
    private final String schemaName;
    private final String javaClassName;
    private final char aliasType;
    private final char nameSpace;
    private final AliasInfo aliasInfo;

    public String toString() {
        String string = null;
        switch (this.aliasType) {
            case 'P': {
                string = "CREATE PROCEDURE ";
                break;
            }
            case 'F': {
                string = "CREATE FUNCTION ";
                break;
            }
        }
        return string + this.aliasName;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        Object object;
        Serializable serializable;
        Object object2;
        LanguageConnectionContext languageConnectionContext = activation != null ? activation.getLanguageConnectionContext() : (LanguageConnectionContext)ContextService.getContext("LanguageConnectionContext");
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        String string = null;
        String string2 = this.javaClassName;
        if (this.aliasInfo != null) {
            string = this.aliasInfo.getMethodName();
        }
        switch (this.aliasType) {
            case 'F': 
            case 'P': {
                break;
            }
            default: {
                object2 = languageConnectionContext.getLanguageConnectionFactory().getClassFactory();
                serializable = null;
                try {
                    serializable = object2.loadApplicationClass(string2);
                }
                catch (Throwable throwable) {
                    throw StandardException.newException("42X51", throwable, (Object)string2);
                }
                if (!Modifier.isPublic(((Class)serializable).getModifiers())) {
                    throw StandardException.newException("42X51", string2);
                }
                if (string == null) break;
                object = ((Class)serializable).getMethods();
                int n = 0;
                while (n < ((Method[])object).length) {
                    if (Modifier.isStatic(object[n].getModifiers()) && string.equals(object[n].getName())) break;
                    ++n;
                }
                if (n != ((Method[])object).length) break;
                throw StandardException.newException("42Y16", string, (Object)string2);
            }
        }
        dataDictionary.startWriting(languageConnectionContext);
        object2 = null;
        if (activation == null) {
            object2 = dataDictionary.getSysIBMSchemaDescriptor();
        } else if (this.schemaName != null) {
            object2 = DDLConstantAction.getSchemaDescriptorForCreate(dataDictionary, activation, this.schemaName);
        }
        serializable = dataDictionary.getUUIDFactory().createUUID();
        object = new AliasDescriptor(dataDictionary, (UUID)serializable, this.aliasName, object2 != null ? ((SchemaDescriptor)object2).getUUID() : null, this.javaClassName, this.aliasType, this.nameSpace, false, this.aliasInfo, null);
        switch (this.aliasType) {
            case 'F': 
            case 'P': {
                List list = dataDictionary.getRoutineList(((SchemaDescriptor)object2).getUUID().toString(), this.aliasName, this.aliasType);
                int n = list.size() - 1;
                while (n >= 0) {
                    AliasDescriptor aliasDescriptor = (AliasDescriptor)list.get(n);
                    RoutineAliasInfo routineAliasInfo = (RoutineAliasInfo)aliasDescriptor.getAliasInfo();
                    int n2 = routineAliasInfo.getParameterCount();
                    if (n2 == ((RoutineAliasInfo)this.aliasInfo).getParameterCount()) {
                        throw StandardException.newException("X0Y68.S", ((AliasDescriptor)object).getDescriptorType(), (Object)this.aliasName);
                    }
                    --n;
                }
                break;
            }
        }
        dataDictionary.addDescriptor((TupleDescriptor)object, null, 7, false, languageConnectionContext.getTransactionExecute());
    }

    CreateAliasConstantAction(String string, String string2, String string3, AliasInfo aliasInfo, char c) {
        this.aliasName = string;
        this.schemaName = string2;
        this.javaClassName = string3;
        this.aliasInfo = aliasInfo;
        this.aliasType = c;
        switch (c) {
            case 'P': {
                this.nameSpace = (char)80;
                break;
            }
            case 'F': {
                this.nameSpace = (char)70;
                break;
            }
            default: {
                this.nameSpace = '\u0000';
                break;
            }
        }
    }
}

