/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.impl.sql.execute.InternalTriggerExecutionContext;
import org.apache.derby.impl.sql.execute.TriggerEvent;

public abstract class GenericTriggerExecutor {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1999, 2004.";
    protected InternalTriggerExecutionContext tec;
    protected TriggerDescriptor triggerd;
    protected Activation activation;
    protected LanguageConnectionContext lcc;
    private boolean whenClauseRetrieved;
    private boolean actionRetrieved;
    private SPSDescriptor whenClause;
    private SPSDescriptor action;
    private ExecPreparedStatement ps;
    private Activation spsActivation;

    abstract void fireTrigger(TriggerEvent var1, CursorResultSet var2, CursorResultSet var3) throws StandardException;

    protected SPSDescriptor getWhenClause() throws StandardException {
        if (!this.whenClauseRetrieved) {
            this.whenClauseRetrieved = true;
            this.whenClause = this.triggerd.getWhenClauseSPS();
        }
        return this.whenClause;
    }

    protected SPSDescriptor getAction() throws StandardException {
        if (!this.actionRetrieved) {
            this.actionRetrieved = true;
            this.action = this.triggerd.getActionSPS(this.lcc);
        }
        return this.action;
    }

    protected void executeSPS(SPSDescriptor sPSDescriptor) throws StandardException {
        boolean bl = false;
        while (true) {
            if (this.ps == null || bl) {
                this.ps = sPSDescriptor.getPreparedStatement();
                this.ps = this.ps.getClone();
                this.ps.setValid();
                this.spsActivation = this.ps.getActivation(this.lcc, false);
                this.ps.setSource(sPSDescriptor.getText());
                this.ps.setSPSAction();
            }
            try {
                this.ps.execute(this.spsActivation, false, false, false);
            }
            catch (StandardException standardException) {
                if (standardException.getMessageId().equals("XCL32.S")) {
                    StatementContext statementContext = this.lcc.getStatementContext();
                    statementContext.cleanupOnError(standardException);
                    bl = true;
                    sPSDescriptor.revalidate(this.lcc);
                    continue;
                }
                this.lcc.popStatementContext(this.lcc.getStatementContext(), standardException);
                this.spsActivation.close();
                throw standardException;
            }
            break;
        }
    }

    protected void clearSPS() throws StandardException {
        if (this.spsActivation != null) {
            this.spsActivation.close();
        }
        this.ps = null;
        this.spsActivation = null;
    }

    GenericTriggerExecutor(InternalTriggerExecutionContext internalTriggerExecutionContext, TriggerDescriptor triggerDescriptor, Activation activation, LanguageConnectionContext languageConnectionContext) {
        this.tec = internalTriggerExecutionContext;
        this.triggerd = triggerDescriptor;
        this.activation = activation;
        this.lcc = languageConnectionContext;
    }
}

