/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;
import org.apache.derby.impl.sql.execute.TableScanResultSet;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderResultSet;

public class IndexRowToBaseRowResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private long conglomId;
    public NoPutResultSet source;
    private GeneratedMethod resultRowAllocator;
    private GeneratedMethod restriction;
    private long baseConglomId;
    private GeneratedMethod closeCleanup;
    public FormatableBitSet accessedHeapCols;
    private FormatableBitSet accessedIndexCols;
    private FormatableBitSet accessedAllCols;
    public String indexName;
    private int[] indexCols;
    private DynamicCompiledOpenConglomInfo dcoci;
    private StaticCompiledOpenConglomInfo scoci;
    private ConglomerateController baseCC;
    private boolean closeBaseCCHere;
    private ExecRow resultRow;
    private ExecRow compactRow;
    private boolean forUpdate;
    private DataValueDescriptor[] rowArray;
    RowLocation baseRowLocation;
    boolean copiedFromSource;
    public long restrictionTime;
    protected boolean currentRowPrescanned;
    private boolean sourceIsForUpdateIndexScan;

    public void openCore() throws StandardException {
        boolean bl = false;
        this.beginTime = this.getCurrentTimeMillis();
        this.source.openCore();
        if (this.source instanceof TableScanResultSet && ((TableScanResultSet)this.source).indexCols != null) {
            this.sourceIsForUpdateIndexScan = true;
        }
        if (this.source.requiresRelocking()) {
            bl = true;
        }
        TransactionController transactionController = this.activation.getTransactionController();
        int n = this.forUpdate ? 4 : 0;
        int n2 = this.source.getScanIsolationLevel();
        if (!bl) {
            n |= 0x2000;
        }
        if (this.forUpdate) {
            this.baseCC = this.activation.getHeapConglomerateController();
        }
        if (this.baseCC == null) {
            this.baseCC = transactionController.openCompiledConglomerate(this.activation.getResultSetHoldability(), n, 6, n2, this.scoci, this.dcoci);
            this.closeBaseCCHere = true;
        }
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public void reopenCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.source.reopenCore();
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public ExecRow getNextRowCore() throws StandardException {
        ExecRow execRow = null;
        ExecRow execRow2 = null;
        boolean bl = false;
        long l = 0L;
        this.beginTime = this.getCurrentTimeMillis();
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "next");
        }
        if (this.sourceIsForUpdateIndexScan && ((TableScanResultSet)this.source).futureForUpdateRows != null) {
            this.currentRowPrescanned = false;
            TableScanResultSet tableScanResultSet = (TableScanResultSet)this.source;
            if (tableScanResultSet.futureRowResultSet == null) {
                tableScanResultSet.futureRowResultSet = (TemporaryRowHolderResultSet)tableScanResultSet.futureForUpdateRows.getResultSet();
                tableScanResultSet.futureRowResultSet.openCore();
            }
            ExecRow execRow3 = tableScanResultSet.futureRowResultSet.getNextRowCore();
            this.currentRow = null;
            if (execRow3 != null) {
                tableScanResultSet.futureRowResultSet.deleteCurrentRow();
                this.baseRowLocation = (RowLocation)execRow3.getColumn(1);
                this.baseCC.fetch(this.baseRowLocation, this.compactRow.getRowArray(), this.accessedAllCols);
                this.currentRow = this.compactRow;
                this.currentRowPrescanned = true;
            } else if (tableScanResultSet.sourceDrained) {
                this.currentRowPrescanned = true;
            }
            if (this.currentRowPrescanned) {
                this.setCurrentRow(this.currentRow);
                this.nextTime += this.getElapsedMillis(this.beginTime);
                return this.currentRow;
            }
        }
        do {
            if ((execRow = this.source.getNextRowCore()) != null) {
                this.baseRowLocation = (RowLocation)execRow.getColumn(execRow.nColumns());
                boolean bl2 = this.baseCC.fetch(this.baseRowLocation, this.rowArray, this.accessedHeapCols);
                if (bl2) {
                    if (!this.copiedFromSource) {
                        this.copiedFromSource = true;
                        int n = 0;
                        while (n < this.indexCols.length) {
                            if (this.indexCols[n] != -1) {
                                this.compactRow.setColumn(n + 1, execRow.getColumn(this.indexCols[n] + 1));
                            }
                            ++n;
                        }
                    }
                    this.setCurrentRow(this.compactRow);
                    DataValueDescriptor dataValueDescriptor = (DataValueDescriptor)(this.restriction == null ? null : this.restriction.invoke(this.activation));
                    this.restrictionTime += this.getElapsedMillis(l);
                    boolean bl3 = bl = dataValueDescriptor == null || !dataValueDescriptor.isNull() && dataValueDescriptor.getBoolean();
                }
                if (!bl || !bl2) {
                    ++this.rowsFiltered;
                    this.clearCurrentRow();
                    this.baseRowLocation = null;
                    this.currentRow = null;
                } else {
                    this.currentRow = this.compactRow;
                }
                ++this.rowsSeen;
                execRow2 = this.currentRow;
                continue;
            }
            this.currentRow = null;
            this.clearCurrentRow();
            this.baseRowLocation = null;
            execRow2 = null;
        } while (execRow != null && !bl);
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return execRow2;
    }

    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            if (this.closeCleanup != null) {
                this.closeCleanup.invoke(this.activation);
            }
            this.currentRow = null;
            if (this.closeBaseCCHere && this.baseCC != null) {
                this.baseCC.close();
            }
            this.baseCC = null;
            this.source.close();
            super.close();
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    public long getTimeSpent(int n) {
        long l = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n == 0) {
            return l - this.source.getTimeSpent(1);
        }
        return l;
    }

    public RowLocation getRowLocation() throws StandardException {
        return this.baseRowLocation;
    }

    public ExecRow getCurrentRow() throws StandardException {
        ExecRow execRow = null;
        if (this.currentRowPrescanned) {
            return this.currentRow;
        }
        if (this.currentRow == null) {
            return null;
        }
        execRow = ((CursorResultSet)((Object)this.source)).getCurrentRow();
        if (execRow != null) {
            this.baseRowLocation = (RowLocation)execRow.getColumn(execRow.nColumns());
            boolean bl = this.baseCC.fetch(this.baseRowLocation, this.rowArray, null);
            if (bl) {
                int n = 0;
                while (n < this.indexCols.length) {
                    if (this.indexCols[n] != -1) {
                        this.compactRow.setColumn(n + 1, execRow.getColumn(this.indexCols[n] + 1));
                    }
                    ++n;
                }
                this.setCurrentRow(this.compactRow);
                this.currentRow = this.compactRow;
            } else {
                this.clearCurrentRow();
                this.currentRow = null;
            }
        } else {
            this.clearCurrentRow();
            this.currentRow = null;
        }
        return this.currentRow;
    }

    public boolean isForUpdate() {
        return this.source.isForUpdate();
    }

    public IndexRowToBaseRowResultSet(long l, int n, Activation activation, NoPutResultSet noPutResultSet, GeneratedMethod generatedMethod, int n2, String string, int n3, int n4, int n5, GeneratedMethod generatedMethod2, boolean bl, double d, double d2, GeneratedMethod generatedMethod3) throws StandardException {
        super(activation, n2, d, d2);
        this.scoci = (StaticCompiledOpenConglomInfo)this.activation.getPreparedStatement().getSavedObject(n);
        TransactionController transactionController = this.activation.getTransactionController();
        this.dcoci = transactionController.getDynamicCompiledConglomInfo(l);
        this.source = noPutResultSet;
        this.resultRowAllocator = generatedMethod;
        this.indexName = string;
        this.forUpdate = bl;
        this.restriction = generatedMethod2;
        this.closeCleanup = generatedMethod3;
        this.accessedHeapCols = null;
        if (n3 != -1) {
            this.accessedHeapCols = (FormatableBitSet)activation.getPreparedStatement().getSavedObject(n3);
        }
        if (n4 != -1) {
            this.accessedIndexCols = (FormatableBitSet)activation.getPreparedStatement().getSavedObject(n4);
        }
        if (this.accessedIndexCols == null) {
            this.accessedAllCols = this.accessedHeapCols;
        } else {
            this.accessedAllCols = new FormatableBitSet(this.accessedHeapCols);
            this.accessedAllCols.or(this.accessedIndexCols);
        }
        this.indexCols = ((ReferencedColumnsDescriptorImpl)activation.getPreparedStatement().getSavedObject(n5)).getReferencedColumnPositions();
        this.resultRow = (ExecRow)generatedMethod.invoke(this.activation);
        this.compactRow = this.getCompactRow(this.resultRow, this.accessedHeapCols, this.accessedIndexCols, false);
        if (this.accessedHeapCols == null) {
            this.rowArray = this.resultRow.getRowArray();
        } else {
            int n6 = this.accessedHeapCols.getNumBitsSet();
            int n7 = this.accessedHeapCols.size();
            this.rowArray = new DataValueDescriptor[n7];
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            while (n10 < n7) {
                if (this.accessedIndexCols != null && this.accessedIndexCols.get(n10)) {
                    ++n9;
                } else if (this.accessedHeapCols.get(n10)) {
                    this.rowArray[n10] = this.resultRow.getRowArray()[n10];
                    ++n8;
                }
                ++n10;
            }
        }
        this.constructorTime += this.getElapsedMillis(this.beginTime);
    }
}

