/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.ForeignKeyRIChecker;
import org.apache.derby.impl.sql.execute.GenericRIChecker;
import org.apache.derby.impl.sql.execute.ReferencedKeyRIChecker;

public class RISetChecker {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1998, 2004.";
    private GenericRIChecker[] checkers;

    void reopen() throws StandardException {
    }

    public void doPKCheck(ExecRow execRow, boolean bl) throws StandardException {
        if (this.checkers == null) {
            return;
        }
        int n = 0;
        while (n < this.checkers.length) {
            if (this.checkers[n] instanceof ReferencedKeyRIChecker) {
                this.checkers[n].doCheck(execRow, bl);
            }
            ++n;
        }
    }

    public void doFKCheck(ExecRow execRow) throws StandardException {
        if (this.checkers == null) {
            return;
        }
        int n = 0;
        while (n < this.checkers.length) {
            if (this.checkers[n] instanceof ForeignKeyRIChecker) {
                this.checkers[n].doCheck(execRow);
            }
            ++n;
        }
    }

    public void doRICheck(int n, ExecRow execRow, boolean bl) throws StandardException {
        this.checkers[n].doCheck(execRow, bl);
    }

    public void close() throws StandardException {
        if (this.checkers == null) {
            return;
        }
        int n = 0;
        while (n < this.checkers.length) {
            this.checkers[n].close();
            ++n;
        }
    }

    public RISetChecker(TransactionController transactionController, FKInfo[] fKInfoArray) throws StandardException {
        if (fKInfoArray == null) {
            return;
        }
        this.checkers = new GenericRIChecker[fKInfoArray.length];
        int n = 0;
        while (n < fKInfoArray.length) {
            this.checkers[n] = fKInfoArray[n].type == 1 ? new ForeignKeyRIChecker(transactionController, fKInfoArray[n]) : new ReferencedKeyRIChecker(transactionController, fKInfoArray[n]);
            ++n;
        }
    }
}

