/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.sql.dictionary.GenericDescriptorList;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;

public class TriggerInfo
implements Formatable {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1999, 2004.";
    public TriggerDescriptor[] triggerArray;
    public String[] columnNames;
    public int[] columnIds;

    boolean hasTrigger(boolean bl, boolean bl2) {
        if (this.triggerArray == null) {
            return false;
        }
        return this.hasTrigger(new Boolean(bl), new Boolean(bl2));
    }

    private boolean hasTrigger(Boolean bl, Boolean bl2) {
        if (this.triggerArray == null) {
            return false;
        }
        int n = 0;
        while (n < this.triggerArray.length) {
            if (!(bl != null && this.triggerArray[n].isBeforeTrigger() != bl.booleanValue() || bl2 != null && this.triggerArray[n].isRowTrigger() != bl2.booleanValue())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    TriggerDescriptor[] getTriggerArray() {
        return this.triggerArray;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        ArrayUtil.writeArray(objectOutput, this.triggerArray);
        ArrayUtil.writeIntArray(objectOutput, this.columnIds);
        ArrayUtil.writeArray(objectOutput, this.columnNames);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.triggerArray = new TriggerDescriptor[ArrayUtil.readArrayLength(objectInput)];
        ArrayUtil.readArrayItems(objectInput, this.triggerArray);
        this.columnIds = ArrayUtil.readIntArray(objectInput);
        int n = ArrayUtil.readArrayLength(objectInput);
        if (n > 0) {
            this.columnNames = new String[n];
            ArrayUtil.readArrayItems(objectInput, this.columnNames);
        }
    }

    public int getTypeFormatId() {
        return 317;
    }

    public String toString() {
        return "";
    }

    public TriggerInfo() {
    }

    public TriggerInfo(TableDescriptor tableDescriptor, int[] nArray, GenericDescriptorList genericDescriptorList) throws StandardException {
        this.columnIds = nArray;
        if (this.columnIds != null) {
            this.columnNames = new String[this.columnIds.length];
            int n = 0;
            while (n < this.columnIds.length) {
                this.columnNames[n] = tableDescriptor.getColumnDescriptor(this.columnIds[n]).getColumnName();
                ++n;
            }
        }
        Enumeration enumeration = genericDescriptorList.elements();
        int n = genericDescriptorList.size();
        this.triggerArray = new TriggerDescriptor[n];
        int n2 = 0;
        while (n2 < n) {
            this.triggerArray[n2] = (TriggerDescriptor)enumeration.nextElement();
            ++n2;
        }
    }

    private TriggerInfo(TriggerDescriptor[] triggerDescriptorArray, int[] nArray, String[] stringArray) {
        this.columnIds = nArray;
        this.columnNames = stringArray;
        this.triggerArray = triggerDescriptorArray;
    }
}

