/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.impl.store.access.RAMTransaction;

public class RAMTransactionContext
extends ContextImpl {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    protected RAMTransaction transaction;
    private boolean abortAll;

    public void cleanupOnError(Throwable throwable) throws StandardException {
        boolean bl = false;
        if (!this.abortAll && throwable instanceof StandardException) {
            StandardException standardException = (StandardException)throwable;
            if (standardException.getSeverity() < 30000) {
                return;
            }
            if (standardException.getSeverity() >= 40000) {
                bl = true;
            }
        } else {
            bl = true;
        }
        if (this.transaction != null) {
            try {
                this.transaction.invalidateConglomerateCache();
            }
            catch (StandardException standardException) {
                // empty catch block
            }
            this.transaction.closeControllers(true);
        }
        if (bl) {
            this.transaction = null;
            this.popMe();
        }
    }

    RAMTransaction getTransaction() {
        return this.transaction;
    }

    void setTransaction(RAMTransaction rAMTransaction) {
        this.transaction = rAMTransaction;
    }

    public RAMTransactionContext(ContextManager contextManager, String string, RAMTransaction rAMTransaction, boolean bl) throws StandardException {
        super(contextManager, string);
        this.abortAll = bl;
        this.transaction = rAMTransaction;
        this.transaction.setContext(this);
    }
}

