/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.btree.BTree;
import org.apache.derby.impl.store.access.btree.ControlRow;
import org.apache.derby.impl.store.access.btree.OpenBTree;

class BTreePostCommit
implements Serviceable {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private AccessFactory access_factory = null;
    private long page_number = -1L;
    protected BTree btree = null;

    public boolean serviceASAP() {
        return true;
    }

    public boolean serviceImmediately() {
        return false;
    }

    private final void doShrink(OpenBTree openBTree, DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        ControlRow controlRow = null;
        controlRow = ControlRow.Get(openBTree, 1L);
        controlRow.shrinkFor(openBTree, dataValueDescriptorArray);
        controlRow = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int performWork(ContextManager contextManager) throws StandardException {
        boolean bl;
        block6: {
            bl = false;
            TransactionManager transactionManager = (TransactionManager)this.access_factory.getAndNameTransaction(contextManager, "SystemTransaction");
            TransactionManager transactionManager2 = transactionManager.getInternalTransaction();
            OpenBTree openBTree = new OpenBTree();
            try {
                try {
                    ConglomerateController conglomerateController = this.btree.lockTable(transactionManager2, 132, 7, 4);
                    openBTree.init(null, transactionManager2, null, transactionManager2.getRawStoreXact(), false, 4, 7, this.btree.getBtreeLockingPolicy(transactionManager2.getRawStoreXact(), 7, 2, 4, conglomerateController, openBTree), this.btree, null, null);
                    DataValueDescriptor[] dataValueDescriptorArray = this.purgeCommittedDeletes(openBTree, this.page_number);
                    if (dataValueDescriptorArray != null) {
                        this.doShrink(openBTree, dataValueDescriptorArray);
                    }
                    openBTree.close();
                }
                catch (StandardException standardException) {
                    if (standardException.getMessageId().equals("40XL1") || standardException.getMessageId().equals("40001")) {
                        bl = true;
                    }
                    Object var7_10 = null;
                    transactionManager2.commit();
                    transactionManager2.destroy();
                    break block6;
                }
                Object var7_9 = null;
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                transactionManager2.commit();
                transactionManager2.destroy();
                throw throwable;
            }
            transactionManager2.commit();
            transactionManager2.destroy();
        }
        if (!bl) return 1;
        return 2;
    }

    private final DataValueDescriptor[] getShrinkKey(OpenBTree openBTree, ControlRow controlRow, int n) throws StandardException {
        Object[] objectArray = openBTree.getConglomerate().createTemplate();
        controlRow.page.fetchFromSlot(null, n, objectArray, null, true);
        return objectArray;
    }

    private final DataValueDescriptor[] purgeCommittedDeletes(OpenBTree openBTree, long l) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray;
        ControlRow controlRow;
        block9: {
            controlRow = null;
            dataValueDescriptorArray = null;
            try {
                controlRow = ControlRow.GetNoWait(openBTree, l);
                if (controlRow == null) break block9;
                Page page = controlRow.page;
                int n = page.recordCount() - 1 - page.nonDeletedRecordCount();
                if (n > 0) {
                    int n2 = page.recordCount() - 1;
                    while (n2 > 0) {
                        if (page.isDeletedAtSlot(n2)) {
                            if (page.recordCount() == 2) {
                                dataValueDescriptorArray = this.getShrinkKey(openBTree, controlRow, n2);
                            }
                            page.purgeAtSlot(n2, 1, true);
                        }
                        --n2;
                    }
                }
                if (page.recordCount() == 1) {
                    // empty if block
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (controlRow != null) {
                    controlRow.release();
                }
                throw throwable;
            }
        }
        Object var7_8 = null;
        if (controlRow != null) {
            controlRow.release();
        }
        return dataValueDescriptorArray;
    }

    BTreePostCommit(AccessFactory accessFactory, BTree bTree, long l) {
        this.access_factory = accessFactory;
        this.btree = bTree;
        this.page_number = l;
    }
}

