/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.PageTimeStamp;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.FileContainer;

public abstract class CachedPage
extends BasePage
implements Cacheable {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    protected static final int PAGE_FORMAT_ID_SIZE = 4;
    public static final int WRITE_SYNC = 1;
    public static final int WRITE_NO_SYNC = 2;
    protected boolean alreadyReadPage;
    protected byte[] pageData;
    protected boolean isDirty;
    protected boolean preDirty;
    protected int initialRowCount;
    private long containerRowCount;
    protected CacheManager pageCache;
    protected CacheManager containerCache;
    protected BaseDataFileFactory dataFactory;

    public final void setFactory(BaseDataFileFactory baseDataFileFactory) {
        this.dataFactory = baseDataFileFactory;
        this.pageCache = baseDataFileFactory.getPageCache();
        this.containerCache = baseDataFileFactory.getContainerCache();
    }

    protected void initialize() {
        super.initialize();
        this.isDirty = false;
        this.preDirty = false;
        this.initialRowCount = 0;
        this.containerRowCount = 0L;
    }

    public Cacheable setIdentity(Object object) throws StandardException {
        this.initialize();
        PageKey pageKey = (PageKey)object;
        FileContainer fileContainer = (FileContainer)this.containerCache.find(pageKey.getContainerId());
        this.setContainerRowCount(fileContainer.getEstimatedRowCount(0));
        try {
            if (!this.alreadyReadPage) {
                this.readPage(fileContainer, pageKey);
            } else {
                this.alreadyReadPage = false;
            }
            int n = this.getTypeFormatId();
            int n2 = FormatIdUtil.readFormatIdInteger(this.pageData);
            if (n != n2) {
                Cacheable cacheable = this.changeInstanceTo(n2, pageKey).setIdentity(object);
                Object var5_7 = null;
                this.containerCache.release(fileContainer);
                fileContainer = null;
                return cacheable;
            }
            this.initFromData(fileContainer, pageKey);
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.containerCache.release(fileContainer);
            fileContainer = null;
            throw throwable;
        }
        Object var5_8 = null;
        this.containerCache.release(fileContainer);
        fileContainer = null;
        this.fillInIdentity(pageKey);
        this.initialRowCount = 0;
        return this;
    }

    public Cacheable createIdentity(Object object, Object object2) throws StandardException {
        this.initialize();
        PageKey pageKey = (PageKey)object;
        int[] nArray = (int[])object2;
        if (nArray[0] == -1) {
            throw StandardException.newException("XSDB1.D", pageKey);
        }
        if (nArray[0] != this.getTypeFormatId()) {
            return this.changeInstanceTo(nArray[0], pageKey).createIdentity(object, object2);
        }
        this.initializeHeaders(5);
        this.createPage(pageKey, nArray);
        this.fillInIdentity(pageKey);
        this.initialRowCount = 0;
        if ((nArray[1] & 1) != 0 || (nArray[1] & 2) != 0) {
            this.writePage(pageKey, (nArray[1] & 1) != 0);
        }
        return this;
    }

    private CachedPage changeInstanceTo(int n, PageKey pageKey) throws StandardException {
        CachedPage cachedPage;
        try {
            cachedPage = (CachedPage)Monitor.newInstanceFromIdentifier(n);
        }
        catch (StandardException standardException) {
            if (standardException.getSeverity() > 20000) {
                throw standardException;
            }
            throw StandardException.newException("XSDB1.D", standardException, (Object)pageKey);
        }
        cachedPage.setFactory(this.dataFactory);
        if (this.pageData != null) {
            cachedPage.alreadyReadPage = true;
            cachedPage.usePageBuffer(this.pageData);
        }
        return cachedPage;
    }

    public boolean isDirty() {
        CachedPage cachedPage = this;
        synchronized (cachedPage) {
            boolean bl = this.isDirty || this.preDirty;
            Object var2_3 = null;
            return bl;
        }
    }

    public boolean isActuallyDirty() {
        CachedPage cachedPage = this;
        synchronized (cachedPage) {
            boolean bl = this.isDirty;
            Object var2_3 = null;
            return bl;
        }
    }

    public void preDirty() {
        CachedPage cachedPage = this;
        synchronized (cachedPage) {
            if (!this.isDirty) {
                this.preDirty = true;
            }
        }
    }

    protected void releaseExclusive() {
        if (this.isDirty && !this.isOverflowPage() && this.containerRowCount / 8L < (long)this.recordCount()) {
            int n;
            int n2 = this.internalNonDeletedRecordCount();
            int n3 = n2 - this.initialRowCount;
            int n4 = n = n3 > 0 ? n3 : -n3;
            if (this.containerRowCount / 8L < (long)n) {
                FileContainer fileContainer = null;
                try {
                    block9: {
                        try {
                            fileContainer = (FileContainer)this.containerCache.find(this.identity.getContainerId());
                            if (fileContainer == null) break block9;
                            fileContainer.updateEstimatedRowCount(n3);
                            this.setContainerRowCount(fileContainer.getEstimatedRowCount(0));
                            this.initialRowCount = n2;
                            fileContainer.trackUnfilledPage(this.identity.getPageNumber(), this.unfilled());
                        }
                        catch (StandardException standardException) {
                            Object var6_6 = null;
                            if (fileContainer != null) {
                                this.containerCache.release(fileContainer);
                            }
                        }
                    }
                    Object var6_5 = null;
                    if (fileContainer != null) {
                        this.containerCache.release(fileContainer);
                    }
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (fileContainer != null) {
                        this.containerCache.release(fileContainer);
                    }
                    throw throwable;
                }
            }
        }
        super.releaseExclusive();
    }

    protected void setDirty() {
        CachedPage cachedPage = this;
        synchronized (cachedPage) {
            this.isDirty = true;
            this.preDirty = false;
        }
    }

    /*
     * Exception decompiling
     */
    public void clean(boolean var1_1) throws StandardException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 19[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void clearIdentity() {
        this.alreadyReadPage = false;
        super.clearIdentity();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readPage(FileContainer fileContainer, PageKey pageKey) throws StandardException {
        int n = fileContainer.getPageSize();
        this.setPageArray(n);
        int n2 = 0;
        while (true) {
            try {
                fileContainer.readPage(pageKey.getPageNumber(), this.pageData);
                return;
            }
            catch (IOException iOException) {
                if (++n2 <= 4) continue;
                StandardException standardException = StandardException.newException("XSDG0.D", iOException, (Object)pageKey, (Object)new Integer(n));
                if (this.dataFactory.getLogFactory().inRFR()) throw standardException;
                continue;
            }
            break;
        }
    }

    private void writePage(PageKey pageKey, boolean bl) throws StandardException {
        block10: {
            FileContainer fileContainer;
            this.writeFormatId(pageKey);
            this.writePage(pageKey);
            LogInstant logInstant = this.getLastLogInstant();
            this.dataFactory.flush(logInstant);
            if (logInstant != null) {
                this.clearLastLogInstant();
            }
            if ((fileContainer = (FileContainer)this.containerCache.find(pageKey.getContainerId())) != null) {
                try {
                    block9: {
                        try {
                            fileContainer.writePage(pageKey.getPageNumber(), this.pageData, bl);
                            if (this.isOverflowPage() || !this.isDirty()) break block9;
                            fileContainer.trackUnfilledPage(pageKey.getPageNumber(), this.unfilled());
                            int n = this.internalNonDeletedRecordCount();
                            if (n == this.initialRowCount) break block9;
                            fileContainer.updateEstimatedRowCount(n - this.initialRowCount);
                            this.setContainerRowCount(fileContainer.getEstimatedRowCount(0));
                            this.initialRowCount = n;
                        }
                        catch (IOException iOException) {
                            throw StandardException.newException("XSDG1.D", iOException, (Object)pageKey, (Object)new Integer(fileContainer.getPageSize()));
                        }
                    }
                    Object var6_7 = null;
                    this.containerCache.release(fileContainer);
                    fileContainer = null;
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    this.containerCache.release(fileContainer);
                    fileContainer = null;
                    throw throwable;
                }
            }
            StandardException standardException = StandardException.newException("40XD2", pageKey.getContainerId());
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDG1.D", standardException, (Object)pageKey, (Object)new Integer(fileContainer.getPageSize())));
        }
        CachedPage cachedPage = this;
        synchronized (cachedPage) {
            this.isDirty = false;
            this.preDirty = false;
        }
    }

    public void setContainerRowCount(long l) {
        this.containerRowCount = l;
    }

    protected void setPageArray(int n) throws StandardException {
        if (this.pageData == null || this.pageData.length != n) {
            this.pageData = new byte[n];
            if (this.pageData == null || this.pageData.length != n) {
                throw StandardException.newException("XSDBA.D", "PAGE");
            }
            this.usePageBuffer(this.pageData);
        }
    }

    protected abstract void usePageBuffer(byte[] var1);

    protected abstract void initFromData(FileContainer var1, PageKey var2) throws StandardException;

    protected abstract void createPage(PageKey var1, int[] var2) throws StandardException;

    protected abstract void writePage(PageKey var1) throws StandardException;

    protected abstract void writeFormatId(PageKey var1) throws StandardException;

    public abstract boolean spaceForInsert() throws StandardException;

    public abstract boolean spaceForInsert(Object[] var1, FormatableBitSet var2, int var3) throws StandardException;

    public abstract void setTimeStamp(PageTimeStamp var1) throws StandardException;

    public abstract PageTimeStamp currentTimeStamp();

    public abstract boolean equalTimeStamp(PageTimeStamp var1) throws StandardException;

    public abstract int getTypeFormatId();
}

