/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.LogicalPageOperation;

public final class DeleteOperation
extends LogicalPageOperation {
    private static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    protected int doMeSlot;
    protected boolean delete;
    protected transient ByteArray preparedLog;

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        CompressedNumber.writeInt(objectOutput, this.doMeSlot);
        objectOutput.writeBoolean(this.delete);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.doMeSlot = CompressedNumber.readInt(objectInput);
        this.delete = objectInput.readBoolean();
    }

    public int getTypeFormatId() {
        return 101;
    }

    public void doMe(Transaction transaction, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        this.page.setDeleteStatus(logInstant, this.doMeSlot, this.delete);
    }

    public void undoMe(Transaction transaction, BasePage basePage, int n, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        int n2 = basePage.findRecordById(n, 0);
        basePage.setDeleteStatus(logInstant, n2, !this.delete);
        basePage.setAuxObject(null);
    }

    public void restoreLoggedRow(Object[] objectArray, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        Page page = null;
        try {
            page = this.getContainer().getPage(this.getPageId().getPageNumber());
            ((BasePage)page).restoreRecordFromStream(limitObjectInput, objectArray);
        }
        finally {
            Object var5_4 = null;
            if (page != null) {
                page.unlatch();
                page = null;
            }
        }
    }

    public void restoreMe(Transaction transaction, BasePage basePage, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        int n = basePage.findRecordById(this.recordId, 0);
        basePage.setDeleteStatus(logInstant, n, !this.delete);
        basePage.setAuxObject(null);
    }

    public ByteArray getPreparedLog() {
        return this.preparedLog;
    }

    private void writeOptionalDataToBuffer(RawTransaction rawTransaction) throws StandardException, IOException {
        DynamicByteArrayOutputStream dynamicByteArrayOutputStream = rawTransaction.getLogBuffer();
        int n = dynamicByteArrayOutputStream.getPosition();
        if (this.undo != null) {
            this.page.logRecord(this.doMeSlot, 0, this.recordId, null, dynamicByteArrayOutputStream, null);
        }
        int n2 = dynamicByteArrayOutputStream.getPosition() - n;
        dynamicByteArrayOutputStream.setPosition(n);
        this.preparedLog = new ByteArray(dynamicByteArrayOutputStream.getByteArray(), n, n2);
    }

    public String toString() {
        return null;
    }

    public DeleteOperation(RawTransaction rawTransaction, BasePage basePage, int n, int n2, boolean bl, LogicalUndo logicalUndo) throws StandardException {
        super(basePage, logicalUndo, n2);
        this.doMeSlot = n;
        this.delete = bl;
        try {
            this.writeOptionalDataToBuffer(rawTransaction);
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException);
        }
    }

    public DeleteOperation() {
    }
}

