/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.RePreparable;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.data.RawContainerHandle;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.data.BasePage;

public abstract class PageBasicOperation
implements Loggable,
RePreparable {
    private static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private PageKey pageId;
    private long pageVersion;
    protected transient BasePage page;
    protected transient RawContainerHandle containerHdl;
    protected transient boolean foundHere;

    public String toString() {
        return null;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.pageId.writeExternal(objectOutput);
        CompressedNumber.writeLong(objectOutput, this.pageVersion);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.pageId = PageKey.read(objectInput);
        this.pageVersion = CompressedNumber.readLong(objectInput);
    }

    public final boolean needsRedo(Transaction transaction) throws StandardException {
        if (this.findpage(transaction) == null) {
            return false;
        }
        long l = this.page.getPageVersion();
        if (l == this.pageVersion) {
            return true;
        }
        this.releaseResource(transaction);
        if (l > this.pageVersion) {
            return false;
        }
        throw StandardException.newException("XSDB4.D", this.pageId, (Object)new Long(l), (Object)new Long(this.pageVersion));
    }

    public void releaseResource(Transaction transaction) {
        if (!this.foundHere) {
            return;
        }
        if (this.page != null) {
            this.page.unlatch();
            this.page = null;
        }
        if (this.containerHdl != null) {
            this.containerHdl.close();
            this.containerHdl = null;
        }
        this.foundHere = false;
    }

    public int group() {
        return 384;
    }

    public ByteArray getPreparedLog() throws StandardException {
        return null;
    }

    public void reclaimPrepareLocks(Transaction transaction, LockingPolicy lockingPolicy) throws StandardException {
    }

    protected final void resetPageNumber(long l) {
        this.pageId = new PageKey(this.pageId.getContainerId(), l);
    }

    protected final PageKey getPageId() {
        return this.pageId;
    }

    public final BasePage findpage(Transaction transaction) throws StandardException {
        this.releaseResource(transaction);
        RawTransaction rawTransaction = (RawTransaction)transaction;
        this.containerHdl = rawTransaction.openDroppedContainer(this.pageId.getContainerId(), null);
        if (this.containerHdl == null) {
            throw StandardException.newException("40XD2", this.pageId.getContainerId());
        }
        this.foundHere = true;
        if (this.containerHdl.getContainerStatus() == 4) {
            this.releaseResource(transaction);
            return null;
        }
        StandardException standardException = null;
        try {
            this.page = (BasePage)this.containerHdl.getAnyPage(this.pageId.getPageNumber());
        }
        catch (StandardException standardException2) {
            standardException = standardException2;
        }
        if (this.page == null && standardException != null && this.pageVersion == 0L && PropertyUtil.getSystemBoolean("derby.storage.patchInitPageRecoverError")) {
            this.page = this.getPageForLoadTran(transaction);
        }
        if (this.page == null && standardException != null && rawTransaction.inRollForwardRecovery()) {
            this.page = this.getPageForLoadTran(transaction);
        }
        if (this.page == null) {
            if (standardException != null) {
                throw standardException;
            }
            throw StandardException.newException("XSDB5.D", this.pageId);
        }
        return this.page;
    }

    protected BasePage getPageForLoadTran(Transaction transaction) throws StandardException {
        return null;
    }

    public final Page getPage() {
        return this.page;
    }

    public final long getPageVersion() {
        return this.pageVersion;
    }

    public abstract void restoreMe(Transaction var1, BasePage var2, LogInstant var3, LimitObjectInput var4) throws StandardException, IOException;

    public abstract void doMe(Transaction var1, LogInstant var2, LimitObjectInput var3) throws StandardException, IOException;

    public abstract int getTypeFormatId();

    protected PageBasicOperation(BasePage basePage) {
        this.page = basePage;
        this.pageId = basePage.getPageId();
        this.pageVersion = basePage.getPageVersion();
    }

    public PageBasicOperation() {
    }
}

