/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.store.access.DatabaseInstant;
import org.apache.derby.iapi.store.access.FileResource;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.RemoveFile;
import org.apache.derby.impl.store.raw.data.RemoveFileOperation;
import org.apache.derby.io.StorageFile;

public class RFResource
implements FileResource {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1998, 2004.";
    protected final BaseDataFileFactory factory;

    /*
     * Loose catch block
     */
    public long add(String string, InputStream inputStream) throws StandardException {
        long l;
        block23: {
            OutputStream outputStream = null;
            if (this.factory.isReadOnly()) {
                throw StandardException.newException("XSDFB.S");
            }
            l = this.factory.getNextId();
            Object object2222 = this.getAsFile(string, l);
            if (object2222.exists()) {
                throw StandardException.newException("XSDF0.S", object2222);
            }
            StorageFile storageFile = object2222.getParentDir();
            if (!storageFile.exists() && !storageFile.mkdirs()) {
                throw StandardException.newException("XSDF3.S", storageFile);
            }
            outputStream = object2222.getOutputStream();
            byte[] byArray = new byte[4096];
            this.factory.writeInProgress();
            try {
                int n;
                while ((n = inputStream.read(byArray)) != -1) {
                    outputStream.write(byArray, 0, n);
                }
                this.factory.writableStorageFactory.sync(outputStream, false);
            }
            finally {
                Object var15_11 = null;
                this.factory.writeFinished();
            }
            Object var7_14 = null;
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException object2222) {
                // empty catch block
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                break block23;
            }
            catch (IOException object2222) {}
            break block23;
            {
                catch (IOException iOException) {
                    throw StandardException.newException("XSDFF.S", iOException);
                }
            }
            catch (Throwable throwable) {
                Object var7_15 = null;
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return l;
    }

    public void remove(String string, long l, boolean bl) throws StandardException {
        if (this.factory.isReadOnly()) {
            throw StandardException.newException("XSDFB.S");
        }
        ContextManager contextManager = ContextService.getFactory().getCurrentContextManager();
        Transaction transaction = this.factory.getRawStoreFactory().findUserTransaction(contextManager, "UserTransaction");
        transaction.logAndDo(this.privRemoveFileOperation(string, l, bl));
        if (bl) {
            Serviceable serviceable = this.privRemoveFile(this.getAsFile(string, l));
            transaction.addPostCommitWork(serviceable);
        }
    }

    public long replace(String string, long l, InputStream inputStream, boolean bl) throws StandardException {
        if (this.factory.isReadOnly()) {
            throw StandardException.newException("XSDFB.S");
        }
        this.remove(string, l, bl);
        long l2 = this.add(string, inputStream);
        return l2;
    }

    public StorageFile getAsFile(String string, long l) {
        String string2 = this.factory.getVersionedName(string, l);
        return this.factory.storageFactory.newStorageFile(string2);
    }

    public StorageFile getAsFile(String string) {
        return this.factory.storageFactory.newStorageFile(string);
    }

    public InputStream getAsStream(String string, long l) throws IOException {
        return this.getAsFile(string, l).getInputStream();
    }

    public InputStream getAsStream(String string) throws IOException {
        return this.getAsFile(string).getInputStream();
    }

    public void purgeOldGenerations(DatabaseInstant databaseInstant) {
    }

    public char getSeparatorChar() {
        return this.factory.storageFactory.getSeparator();
    }

    protected Serviceable privRemoveFile(StorageFile storageFile) {
        return new RemoveFile(storageFile);
    }

    protected RemoveFileOperation privRemoveFileOperation(String string, long l, boolean bl) {
        return new RemoveFileOperation(string, l, bl);
    }

    public RFResource(BaseDataFileFactory baseDataFileFactory) {
        this.factory = baseDataFileFactory;
    }
}

